/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.rest.apidoc;

import com.infor.erpln.c4ws.util.C4WSPropertiesManager;
import com.infor.erpln.c4ws.util.oauth.BaseUriUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SwaggerUIServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Pattern BDE_PATTERN = Pattern.compile("http.*/apidoc/rest/([^/]+)(/([^/]+))?$");
    private boolean jsonAllowed = false;

    public void init() throws ServletException {
        C4WSPropertiesManager propertiesManager = (C4WSPropertiesManager)this.getServletContext().getAttribute("com.infor.erpln.c4ws.util.C4WSPropertiesManager");
        this.jsonAllowed = propertiesManager.getProperties().isJsonSupported();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.jsonAllowed) {
            super.service(req, resp);
        } else {
            resp.setStatus(404);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String connectionPoint = null;
        String bdeName = null;
        String forwardURL = null;
        String baseUri = BaseUriUtil.getBaseUri((HttpServletRequest)req);
        Matcher matcher = BDE_PATTERN.matcher(baseUri);
        if (!matcher.matches()) {
            resp.setStatus(400);
            return;
        }
        bdeName = matcher.group(1);
        connectionPoint = matcher.group(3);
        StringBuffer urlBuffer = new StringBuffer(baseUri);
        int i = urlBuffer.indexOf("/apidoc/rest/");
        urlBuffer.setLength(i + 8);
        urlBuffer.append("ui/index.html?url=");
        urlBuffer.append(this.encode(urlBuffer.substring(0, i + 8))).append(this.encode("json/"));
        if (connectionPoint != null) {
            urlBuffer.append(this.encode(connectionPoint)).append(this.encode("/"));
        }
        urlBuffer.append(this.encode(bdeName)).append(this.encode(".json"));
        forwardURL = urlBuffer.toString();
        resp.sendRedirect(forwardURL);
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }
}

