/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.rest.apidoc;

import com.infor.erpln.c4ws.util.C4WSProperties;
import com.infor.erpln.c4ws.util.C4WSPropertiesManager;
import com.infor.erpln.c4ws.util.oauth.BaseUriUtil;
import com.infor.erpln.rest.apidoc.WSDLConverter;
import com.infor.erpln.rest.apidoc.openapi.Specification;
import com.infor.erpln.soap.WSDLImporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class SwaggerJSONServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = ESAPI.getLogger(SwaggerJSONServlet.class);
    private static final Pattern REQUEST_PATTERN = Pattern.compile("https?://([^/]+)(/[^/]+)/apidoc/json/(([^/]+)/)?([^/]+).json");
    private File apiFolder;
    private boolean jsonAllowed = false;

    public void init() throws ServletException {
        C4WSPropertiesManager propertiesManager = (C4WSPropertiesManager)this.getServletContext().getAttribute("com.infor.erpln.c4ws.util.C4WSPropertiesManager");
        this.jsonAllowed = propertiesManager.getProperties().isJsonSupported();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.jsonAllowed) {
            super.service(req, resp);
        } else {
            resp.setStatus(404);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        File swaggerFile = this.getSwaggerFile(request);
        if (swaggerFile == null) {
            response.setStatus(404);
            return;
        }
        response.setContentType("application/schema+json");
        response.setContentLength((int)swaggerFile.length());
        try (FileInputStream input = new FileInputStream(swaggerFile);
             ServletOutputStream output = response.getOutputStream();){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
    }

    private File getSwaggerFile(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && pathInfo.startsWith("/")) {
            File swaggerFile = new File(this.getApiFolder(), pathInfo.substring(1));
            try {
                if (!swaggerFile.getCanonicalPath().startsWith(this.getApiFolder().getCanonicalPath())) {
                    String message = String.format("Illegal path value in servlet URL: '%s'", pathInfo);
                    LOG.error(Logger.SECURITY_FAILURE, message);
                    return null;
                }
            }
            catch (IOException ex) {
                LOG.error(Logger.EVENT_FAILURE, "Unexpected error", (Throwable)ex);
                return null;
            }
            if (!swaggerFile.exists()) {
                this.createSwaggerFile(swaggerFile, request);
            }
            return swaggerFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSwaggerFile(File swaggerFile, HttpServletRequest request) {
        String baseUri = BaseUriUtil.getBaseUri((HttpServletRequest)request);
        String serverAndPort = null;
        String applicationContext = "/c4ws";
        String connectionpoint = null;
        String bdeName = null;
        Matcher matcher = REQUEST_PATTERN.matcher(baseUri);
        if (matcher.matches()) {
            serverAndPort = matcher.group(1);
            applicationContext = matcher.group(2);
            connectionpoint = matcher.group(4);
            bdeName = matcher.group(5);
        } else {
            LOG.error(Logger.EVENT_FAILURE, "Invalid request URL: " + baseUri);
        }
        String wsdl = null;
        try {
            WSDLImporter importer = new WSDLImporter(this.getServletContext());
            String cpForImporter = connectionpoint;
            if (cpForImporter == null) {
                C4WSProperties c4wsProperties = this.getC4WSProperties();
                String id = c4wsProperties.getCloudEnvironmentID();
                cpForImporter = c4wsProperties.getEnvironmentForID(id).getName();
            }
            importer.initialize(cpForImporter);
            try {
                wsdl = importer.getWSDL(bdeName);
            }
            finally {
                importer.close();
            }
        }
        catch (Exception e) {
            LOG.error(Logger.EVENT_FAILURE, "Could not get WSDL from LN", (Throwable)e);
            return;
        }
        WSDLConverter converter = new WSDLConverter(wsdl);
        converter.setConnectionpoint(connectionpoint);
        converter.setHostAndPort(serverAndPort);
        converter.setBasePath(applicationContext + "/rest");
        try {
            Specification specification = converter.convert();
            FileUtils.writeStringToFile((File)swaggerFile, (String)specification.toJSONString(), (String)StandardCharsets.UTF_8.name());
        }
        catch (WSDLConverter.WSDLConversionException e) {
            LOG.error(Logger.EVENT_FAILURE, "Conversion of WSDL to OpenAPI specification failed", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error(Logger.EVENT_FAILURE, "Failed to write OpenAPI specification to file", (Throwable)e);
        }
    }

    private File getApiFolder() {
        if (this.apiFolder == null) {
            this.apiFolder = new File(this.getC4WSProperties().getConfigFolder(), "openapi");
        }
        return this.apiFolder;
    }

    private C4WSProperties getC4WSProperties() {
        C4WSPropertiesManager manager = (C4WSPropertiesManager)this.getServletContext().getAttribute("com.infor.erpln.c4ws.util.C4WSPropertiesManager");
        return manager.getProperties();
    }
}

