/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.lnrest;

import com.infor.erpln.c4ws.util.ConnectionHelper;
import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.jca.restclient.RestReply;
import com.infor.erpln.jca.restclient.RestRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class LNRestServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = ESAPI.getLogger(LNRestServlet.class);
    private final Set<String> skipHeaders = new HashSet();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.skipHeaders.add("authorization");
        this.skipHeaders.add("content-length");
        this.skipHeaders.add("connection");
        this.skipHeaders.add("keep-alive");
        this.skipHeaders.add("proxy-authenticate");
        this.skipHeaders.add("proxy-authorization");
        this.skipHeaders.add("te");
        this.skipHeaders.add("trailer");
        this.skipHeaders.add("transfer-encoding");
        this.skipHeaders.add("upgrade");
        this.skipHeaders.add("expect");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (LOG.isInfoEnabled()) {
            this.logRequest(request);
        }
        HttpSession session = request.getSession();
        if (LOG.isDebugEnabled()) {
            String id = session.getId();
            if (session.isNew()) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Starting new HTTP session " + id);
            } else {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Using existing HTTP session " + id);
            }
        }
        RestRequest jcaRequest = this.prepareRequest(request);
        ConnectionImpl connection = null;
        try {
            connection = this.getConnection(request, response);
            if (connection != null) {
                RestReply jcaReply = jcaRequest.execute((Connection)connection);
                connection.close();
                connection = null;
                this.handleResponse(response, jcaReply);
            }
        }
        catch (ResourceException e) {
            LOG.error(Logger.EVENT_FAILURE, "LNRest call failed: " + e.getMessage(), (Throwable)e);
            String message = this.getExceptionMessages((Throwable)e);
            this.sendErrorReply(response, 500, message);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (ResourceException resourceException) {}
            }
        }
    }

    private RestRequest prepareRequest(HttpServletRequest request) throws IOException {
        RestRequest jcaRequest = new RestRequest();
        jcaRequest.setMethod(request.getMethod());
        StringBuffer uri = request.getRequestURL();
        if (request.getQueryString() != null) {
            uri.append("?").append(request.getQueryString());
        }
        jcaRequest.setUri(uri.toString());
        jcaRequest.setContextPath(request.getContextPath() + request.getServletPath());
        String protocol = request.getProtocol();
        int index = protocol.indexOf(47);
        String version = protocol.substring(index + 1);
        jcaRequest.setHttpVersion(version);
        int contentLength = request.getContentLength();
        String transferEncoding = request.getHeader("Transfer-Encoding");
        if (contentLength > 0 || transferEncoding != null) {
            try (ServletInputStream inputStream = request.getInputStream();
                 ByteArrayOutputStream requestStream = new ByteArrayOutputStream(contentLength > 0 ? contentLength : 4096);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)requestStream);
                contentLength = requestStream.size();
                jcaRequest.setRequestBody(requestStream.toByteArray());
            }
        }
        this.setRequestHeaders(request, jcaRequest, contentLength);
        return jcaRequest;
    }

    private void handleResponse(HttpServletResponse response, RestReply jcaReply) throws ResourceException, IOException {
        response.setStatus(jcaReply.getHTTPStatusCode());
        byte[] responseBody = jcaReply.getBody();
        int length = responseBody != null ? responseBody.length : 0;
        this.setReplyHeaders(response, jcaReply, length);
        if (length > 0) {
            try (ServletOutputStream outputStream = response.getOutputStream();){
                outputStream.write(responseBody);
            }
        }
    }

    private ConnectionImpl getConnection(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String connectionPoint = request.getHeader("X-Infor-LNserver");
        Connection connection = null;
        try {
            connection = ConnectionHelper.getLNRestConnection((String)connectionPoint, (HttpServletRequest)request);
        }
        catch (ConnectionHelper.OAuthValidationException ex) {
            String message = String.format("OAuth validation failed with error code %d: %s", ex.getStatus().getErrorCode(), ex.getStatus().getErrorMessage());
            LOG.error(Logger.EVENT_FAILURE, message);
            this.sendErrorReply(response, 401, message);
        }
        catch (ConnectionHelper.BasicAuthenticationException ex) {
            this.sendBasicAuthChallenge(response);
        }
        catch (ResourceException e) {
            LOG.error(Logger.EVENT_FAILURE, "getConnection failed", (Throwable)e);
            String message = this.getExceptionMessages((Throwable)e);
            this.sendErrorReply(response, 500, message);
        }
        return (ConnectionImpl)connection;
    }

    private void setRequestHeaders(HttpServletRequest request, RestRequest jcaRequest, int contentLength) {
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            if (!this.passRequestHeader(name)) continue;
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                jcaRequest.addHeader(name, value);
            }
        }
        if (contentLength > 0) {
            jcaRequest.addHeader("Content-Length", String.valueOf(contentLength));
        }
    }

    private boolean passRequestHeader(String headerName) {
        return !this.skipHeaders.contains(headerName.toLowerCase());
    }

    private void setReplyHeaders(HttpServletResponse response, RestReply jcaReply, int length) throws ResourceException {
        boolean hasContentType = false;
        boolean hasCacheControl = false;
        for (String name : jcaReply.getHeaders()) {
            List values = jcaReply.getHeaderValue(name);
            for (String value : values) {
                response.addHeader(name, value);
            }
            if ("content-type".equals(name)) {
                hasContentType = true;
                continue;
            }
            if (!"cache-control".equals(name) && !"expires".equals(name)) continue;
            hasCacheControl = true;
        }
        if (!hasContentType) {
            response.setHeader("Content-Type", "application/json");
        }
        if (!hasCacheControl) {
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, max-age=0");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "Thu, 01 Jan 1970 00:00:00 GMT");
        }
        if (length > 0) {
            response.setIntHeader("Content-Length", length);
        }
    }

    private String getExceptionMessages(Throwable exception) {
        StringBuffer messages = new StringBuffer();
        Throwable ex = exception;
        while (ex != null) {
            if (ex.getMessage() != null) {
                if (messages.length() > 0) {
                    messages.append('\n');
                }
                messages.append(ex.getMessage());
            }
            ex = ex != ex.getCause() ? ex.getCause() : null;
        }
        return messages.toString();
    }

    private void sendErrorReply(HttpServletResponse response, int status, String message) throws IOException {
        response.setHeader("Content-Type", "text/plain; charset=utf-8");
        response.setStatus(status);
        try (ServletOutputStream out = response.getOutputStream();){
            out.write(message.getBytes(StandardCharsets.UTF_8));
        }
    }

    private void sendBasicAuthChallenge(HttpServletResponse response) {
        response.setHeader("WWW-Authenticate", "Basic realm=\"lnrest\"");
        response.setStatus(401);
    }

    private void logRequest(HttpServletRequest request) {
        StringBuffer logBuffer = new StringBuffer();
        StringBuffer url = request.getRequestURL();
        String query = request.getQueryString();
        if (query != null) {
            url.append("?").append(query);
        }
        logBuffer.append(request.getMethod() + ": " + url).append("\n");
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            logBuffer.append("\tHeader " + name + ": " + request.getHeader(name)).append("\n");
        }
        LOG.info(Logger.EVENT_UNSPECIFIED, logBuffer.toString());
    }
}

