/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.transform;

import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.transform.ICognosXMLWriter;
import com.infor.erpln.ir.connector.transform.model.Column;
import com.infor.erpln.ir.connector.transform.model.Row;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class StaxCognosXMLWriter
implements ICognosXMLWriter {
    private static final String CANNOT_WRITE_DATA = "Cannot write data to STAX Cognos XML writer.";
    private static final String CANNOT_CLOSE = "Cannot close Cognos XML report.";
    private static final String CANNOT_WRITE_METADATA = "Cannot write metadata to STAX Cognos XML writer.";
    private static final int NR_TABS = 3;
    private static final XMLEventFactory EVENTFACTORY = XMLEventFactory.newInstance();
    private static final XMLOutputFactory OUTPUTFACTORY = XMLOutputFactory.newInstance();
    private static final XMLEvent END = EVENTFACTORY.createIgnorableSpace("\n");
    private static final XMLEvent TAB = EVENTFACTORY.createIgnorableSpace("\t");
    private static final String NAMESPACE_ATTR = "xmlns";
    private static final String COGNOS_NAMESPACE_NAME = "http://developer.cognos.com/schemas/xmldata/1/";
    private static final XMLEvent SCHEMA_NAMESPACE = EVENTFACTORY.createNamespace("xs", "http://www.w3.org/2001/XMLSchema-instance");
    private static final List<XMLEvent> NAMESPACES = Arrays.asList(SCHEMA_NAMESPACE);
    private static final String ENCODING = "utf-8";
    private static final String DATASET_TAG = "dataset";
    private static final String METADATA_TAG = "metadata";
    private static final String ITEM_TAG = "item";
    private static final String ITEM_NAME_ATTR = "name";
    private static final String ITEM_TYPE_ATTR = "type";
    private static final String ITEM_LENGTH_ATTR = "length";
    private static final String ITEM_PRECISION_ATTR = "precision";
    private static final String ITEM_SCALE_ATTR = "scale";
    private static final String DATA_TAG = "data";
    private static final String ROW_TAG = "row";
    private static final String VALUE_TAG = "value";
    private static Logger logger = ESAPI.getLogger(StaxCognosXMLWriter.class);
    private XMLEventWriter eventWriter;
    private OutputStream currentStream;
    private final URL outputFolder;

    public StaxCognosXMLWriter(URL outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void createDataset(OutputStream outputStream) throws IRException {
        this.currentStream = outputStream;
        try {
            this.eventWriter = OUTPUTFACTORY.createXMLEventWriter(this.currentStream, ENCODING);
            this.initializeDocument();
        }
        catch (XMLStreamException e) {
            this.closeResources();
            logger.error(Logger.EVENT_FAILURE, "Cannot create STAX Cognos XML writer.", (Throwable)e);
            throw new IRException(IRMessage.CANNOT_WRITE_COGNOS_XML, new Object[]{this.getOutputFolder().toString()});
        }
    }

    private void initializeDocument() throws XMLStreamException {
        StartDocument startDocument = EVENTFACTORY.createStartDocument();
        this.eventWriter.add(startDocument);
        this.eventWriter.setDefaultNamespace(COGNOS_NAMESPACE_NAME);
        this.eventWriter.add(END);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(EVENTFACTORY.createAttribute(NAMESPACE_ATTR, COGNOS_NAMESPACE_NAME));
        this.createStartTag(DATASET_TAG, attributes, NAMESPACES, 0L, true);
    }

    public void startMetadata() throws IRException {
        try {
            this.createStartTag(METADATA_TAG, null, null, 1L, true);
        }
        catch (XMLStreamException e) {
            this.closeResources();
            logger.error(Logger.EVENT_FAILURE, CANNOT_WRITE_METADATA, (Throwable)e);
            throw new IRException(IRMessage.CANNOT_WRITE_COGNOS_XML, new Object[]{this.getOutputFolder().toString()});
        }
    }

    public void addColumn(Column column) throws IRException {
        try {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            attributes.add(EVENTFACTORY.createAttribute(ITEM_NAME_ATTR, column.getName()));
            attributes.add(EVENTFACTORY.createAttribute(ITEM_TYPE_ATTR, column.getType().typeName()));
            if (column.getLength() != null) {
                attributes.add(EVENTFACTORY.createAttribute(ITEM_LENGTH_ATTR, column.getLength().toString()));
            }
            if (column.getPrecision() != null) {
                attributes.add(EVENTFACTORY.createAttribute(ITEM_PRECISION_ATTR, column.getPrecision().toString()));
            }
            if (column.getScale() != null) {
                attributes.add(EVENTFACTORY.createAttribute(ITEM_SCALE_ATTR, column.getScale().toString()));
            }
            this.createSingleLineElement(ITEM_TAG, attributes, null, 3L, "");
            this.eventWriter.flush();
        }
        catch (XMLStreamException e) {
            this.closeResources();
            logger.error(Logger.EVENT_FAILURE, "Cannot write column to STAX Cognos XML writer.", (Throwable)e);
            throw new IRException(IRMessage.CANNOT_WRITE_COGNOS_XML, new Object[]{this.getOutputFolder().toString()});
        }
    }

    public void endMetadata() throws IRException {
        try {
            this.createEndTag(METADATA_TAG, 1L, true);
        }
        catch (XMLStreamException e) {
            this.closeResources();
            logger.error(Logger.EVENT_FAILURE, CANNOT_WRITE_METADATA, (Throwable)e);
            throw new IRException(IRMessage.CANNOT_WRITE_COGNOS_XML, new Object[]{this.getOutputFolder().toString()});
        }
    }

    public void startData() throws IRException {
        try {
            this.createStartTag(DATA_TAG, null, null, 1L, true);
        }
        catch (XMLStreamException e) {
            this.closeResources();
            logger.error(Logger.EVENT_FAILURE, CANNOT_WRITE_DATA, (Throwable)e);
            throw new IRException(IRMessage.CANNOT_WRITE_COGNOS_XML, new Object[]{this.getOutputFolder().toString()});
        }
    }

    public void addRow(Row row) throws IRException {
        try {
            this.createStartTag(ROW_TAG, null, null, 2L, true);
            for (String value : row.getValues()) {
                this.createSingleLineElement(VALUE_TAG, null, null, 3L, value);
            }
            this.createEndTag(ROW_TAG, 2L, true);
            this.eventWriter.flush();
        }
        catch (XMLStreamException e) {
            this.closeResources();
            logger.error(Logger.EVENT_FAILURE, "Cannot write row to STAX Cognos XML writer.", (Throwable)e);
            throw new IRException(IRMessage.CANNOT_WRITE_COGNOS_XML, new Object[]{this.getOutputFolder().toString()});
        }
    }

    public void endData() throws IRException {
        try {
            this.createEndTag(DATA_TAG, 1L, true);
        }
        catch (XMLStreamException e) {
            this.closeResources();
            logger.error(Logger.EVENT_FAILURE, CANNOT_WRITE_DATA, (Throwable)e);
            throw new IRException(IRMessage.CANNOT_WRITE_COGNOS_XML, new Object[]{this.getOutputFolder().toString()});
        }
    }

    public void closeDataset() throws IRException {
        try {
            this.createEndTag(DATASET_TAG, 0L, true);
            EndDocument endDocument = EVENTFACTORY.createEndDocument();
            this.eventWriter.add(endDocument);
            this.eventWriter.flush();
            this.closeResources();
        }
        catch (XMLStreamException e) {
            logger.error(Logger.EVENT_FAILURE, CANNOT_CLOSE, (Throwable)e);
            throw new IRException(IRMessage.CANNOT_WRITE_COGNOS_XML, new Object[]{this.getOutputFolder().toString()});
        }
    }

    private void createSingleLineElement(String name, List<XMLEvent> attributes, List<XMLEvent> namespaces, long nrTab, String value) throws XMLStreamException {
        this.createStartTag(name, attributes, namespaces, nrTab, false);
        if (value != null) {
            Characters characters = EVENTFACTORY.createCharacters(value);
            this.eventWriter.add(characters);
        }
        this.createEndTag(name, 0L, true);
    }

    private void createStartTag(String name, List<XMLEvent> attributes, List<XMLEvent> namespaces, long nrTab, boolean addReturn) throws XMLStreamException {
        StartElement sElement = EVENTFACTORY.createStartElement("", "", name, attributes == null ? null : attributes.iterator(), namespaces == null ? null : namespaces.iterator());
        int i = 0;
        while ((long)i < nrTab) {
            this.eventWriter.add(TAB);
            ++i;
        }
        this.eventWriter.add(sElement);
        if (addReturn) {
            this.eventWriter.add(END);
        }
    }

    private void createEndTag(String name, long nrTab, boolean addReturn) throws XMLStreamException {
        EndElement sElement = EVENTFACTORY.createEndElement("", "", name);
        int i = 0;
        while ((long)i < nrTab) {
            this.eventWriter.add(TAB);
            ++i;
        }
        this.eventWriter.add(sElement);
        if (addReturn) {
            this.eventWriter.add(END);
        }
    }

    public OutputStream getCurrentReportStream() {
        return this.currentStream;
    }

    public void flush() throws IRException {
        try {
            this.eventWriter.flush();
        }
        catch (XMLStreamException e) {
            this.closeResources();
            logger.error(Logger.EVENT_FAILURE, "Error while trying to flush outputStream", (Throwable)e);
            throw new IRException(IRMessage.CANNOT_WRITE_COGNOS_XML, new Object[]{this.getOutputFolder().toString()});
        }
    }

    public URL getOutputFolder() {
        return this.outputFolder;
    }

    private void closeResources() {
        try {
            this.eventWriter.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }
}

