/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.transform;

import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.ResultMessage;
import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.caching.RetentionMap;
import com.infor.erpln.ir.connector.transform.AbstractReport;
import com.infor.erpln.ir.connector.transform.InforIRHandler;
import com.infor.erpln.util.XmlUtil;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RegularReport
extends AbstractReport {
    private static SAXParserFactory parserFactory = XmlUtil.createSAXParserFactory();
    private static Logger logger = ESAPI.getLogger(RegularReport.class);
    private final InputStream inputStream;

    public RegularReport(Datafile dataFile, RetentionMap<String, Datafile> dataFileCache, String destination) throws IRException {
        super(dataFile, dataFileCache, destination);
        this.inputStream = this.getInputStream(this.dataFile.getOriginatingFileName());
    }

    public RegularReport(InputStream inputStream, Datafile dataFile, RetentionMap<String, Datafile> dataFileCache, String destination) {
        super(dataFile, dataFileCache, destination);
        this.inputStream = inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultMessage transform() {
        ResultMessage resultMessage;
        String origFile = this.dataFile.getOriginatingFileName();
        try {
            SAXParser parser = parserFactory.newSAXParser();
            File f = new File(this.dataFile.getTargetFilePath());
            f.mkdirs();
            URL outputFolder = f.toURI().toURL();
            InforIRHandler handler = new InforIRHandler(outputFolder, this.dataFile);
            try {
                parser.parse(this.inputStream, (DefaultHandler)handler);
            }
            finally {
                this.inputStream.close();
            }
            resultMessage = new ResultMessage(IRMessage.OK, new Object[0]);
            this.dataFileCache.put((Object)this.dataFile.getName(), (Object)this.dataFile);
            if (logger.isInfoEnabled()) {
                logger.info(Logger.EVENT_UNSPECIFIED, String.format("Regular report datafile '%s' stored in datafile cache", this.dataFile.getOriginatingFileName()));
            }
            this.dataFile.setUSLocale();
            if (logger.isInfoEnabled()) {
                logger.info(Logger.EVENT_SUCCESS, String.format("File '%s' transferred and transformed in '%s'", origFile, this.destinationLocation));
            }
        }
        catch (SAXException e) {
            resultMessage = new ResultMessage(IRMessage.DATA_FILE_NOT_TRANSFERRED, new Object[]{origFile});
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)e);
            if (e.getException() != null && e.getException() instanceof IRException) {
                IRException irEx = (IRException)((Object)e.getException());
                ResultMessage detail = new ResultMessage(irEx);
                resultMessage.setDetailedMessage(detail);
            }
        }
        catch (Exception e) {
            resultMessage = new ResultMessage(IRMessage.DATA_FILE_NOT_TRANSFERRED, new Object[]{origFile});
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)e);
        }
        return resultMessage;
    }
}

