/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.transform;

import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.ResultMessage;
import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.images.AbstractImageDescriptor;
import com.infor.erpln.ir.connector.images.PDFPageImage;
import com.infor.erpln.ir.connector.reportserver.cognos.CognosReportServer;
import com.infor.erpln.ir.connector.reportserver.cognos.RenderFormat;
import com.infor.erpln.ir.connector.transform.MainReportDataFile;
import com.infor.erpln.ir.connector.transform.RegularReport;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.core.pobjects.Document;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class PDFDocument {
    private static Logger logger = ESAPI.getLogger(RegularReport.class);
    private static final String DOCUMENT_EXTENTION = ".pdf";
    private static final String FILENAME_SUFFIX = "page_";
    private static final float IMAGE_SCALE = 2.0f;
    private static final float IMAGE_ROTATION = 0.0f;
    private final Datafile subreportDataFile;
    private final String reportLocation;
    private final String destinationFileName;
    private final String targetFilePath;

    public PDFDocument(Datafile subreportDataFile, String reportLocation, String destination) {
        this.subreportDataFile = subreportDataFile;
        this.reportLocation = reportLocation;
        this.targetFilePath = destination;
        this.destinationFileName = this.targetFilePath + "/" + (this.subreportDataFile.getName() + DOCUMENT_EXTENTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultMessage create() {
        ResultMessage resultMessage = new ResultMessage(IRMessage.OK, new Object[0]);
        CognosReportServer reportServer = null;
        String irCredentials = this.subreportDataFile.getIrCredentials();
        try {
            reportServer = new CognosReportServer(this.subreportDataFile.getIrEndpoint());
            if (reportServer.logon(irCredentials)) {
                this.subreportDataFile.clearErrors();
                byte[] renderedReport = reportServer.renderReport(this.subreportDataFile, this.reportLocation, RenderFormat.PDF.name());
                List errors = this.subreportDataFile.getErrors();
                if (!errors.isEmpty()) {
                    String errorMessage = StringUtils.join((Collection)errors, (String)", ");
                    resultMessage.setIRMessage(IRMessage.ERROR_DURING_RENDER, new Object[]{errorMessage});
                } else if (renderedReport != null) {
                    if (logger.isInfoEnabled()) {
                        logger.info(Logger.EVENT_UNSPECIFIED, IRMessage.WRITING_RENDERED_REPORT.getLogMessage(new Object[]{this.destinationFileName}));
                    }
                    FileOutputStream osf = new FileOutputStream(new File(this.destinationFileName));
                    osf.write(renderedReport);
                    osf.flush();
                    osf.close();
                }
            }
        }
        catch (Exception e) {
            String origFileName = this.subreportDataFile.getName();
            resultMessage.setIRMessage(IRMessage.CANNOT_RENDER_REPORT, new Object[]{origFileName});
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)e);
        }
        finally {
            if (reportServer != null && StringUtils.isNotBlank((String)irCredentials)) {
                try {
                    reportServer.logoff();
                }
                catch (IRException iRException) {}
            }
        }
        return resultMessage;
    }

    public ResultMessage renderToImages(MainReportDataFile mainReportDataFile) {
        ResultMessage resultMessage = null;
        Document document = new Document();
        try {
            document.setFile(this.destinationFileName);
        }
        catch (PDFException ex) {
            this.addErrorImage(mainReportDataFile);
            resultMessage = new ResultMessage(IRMessage.CANNOT_RENDER_PDF, new Object[]{this.destinationFileName});
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)ex);
        }
        catch (PDFSecurityException ex) {
            this.addErrorImage(mainReportDataFile);
            resultMessage = new ResultMessage(IRMessage.NOT_AUTHORIZED_PDF, new Object[]{this.destinationFileName});
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)ex);
        }
        catch (FileNotFoundException ex) {
            this.addErrorImage(mainReportDataFile);
            resultMessage = new ResultMessage(IRMessage.CANNOT_OPEN_PDF, new Object[]{this.destinationFileName});
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)ex);
        }
        catch (IOException ex) {
            this.addErrorImage(mainReportDataFile);
            resultMessage = new ResultMessage(IRMessage.CANNOT_RENDER_PDF, new Object[]{this.destinationFileName});
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)ex);
        }
        for (int pageNumber = 0; pageNumber < document.getNumberOfPages(); ++pageNumber) {
            BufferedImage image = (BufferedImage)document.getPageImage(pageNumber, 2, 2, 0.0f, 2.0f);
            try {
                PDFPageImage pi = new PDFPageImage(this.subreportDataFile, image, FILENAME_SUFFIX + pageNumber);
                String baseURL = this.subreportDataFile.getDestinationURL();
                if (baseURL.endsWith("/image")) {
                    baseURL = baseURL.substring(0, baseURL.length() - 5);
                } else {
                    logger.fatal(Logger.EVENT_FAILURE, String.format("Destination URL '%s' does not end in '/image'", baseURL));
                }
                String imageURL = pi.storeImage(this.targetFilePath, baseURL);
                mainReportDataFile.addRow(imageURL);
                continue;
            }
            catch (Exception e) {
                this.addErrorImage(mainReportDataFile);
                resultMessage = new ResultMessage(IRMessage.CANNOT_RENDER_PDF, new Object[]{this.destinationFileName});
                logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)e);
            }
        }
        document.dispose();
        return resultMessage;
    }

    public void addErrorImage(MainReportDataFile mainReportDataFile) {
        mainReportDataFile.addRow(AbstractImageDescriptor.getErrorImageURL((String)this.subreportDataFile.getDestinationURL()));
    }
}

