/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.transform;

import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.ResultMessage;
import com.infor.erpln.soap.XMLUtil;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MainReportDataFile {
    private static Logger logger = ESAPI.getLogger(MainReportDataFile.class);
    private static final String NAMESPACE_URI = "http://developer.cognos.com/schemas/xmldata/1/";
    private static final String METADATA_ELEMENT = "metadata";
    private static final String ITEM_ELEMENT = "item";
    private static final String DATASET_ELEMENT = "dataset";
    private static final String DATA_ELEMENT = "data";
    private static final String ROW_ELEMENT = "row";
    private static final String VALUE_ELEMENT = "value";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_IMAGE_NAME = "imageUrl";
    private static final String ATTR_IMAGE_TYPE = "xs:string";
    private Document mainReportDocument;
    private Element dataElement;
    private final String fileName;

    public MainReportDataFile(String fileName) {
        this.fileName = fileName;
    }

    public ResultMessage create() {
        ResultMessage resultMessage = null;
        try {
            DocumentBuilderFactory factory = XMLUtil.getSecureDocumentBuilderFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            this.mainReportDocument = impl.createDocument(null, null, null);
            Element elDataset = this.mainReportDocument.createElementNS(NAMESPACE_URI, DATASET_ELEMENT);
            this.mainReportDocument.appendChild(elDataset);
            Element metaDataElement = this.mainReportDocument.createElement(METADATA_ELEMENT);
            elDataset.appendChild(metaDataElement);
            Element itemElement = this.mainReportDocument.createElement(ITEM_ELEMENT);
            itemElement.setAttribute(ATTR_NAME, ATTR_IMAGE_NAME);
            itemElement.setAttribute(ATTR_TYPE, ATTR_IMAGE_TYPE);
            metaDataElement.appendChild(itemElement);
            this.dataElement = this.mainReportDocument.createElement(DATA_ELEMENT);
            elDataset.appendChild(this.dataElement);
            resultMessage = new ResultMessage(IRMessage.OK, new Object[0]);
        }
        catch (Exception ex) {
            resultMessage = new ResultMessage(IRMessage.CANNOT_CREATE_DOC, new Object[]{this.fileName});
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)ex);
        }
        return resultMessage;
    }

    public ResultMessage flush() {
        ResultMessage resultMessage = null;
        try {
            TransformerFactory transformerFactory = XMLUtil.getSecureTransformerFactory();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(this.mainReportDocument);
            StreamResult result = new StreamResult(new File(this.fileName));
            transformer.transform(source, result);
            resultMessage = new ResultMessage(IRMessage.OK, new Object[0]);
        }
        catch (Exception ex) {
            resultMessage = new ResultMessage(IRMessage.CANNOT_CREATE_DOC, new Object[]{this.fileName});
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)ex);
        }
        return resultMessage;
    }

    public void addRow(String imageUrl) {
        Element rowElement = this.mainReportDocument.createElement(ROW_ELEMENT);
        this.dataElement.appendChild(rowElement);
        Element valueElement = this.mainReportDocument.createElement(VALUE_ELEMENT);
        valueElement.setTextContent(imageUrl);
        rowElement.appendChild(valueElement);
    }
}

