/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.transform;

import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.ResultMessage;
import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.caching.RetentionMap;
import com.infor.erpln.ir.connector.transform.AbstractReport;
import com.infor.erpln.ir.connector.transform.MainReportDataFile;
import com.infor.erpln.ir.connector.transform.PDFDocument;
import com.infor.erpln.ir.connector.transform.RegularReport;
import com.infor.erpln.soap.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MainReport
extends AbstractReport {
    private static final String REPORT_ELEMENT = "REPORT";
    private static final String ROW_TAG = "ROW";
    private static final String DATA_FILE_ELEMENT = "datafile";
    private static final String NAME_ATTR = "NAME";
    private static final String CODE_ATTR = "CODE";
    private static final String GUID_ATTR = "GUID";
    private static final String PROPERTY_ELEMENT = "PROPERTY";
    private static final String PROPERTIES_ELEMENT = "PROPERTIES";
    private static final String REPORT_LOCATION_TAG = "ReportLocation";
    private static Logger logger = ESAPI.getLogger(MainReport.class);

    public MainReport(Datafile dataFile, RetentionMap<String, Datafile> dataFileCache, String destination) {
        super(dataFile, dataFileCache, destination);
    }

    public ResultMessage transform() {
        MainReportDataFile mainReportDataFile = new MainReportDataFile(this.destinationLocation + "/" + this.dataFile.getName() + "-f");
        ResultMessage resultMessage = mainReportDataFile.create();
        try {
            PDFDocument pdfDoc = null;
            String origFile = this.dataFile.getOriginatingFileName();
            InputStream instMainReport = this.getInputStream(origFile);
            Document doc = XMLUtil.getSecureDocumentBuilderFactory().newDocumentBuilder().parse(instMainReport);
            Element node = doc.getDocumentElement();
            instMainReport.close();
            NodeList nList = node.getElementsByTagName(ROW_TAG);
            Element element = (Element)nList.item(0);
            String subReportFile = element.getElementsByTagName(DATA_FILE_ELEMENT).item(0).getFirstChild().getNodeValue();
            InputStream instSubReport = this.getInputStream(subReportFile);
            doc = XMLUtil.getSecureDocumentBuilderFactory().newDocumentBuilder().parse(instSubReport);
            instSubReport.close();
            Element docuNode = doc.getDocumentElement();
            NodeList subReportsList = docuNode.getElementsByTagName(REPORT_ELEMENT);
            for (int subreportElement = 0; subreportElement < subReportsList.getLength(); ++subreportElement) {
                Node subReportNode = subReportsList.item(subreportElement);
                String reportCode = this.getNodeAttributeValue(subReportNode, CODE_ATTR);
                String reportGuid = this.getNodeAttributeValue(subReportNode, GUID_ATTR);
                String reportLocation = this.getReportLocation(((Element)subReportNode).getElementsByTagName(PROPERTIES_ELEMENT).item(0));
                DOMSource xmlSource = new DOMSource(subReportNode);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                StreamResult outputTarget = new StreamResult(outputStream);
                XMLUtil.getSecureTransformerFactory().newTransformer().transform(xmlSource, outputTarget);
                ByteArrayInputStream subreportIs = new ByteArrayInputStream(outputStream.toByteArray());
                Datafile subreportDatafile = new Datafile(this.dataFile.isRuntimeFile() ? reportCode + "_" + reportGuid : reportCode);
                subreportDatafile.setOriginatingFileName(subReportFile);
                subreportDatafile.getPropertyCache().addProperty("DatafileName", this.destinationLocation + "/" + subreportDatafile.getName() + "-f");
                subreportDatafile.setIrEndpoint(this.dataFile.getIrEndpoint());
                subreportDatafile.setCredentials(this.dataFile.getIrCredentials());
                subreportDatafile.setConnection(this.dataFile.getConnection());
                subreportDatafile.setTargetFilePath(this.destinationLocation);
                subreportDatafile.setDestinationURL(this.dataFile.getDestinationURL());
                subreportDatafile.getPropertyCache().addProperty("DecimalSeparator", this.dataFile.isUSLocale() ? "." : ",");
                resultMessage = new RegularReport((InputStream)subreportIs, subreportDatafile, this.dataFileCache, this.destinationLocation).transform();
                if (resultMessage.getCode() != IRMessage.OK.messageCode() || reportLocation.isEmpty()) continue;
                pdfDoc = new PDFDocument(subreportDatafile, reportLocation, this.destinationLocation);
                resultMessage = pdfDoc.create();
                if (resultMessage.getCode() == IRMessage.OK.messageCode()) {
                    resultMessage = pdfDoc.renderToImages(mainReportDataFile);
                } else {
                    pdfDoc.addErrorImage(mainReportDataFile);
                }
                for (String error : subreportDatafile.getErrors()) {
                    this.dataFile.addError(error);
                }
            }
            resultMessage = mainReportDataFile.flush();
        }
        catch (Exception e) {
            String origFileName = this.dataFile.getOriginatingFileName();
            resultMessage = new ResultMessage(IRMessage.DATA_FILE_NOT_TRANSFERRED, new Object[]{origFileName});
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)e);
        }
        List errors = this.dataFile.getErrors();
        if (!errors.isEmpty()) {
            String errorMessage = StringUtils.join((Collection)errors, (String)", ");
            resultMessage = new ResultMessage(IRMessage.ERROR_DURING_RENDER, new Object[]{errorMessage});
        }
        this.dataFileCache.put((Object)this.dataFile.getName(), (Object)this.dataFile);
        if (logger.isInfoEnabled()) {
            logger.info(Logger.EVENT_FAILURE, String.format("Main report datafile '%s' stored in datafile cache", this.dataFile.getOriginatingFileName()));
        }
        this.dataFile.getPropertyCache().addProperty("LanguageISO", "en-us");
        return resultMessage;
    }

    private String getReportLocation(Node propertiesNode) {
        String reportLocation = "";
        NodeList propertyList = ((Element)propertiesNode).getElementsByTagName(PROPERTY_ELEMENT);
        for (int propertyElement = 0; propertyElement < propertyList.getLength(); ++propertyElement) {
            Node reportProperty = propertyList.item(propertyElement);
            if (!this.getNodeAttributeValue(reportProperty, NAME_ATTR).equalsIgnoreCase(REPORT_LOCATION_TAG)) continue;
            reportLocation = reportProperty.getTextContent();
            break;
        }
        return reportLocation;
    }

    private String getNodeAttributeValue(Node nNode, String nodeName) {
        Node attr = nNode.getAttributes().getNamedItem(nodeName);
        return attr != null ? attr.getNodeValue() : "";
    }
}

