/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.transform;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class LNDate {
    private static final long NUMBER_OF_DAYS_TO_1970 = 719163L;
    private static final DateFormat COGNOS_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'00:00:00");
    private static final DateFormat COGNOS_UTC_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final String lnValue;

    public LNDate(String lnValue) {
        this.lnValue = lnValue;
    }

    public String convertUTCToCognosFormat() {
        long dateValue = Long.parseLong(this.lnValue);
        long lnUtcDate = dateValue * 1000L;
        return dateValue == 0L ? "" : COGNOS_UTC_FORMAT.format(lnUtcDate);
    }

    public String convertDateToCognosFormat() {
        long dateValue = Long.parseLong(this.lnValue);
        long lnDate = dateValue - 719163L;
        return dateValue == 0L ? "" : COGNOS_DATE_FORMAT.format(TimeUnit.MILLISECONDS.convert(lnDate, TimeUnit.DAYS));
    }

    static {
        TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
        COGNOS_DATE_FORMAT.setTimeZone(gmtTimeZone);
        COGNOS_UTC_FORMAT.setTimeZone(gmtTimeZone);
    }
}

