/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.transform;

import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.caching.Label;
import com.infor.erpln.ir.connector.transform.ICognosXMLWriter;
import com.infor.erpln.ir.connector.transform.InforIRHandler;
import com.infor.erpln.ir.connector.transform.LNDate;
import com.infor.erpln.ir.connector.transform.StaxCognosXMLWriter;
import com.infor.erpln.ir.connector.transform.model.CognosDatatype;
import com.infor.erpln.ir.connector.transform.model.Column;
import com.infor.erpln.ir.connector.transform.model.IRDatatype;
import com.infor.erpln.ir.connector.transform.model.Row;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * Exception performing whole class analysis ignored.
 */
public class InforIRHandler
extends DefaultHandler {
    private static final String COLUMN_TYPE = "TYPE";
    private static final String COLUMN_LENGTH = "DISPLENGTH";
    private static final String COLUMN_PRECISION = "PRECISION";
    private static final String COLUMN_SCALE = "SCALE";
    private static final String COLUMN_TAG = "TAG";
    private static final String NAME_ATTR = "NAME";
    private static final String LABEL_HEIGHT = "HEIGHT";
    private static final String LABEL_LENGTH = "LENGTH";
    private static final String LABEL_ORIGNAME = "ORIGNAME";
    private static final String PROPERTY_HIDDEN = "HIDDEN";
    private static Logger logger = ESAPI.getLogger(InforIRHandler.class);
    private static final Map<IRDatatype, CognosDatatype> TYPE_MAPPING;
    private static final int BUFFER_SIZE = 65536;
    private Row currentRow;
    private Column currentColumn;
    private final ICognosXMLWriter fieldsDatasetWriter;
    private final ICognosXMLWriter propertiesDatasetWriter;
    private final ICognosXMLWriter labelsDatasetWriter;
    private OutputStream currentReportStream;
    private OutputStream labelsStream;
    private OutputStream propertiesStream;
    private List<String> columnTagNames;
    private List<Column> columns;
    private String currentTag;
    private final StringBuilder temporaryElementValue = new StringBuilder();
    private final Datafile datafile;
    private String currentProperty;
    private boolean currentPropertyHidden;
    private Label currentLabel;
    private boolean valueReading;
    private final URL outputFolder;

    public InforIRHandler(URL outputFolder, Datafile datafile) {
        this.fieldsDatasetWriter = new StaxCognosXMLWriter(outputFolder);
        this.propertiesDatasetWriter = new StaxCognosXMLWriter(outputFolder);
        this.labelsDatasetWriter = new StaxCognosXMLWriter(outputFolder);
        this.outputFolder = outputFolder;
        this.datafile = datafile;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        boolean tagKnown = false;
        this.valueReading = false;
        this.currentTag = null;
        if (this.columnTagNames != null && (tagKnown = this.columnTagNames.contains(qName))) {
            this.valueReading = true;
            this.currentTag = qName;
            return;
        }
        IERElement element = IERElement.fromName((String)qName);
        if (element != null) {
            try {
                switch (1.$SwitchMap$com$infor$erpln$ir$connector$transform$InforIRHandler$IERElement[element.ordinal()]) {
                    case 1: {
                        this.startReportElement();
                        break;
                    }
                    case 2: {
                        this.startPropertiesElement();
                        break;
                    }
                    case 3: {
                        this.startPropertyElement(attributes);
                        break;
                    }
                    case 4: {
                        this.startLabelsElement();
                        break;
                    }
                    case 5: {
                        this.startLabelElement(attributes);
                        break;
                    }
                    case 6: {
                        this.fieldsDatasetWriter.startMetadata();
                        break;
                    }
                    case 7: {
                        this.startColumnElement(attributes);
                        break;
                    }
                    case 8: {
                        this.fieldsDatasetWriter.startData();
                        break;
                    }
                    case 9: {
                        this.startRowElement();
                        break;
                    }
                }
            }
            catch (IRException e) {
                this.closeResources();
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    private void startPropertiesElement() throws IRException {
        this.propertiesStream = this.createOutputStreamForDataset(IERElement.PROPERTIES);
        this.propertiesDatasetWriter.createDataset(this.propertiesStream);
        this.propertiesDatasetWriter.startMetadata();
        this.currentRow = new Row(null);
    }

    private void startPropertyElement(Attributes attributes) {
        this.currentProperty = attributes.getValue("NAME");
        String hidden = attributes.getValue("HIDDEN");
        this.currentPropertyHidden = hidden != null ? new Boolean(hidden) : false;
        this.valueReading = true;
        if (!this.currentPropertyHidden) {
            this.currentColumn = new Column();
            this.currentColumn.setName(this.currentProperty);
            this.currentColumn.setType(CognosDatatype.STRING);
        }
    }

    private void startLabelsElement() throws IRException {
        this.labelsStream = this.createOutputStreamForDataset(IERElement.LABELS);
        this.labelsDatasetWriter.createDataset(this.labelsStream);
        this.labelsDatasetWriter.startMetadata();
        this.currentRow = new Row(null);
    }

    private void startLabelElement(Attributes attributes) {
        this.currentLabel = new Label();
        this.currentLabel.setName(attributes.getValue("ORIGNAME"));
        this.currentLabel.setHeight(new Integer(attributes.getValue("HEIGHT")));
        this.currentLabel.setLength(new Integer(attributes.getValue("LENGTH")));
        this.valueReading = true;
        this.currentColumn = new Column();
        this.currentColumn.setName(this.currentLabel.getName());
        this.currentColumn.setType(CognosDatatype.STRING);
    }

    private void startReportElement() throws IRException {
        this.columnTagNames = new ArrayList();
        this.columns = new ArrayList();
        this.currentReportStream = this.createOutputStreamForDataset(IERElement.REPORT);
        this.fieldsDatasetWriter.createDataset(this.currentReportStream);
    }

    private OutputStream createOutputStreamForDataset(IERElement datasetType) throws IRException {
        BufferedOutputStream stream;
        String outputFileName = this.outputFolder.getFile() + "/" + this.getOutputFilename(datasetType);
        File file = new File(outputFileName);
        try {
            stream = new BufferedOutputStream(new FileOutputStream(file), 65536);
        }
        catch (FileNotFoundException e) {
            logger.error(Logger.EVENT_FAILURE, "Cannot create file output stream for file '" + outputFileName + "'.", (Throwable)e);
            throw new IRException(IRMessage.CANNOT_WRITE_COGNOS_XML, new Object[]{outputFileName});
        }
        return stream;
    }

    private void startColumnElement(Attributes attributes) {
        String scale;
        String precision;
        this.currentColumn = new Column();
        String columnName = attributes.getValue("NAME");
        this.currentColumn.setName(columnName);
        String irTagName = attributes.getValue("TAG");
        this.currentColumn.setIRName(irTagName);
        String columnType = attributes.getValue("TYPE");
        this.currentColumn.setType((CognosDatatype)TYPE_MAPPING.get(IRDatatype.fromValue((String)columnType)));
        String columnLength = attributes.getValue("DISPLENGTH");
        if (columnLength != null) {
            this.currentColumn.setLength(new Integer(columnLength));
        }
        if ((precision = attributes.getValue("PRECISION")) != null) {
            this.currentColumn.setPrecision(new Integer(precision));
        }
        if ((scale = attributes.getValue("SCALE")) != null) {
            this.currentColumn.setScale(new Integer(scale));
        }
        this.columnTagNames.add(irTagName);
        this.columns.add(this.currentColumn);
    }

    private void startRowElement() {
        this.currentRow = new Row((Collection)this.columns);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currentTag != null) {
            this.currentRow.addValue(this.currentTag, this.getColumnValue());
            this.currentTag = null;
            this.valueReading = false;
            this.temporaryElementValue.setLength(0);
            return;
        }
        IERElement element = IERElement.fromName((String)qName);
        if (element != null) {
            try {
                switch (1.$SwitchMap$com$infor$erpln$ir$connector$transform$InforIRHandler$IERElement[element.ordinal()]) {
                    case 10: {
                        this.closeResources();
                        break;
                    }
                    case 1: {
                        this.fieldsDatasetWriter.closeDataset();
                        break;
                    }
                    case 2: {
                        this.endPropertiesElement();
                        break;
                    }
                    case 3: {
                        this.endPropertyElement();
                        break;
                    }
                    case 4: {
                        this.endLabelsElement();
                        break;
                    }
                    case 5: {
                        this.endLabelElement();
                        break;
                    }
                    case 6: {
                        this.fieldsDatasetWriter.endMetadata();
                        break;
                    }
                    case 7: {
                        this.endColumnElement();
                        break;
                    }
                    case 8: {
                        this.fieldsDatasetWriter.endData();
                        break;
                    }
                    case 9: {
                        this.endRowElement();
                        break;
                    }
                }
            }
            catch (IRException e) {
                this.closeResources();
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    private String getColumnValue() {
        String columnValue = this.temporaryElementValue.toString();
        for (Column column : this.columns) {
            if (!column.getIRName().equalsIgnoreCase(this.currentTag)) continue;
            switch (1.$SwitchMap$com$infor$erpln$ir$connector$transform$model$CognosDatatype[column.getType().ordinal()]) {
                case 1: {
                    columnValue = new LNDate(this.temporaryElementValue.toString()).convertUTCToCognosFormat();
                    break;
                }
                case 2: {
                    columnValue = new LNDate(this.temporaryElementValue.toString()).convertDateToCognosFormat();
                    break;
                }
                default: {
                    columnValue = this.temporaryElementValue.toString();
                    break;
                }
            }
            break;
        }
        return columnValue;
    }

    private void endPropertiesElement() throws IRException {
        this.propertiesDatasetWriter.endMetadata();
        this.propertiesDatasetWriter.startData();
        this.propertiesDatasetWriter.addRow(this.currentRow);
        this.currentRow = null;
        this.propertiesDatasetWriter.endData();
        this.propertiesDatasetWriter.closeDataset();
    }

    private void endPropertyElement() throws IRException {
        this.valueReading = false;
        this.datafile.getPropertyCache().addProperty(this.currentProperty, this.temporaryElementValue.toString());
        if (!this.currentPropertyHidden) {
            this.propertiesDatasetWriter.addColumn(this.currentColumn);
            this.currentColumn = null;
            this.currentRow.addValue(this.currentProperty, this.temporaryElementValue.toString());
        }
        this.temporaryElementValue.setLength(0);
    }

    private void endLabelsElement() throws IRException {
        this.labelsDatasetWriter.endMetadata();
        this.labelsDatasetWriter.startData();
        this.labelsDatasetWriter.addRow(this.currentRow);
        this.currentRow = null;
        this.labelsDatasetWriter.endData();
        this.labelsDatasetWriter.closeDataset();
    }

    private void endLabelElement() throws IRException {
        this.valueReading = false;
        this.currentLabel.setValue(this.temporaryElementValue.toString());
        if (!this.currentRow.hasValueForColumn(this.currentLabel.getName())) {
            this.labelsDatasetWriter.addColumn(this.currentColumn);
            this.currentRow.addValue(this.currentLabel.getName(), this.temporaryElementValue.toString());
        }
        this.currentColumn = null;
        this.temporaryElementValue.setLength(0);
    }

    private void endRowElement() throws IRException {
        this.fieldsDatasetWriter.addRow(this.currentRow);
        this.currentRow = null;
    }

    private void endColumnElement() throws IRException {
        this.fieldsDatasetWriter.addColumn(this.currentColumn);
        this.currentColumn = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.valueReading) {
            this.temporaryElementValue.append(ch, start, length);
        }
        super.characters(ch, start, length);
    }

    private String getOutputFilename(IERElement outputKind) {
        String filename = this.datafile.getName();
        switch (1.$SwitchMap$com$infor$erpln$ir$connector$transform$InforIRHandler$IERElement[outputKind.ordinal()]) {
            case 1: {
                filename = filename + "-f";
                break;
            }
            case 4: {
                filename = filename + "-l";
                break;
            }
            case 2: {
                filename = filename + "-p";
                break;
            }
        }
        return filename.toString();
    }

    private void closeResources() {
        try {
            if (this.currentReportStream != null) {
                this.currentReportStream.close();
            }
            if (this.labelsStream != null) {
                this.labelsStream.close();
            }
            if (this.propertiesStream != null) {
                this.propertiesStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static {
        EnumMap<IRDatatype, CognosDatatype> typeMapping = new EnumMap<IRDatatype, CognosDatatype>(IRDatatype.class);
        typeMapping.put(IRDatatype.BOOLEAN, CognosDatatype.BOOLEAN);
        typeMapping.put(IRDatatype.BYTE, CognosDatatype.BYTE);
        typeMapping.put(IRDatatype.DATE, CognosDatatype.DATE);
        typeMapping.put(IRDatatype.DOUBLE, CognosDatatype.DOUBLE);
        typeMapping.put(IRDatatype.ENUMERATED, CognosDatatype.ENUMERATED);
        typeMapping.put(IRDatatype.FLOAT, CognosDatatype.FLOAT);
        typeMapping.put(IRDatatype.INTEGER, CognosDatatype.INTEGER);
        typeMapping.put(IRDatatype.LONG, CognosDatatype.LONG);
        typeMapping.put(IRDatatype.MULTIBYTE_STRING, CognosDatatype.MULTIBYTE_STRING);
        typeMapping.put(IRDatatype.STRING, CognosDatatype.STRING);
        typeMapping.put(IRDatatype.TEXT, CognosDatatype.TEXT);
        typeMapping.put(IRDatatype.UTC_DATE_TIME, CognosDatatype.UTC_DATE_TIME);
        TYPE_MAPPING = Collections.unmodifiableMap(typeMapping);
    }
}

