/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.transform;

import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.ResultMessage;
import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.caching.RetentionMap;
import com.infor.erpln.ir.connector.transform.MainReport;
import com.infor.erpln.ir.connector.transform.RegularReport;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class DatafileTransformer {
    private static Logger logger = ESAPI.getLogger(DatafileTransformer.class);
    private final Datafile datafile;
    private final RetentionMap<String, Datafile> dataFileCache;
    private final String destinationLocation;

    public DatafileTransformer(Datafile datafile, RetentionMap<String, Datafile> dataFileCache, String location) {
        this.datafile = datafile;
        this.dataFileCache = dataFileCache;
        this.destinationLocation = location;
    }

    public ResultMessage transform() {
        ResultMessage resultMessage;
        String origFile = this.datafile.getOriginatingFileName();
        try {
            resultMessage = this.datafile.isMainReport() ? new MainReport(this.datafile, this.dataFileCache, this.destinationLocation).transform() : new RegularReport(this.datafile, this.dataFileCache, this.destinationLocation).transform();
        }
        catch (Exception e) {
            resultMessage = new ResultMessage(IRMessage.DATA_FILE_NOT_TRANSFERRED, new Object[]{origFile});
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)e);
        }
        return resultMessage;
    }
}

