/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.transform;

import com.googlecode.compress_j2me.lzc.LZCInputStream;
import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.caching.RetentionMap;
import com.infor.erpln.ir.connector.transform.IReport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public abstract class AbstractReport
implements IReport {
    private static Logger logger = ESAPI.getLogger(AbstractReport.class);
    protected final Datafile dataFile;
    protected final RetentionMap<String, Datafile> dataFileCache;
    protected final String destinationLocation;

    public AbstractReport(Datafile dataFile, RetentionMap<String, Datafile> dataFileCache, String destination) {
        this.dataFile = dataFile;
        this.dataFileCache = dataFileCache;
        this.destinationLocation = destination;
    }

    public InputStream getInputStream(String dataFileName) throws IRException {
        InputStream is = null;
        try {
            boolean isRuntimeFile = this.dataFile.isRuntimeFile();
            is = this.dataFile.getConnection().openForRead(dataFileName, !isRuntimeFile);
            if (isRuntimeFile) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                LZCInputStream.uncompress((InputStream)is, (OutputStream)os);
                is.close();
                is = new ByteArrayInputStream(os.toByteArray());
                if (logger.isInfoEnabled()) {
                    logger.info(Logger.EVENT_SUCCESS, String.format("Subreport file '%s' decompressed.", dataFileName));
                }
            }
        }
        catch (Exception ex) {
            logger.error(Logger.EVENT_FAILURE, String.format("Unable to open input stream '%s'", dataFileName), (Throwable)ex);
            throw new IRException(IRMessage.FAULT, new Object[]{ex.getMessage()});
        }
        return is;
    }
}

