/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.reportserver.cognos;

import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.MultilingualToken;
import com.cognos.developer.schemas.bibus._3.MultilingualTokenProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.Role;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.UpdateOptions;
import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class RoleInstallation {
    protected static boolean oldVersion;
    private static Logger logger;
    protected static final String COGNOS_NAMESPACE = "CAMID(\":\")";
    private static final String LOCALE_EN_ZW = "en-zw";
    private static final String LOCALE_EN = "en";
    private static final String LN_ADMIN = "infor.ln.administrator";
    private static final String LN_CONSUMER = "infor.ln.consumer";
    private static final String LN_BUS_AUTHOR = "infor.ln.businessauthor";
    private static final String LN_PROF_AUTHOR = "infor.ln.professionalauthor";
    private static final String ROLE_ADMINISTRATOR = "infor.irplatform.administrator";
    private static final String ROLE_CONSUMER = "infor.irplatform.consumer";
    private static final String ROLE_BUS_AUTHOR = "infor.irplatform.businessauthor";
    private static final String ROLE_PROF_AUTHOR = "infor.irplatform.professionalauthor";
    private static final String LN_ROLE_ADMINISTRATOR = "IR-LNAdministrator";
    private static final String LN_ROLE_CONSUMER = "IR-LNConsumer";
    private static final String LN_ROLE_BUS_AUTHOR = "IR-LNAdvancedBusinessAuthor";
    private static final String LN_ROLE_PROF_AUTHOR = "IR-LNProfessionalAuthor";
    private static final String MSG_LN_ROLE_PRESENT = "Role '%s' will not be created (already present)";
    protected ContentManagerService_PortType mCMService;

    public RoleInstallation(ContentManagerService_PortType cmService) throws IRException {
        this.mCMService = cmService;
    }

    protected BaseClass getNewRole() {
        return new Role();
    }

    protected BaseClassArrayProp getRoleMembers(String aRoleName) throws IRException {
        Role role = this.getRole(aRoleName);
        BaseClassArrayProp members = role.getMembers();
        if (members == null) {
            members = new BaseClassArrayProp();
            role.setMembers(members);
        }
        return members;
    }

    public void createLNRoles() throws IRException {
        LinkedHashMap<String, String> translations = new LinkedHashMap<String, String>();
        String name = LN_ADMIN;
        String desc = LN_ROLE_ADMINISTRATOR;
        translations.put(LOCALE_EN_ZW, name);
        translations.put(LOCALE_EN, desc);
        if (this.getRole(name) == null) {
            this.createRole(translations);
            this.addLNRoleToCognosRole(name, ROLE_ADMINISTRATOR);
        } else if (logger.isInfoEnabled()) {
            logger.info(Logger.EVENT_UNSPECIFIED, String.format(MSG_LN_ROLE_PRESENT, name));
        }
        translations.clear();
        name = LN_CONSUMER;
        desc = LN_ROLE_CONSUMER;
        translations.put(LOCALE_EN_ZW, name);
        translations.put(LOCALE_EN, desc);
        if (this.getRole(name) == null) {
            this.createRole(translations);
            this.addLNRoleToCognosRole(name, ROLE_CONSUMER);
        } else if (logger.isInfoEnabled()) {
            logger.info(Logger.EVENT_UNSPECIFIED, String.format(MSG_LN_ROLE_PRESENT, name));
        }
        translations.clear();
        name = LN_BUS_AUTHOR;
        desc = LN_ROLE_BUS_AUTHOR;
        translations.put(LOCALE_EN_ZW, name);
        translations.put(LOCALE_EN, desc);
        if (this.getRole(name) == null) {
            this.createRole(translations);
            this.addLNRoleToCognosRole(name, ROLE_BUS_AUTHOR);
        } else if (logger.isInfoEnabled()) {
            logger.info(Logger.EVENT_UNSPECIFIED, String.format(MSG_LN_ROLE_PRESENT, name));
        }
        translations.clear();
        name = LN_PROF_AUTHOR;
        desc = LN_ROLE_PROF_AUTHOR;
        translations.put(LOCALE_EN_ZW, name);
        translations.put(LOCALE_EN, desc);
        if (this.getRole(name) == null) {
            this.createRole(translations);
            this.addLNRoleToCognosRole(name, ROLE_PROF_AUTHOR);
        } else if (logger.isInfoEnabled()) {
            logger.info(Logger.EVENT_UNSPECIFIED, String.format(MSG_LN_ROLE_PRESENT, name));
        }
    }

    private void createRole(Map<String, String> localizedNames) throws IRException {
        StringBuilder logMessage = new StringBuilder("Creating role with localized names:");
        ArrayList<MultilingualToken> tokens = new ArrayList<MultilingualToken>();
        for (Map.Entry<String, String> localeNamePair : localizedNames.entrySet()) {
            String locale = localeNamePair.getKey();
            String name = localeNamePair.getValue();
            tokens.add(new MultilingualToken(locale, name));
            logMessage.append(" (").append(locale).append(": ").append(name).append(")");
        }
        if (logger.isInfoEnabled()) {
            logger.info(Logger.EVENT_UNSPECIFIED, logMessage.toString());
        }
        MultilingualTokenProp nameProp = new MultilingualTokenProp();
        nameProp.setValue(tokens.toArray(new MultilingualToken[tokens.size()]));
        BaseClass role = this.getNewRole();
        role.setName(nameProp);
        SearchPathSingleObject searchPath = new SearchPathSingleObject(COGNOS_NAMESPACE);
        try {
            this.mCMService.add(searchPath, new BaseClass[]{role}, new AddOptions());
        }
        catch (RemoteException e) {
            logger.error(Logger.EVENT_FAILURE, "Error when creating a new LN Role. ", (Throwable)e);
            throw new IRException(IRMessage.CANNOT_ADD_ROLE, new Object[]{nameProp.getValue()[0].getValue()});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addLNRoleToCognosRole(String aLNRoleName, String aCognosRole) throws IRException {
        if (logger.isInfoEnabled()) {
            logger.info(Logger.EVENT_UNSPECIFIED, String.format("Trying to add LN Role '%s' to Cognos Role '%s'", aLNRoleName, aCognosRole));
        }
        Role lnRole = this.getRole(aLNRoleName);
        Role cognosRole = this.getRole(aCognosRole);
        if (lnRole != null && cognosRole != null) {
            BaseClassArrayProp members = cognosRole.getMembers();
            if (members == null) {
                members = new BaseClassArrayProp();
                cognosRole.setMembers(members);
            }
            BaseClass[] memberArray = members.getValue();
            boolean roleFound = false;
            if (memberArray == null) {
                memberArray = new BaseClass[]{lnRole};
                members.setValue(memberArray);
            } else {
                String roleSearchPath = lnRole.getSearchPath().getValue();
                for (BaseClass member : memberArray) {
                    if (!roleSearchPath.equals(member.getSearchPath().getValue())) continue;
                    roleFound = true;
                    if (!logger.isInfoEnabled()) break;
                    logger.info(Logger.EVENT_UNSPECIFIED, String.format("LNRole '%s' was already present in parent role '%s'", aLNRoleName, aCognosRole));
                    break;
                }
                if (!roleFound) {
                    int oldLength = memberArray.length;
                    BaseClass[] newArray = new BaseClass[oldLength + 1];
                    System.arraycopy(memberArray, 0, newArray, 0, oldLength);
                    newArray[oldLength] = lnRole;
                    members.setValue(newArray);
                }
            }
            if (roleFound) return;
            try {
                this.mCMService.update(new BaseClass[]{cognosRole}, new UpdateOptions());
                if (!logger.isInfoEnabled()) return;
                logger.info(Logger.EVENT_SUCCESS, String.format("Role '%s' has been added to parent role '%s'", aLNRoleName, aCognosRole));
                return;
            }
            catch (RemoteException e) {
                logger.error(Logger.EVENT_FAILURE, String.format("Error when adding Role '%s' to role '%s'. ", aLNRoleName, aCognosRole) + e.getStackTrace());
                throw new IRException(IRMessage.ERROR_ADDING_LN_ROLE_TO_COGNOS_ROLE, new Object[]{aLNRoleName, aCognosRole});
            }
        } else {
            if (cognosRole != null || !logger.isInfoEnabled()) return;
            logger.info(Logger.EVENT_FAILURE, String.format("Role '%s' not found. Role '%s' could not be added to this role", aCognosRole, aLNRoleName));
        }
    }

    protected Role getRole(String rolename) throws IRException {
        PropEnum[] properties = new PropEnum[]{PropEnum.searchPath, PropEnum.defaultName, PropEnum.members};
        String pathString = String.format("%s//role[@name='%s']", COGNOS_NAMESPACE, rolename);
        SearchPathMultipleObject searchPath = new SearchPathMultipleObject(pathString);
        Role matchingRole = null;
        try {
            BaseClass[] result = this.mCMService.query(searchPath, properties, new Sort[0], new QueryOptions());
            if (result != null && result.length > 0 && result[0] instanceof Role) {
                matchingRole = (Role)result[0];
            }
        }
        catch (RemoteException e) {
            if (logger.isInfoEnabled()) {
                logger.info(Logger.EVENT_FAILURE, String.format("Error when querying role '%s'. ", rolename), (Throwable)e);
            }
            throw new IRException(IRMessage.ERROR_QUERYING_LN_ROLE, new Object[]{rolename});
        }
        return matchingRole;
    }

    static {
        logger = ESAPI.getLogger(RoleInstallation.class);
    }
}

