/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.reportserver.cognos;

import com.cognos.developer.schemas.bibus._3.AsynchDetailReportOutput;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportStatus;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchSecondaryRequest;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.ReportService_PortType;
import com.cognos.developer.schemas.bibus._3.RunOptionBoolean;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionLanguageArray;
import com.cognos.developer.schemas.bibus._3.RunOptionStringArray;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.reportserver.cognos.CognosReportServer;
import com.infor.erpln.ir.connector.reportserver.cognos.RenderFormat;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import org.apache.axis.client.Stub;
import org.apache.axis.encoding.Base64;
import org.apache.axis.message.SOAPHeaderElement;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class Render {
    private static final int RUN_OPTIONS = 4;
    private static final int RUN_OPTION_SAVE_INPUT = 0;
    private static final int RUN_OPTION_RENDER_FORMAT = 1;
    private static final int RUN_OPTION_PROMPT_INDEX = 2;
    private static final int RUN_OPTION_OUTPUT_LOCALE = 3;
    private static final String DATAFILE_PROPERTY = "datafile";
    private static Logger logger = ESAPI.getLogger(Render.class);
    private final Datafile dataFile;
    private final String reportName;
    private RenderFormat renderFormat;
    private final CognosReportServer reportServer;

    public Render(CognosReportServer reportServer, Datafile dataFile, String reportName, String format) throws IRException {
        this.reportServer = reportServer;
        this.dataFile = dataFile;
        this.reportName = reportName;
        this.setRenderFormat(format);
    }

    public byte[] executeReport() throws IRException {
        String data = null;
        Option[] runOptions = new Option[4];
        RunOptionBoolean rob = new RunOptionBoolean();
        RunOptionStringArray rosa = new RunOptionStringArray();
        RunOptionBoolean rop = new RunOptionBoolean();
        RunOptionLanguageArray rola = new RunOptionLanguageArray();
        rola.setName(RunOptionEnum.outputLocale);
        rola.setValue(new String[]{(String)this.dataFile.getPropertyCache().getProperties().properties.get("LanguageISO")});
        rob.setName(RunOptionEnum.saveOutput);
        rob.setValue(false);
        rosa.setName(RunOptionEnum.outputFormat);
        rosa.setValue(new String[]{this.renderFormat.name()});
        rop.setName(RunOptionEnum.prompt);
        rop.setValue(false);
        runOptions[0] = rob;
        runOptions[1] = rosa;
        runOptions[2] = rop;
        runOptions[3] = rola;
        ParameterValue[] params = new ParameterValue[]{new ParameterValue()};
        params[0].setName("datafile");
        SimpleParmValueItem item = new SimpleParmValueItem();
        item.setUse(this.dataFile.getName());
        item.setInclusive(true);
        ParmValueItem[] pvi = new ParmValueItem[]{item};
        params[0].setValue(pvi);
        try {
            SearchPathSingleObject repPath = new SearchPathSingleObject();
            repPath.set_value(this.reportName);
            AsynchReply rsr = this.getReportService(true).run(repPath, params, runOptions);
            if (!rsr.getStatus().equals((Object)AsynchReplyStatusEnum.complete)) {
                while (!rsr.getStatus().equals((Object)AsynchReplyStatusEnum.complete)) {
                    if (!Render.hasSecondaryRequest((AsynchReply)rsr, (String)"wait")) {
                        logger.error(Logger.EVENT_FAILURE, IRMessage.CANNOT_RENDER_REPORT.getLogMessage(new Object[]{this.reportName}));
                        throw new IRException(IRMessage.CANNOT_RENDER_REPORT, new Object[]{this.reportName});
                    }
                    rsr = this.getReportService(false).wait(rsr.getPrimaryRequest(), new ParameterValue[0], new Option[0]);
                }
                if (this.outputIsReady(rsr)) {
                    rsr = this.getReportService(false).getOutput(rsr.getPrimaryRequest(), new ParameterValue[0], new Option[0]);
                } else {
                    logger.error(Logger.EVENT_FAILURE, IRMessage.CANNOT_RENDER_REPORT.getLogMessage(new Object[]{this.reportName}));
                    throw new IRException(IRMessage.CANNOT_RENDER_REPORT, new Object[]{this.reportName});
                }
            }
            data = this.getOutputPage(rsr);
        }
        catch (RemoteException e) {
            logger.error(Logger.EVENT_FAILURE, IRMessage.CANNOT_RENDER_REPORT.getLogMessage(new Object[]{this.reportName}));
            throw new IRException(IRMessage.CANNOT_RENDER_REPORT, new Object[]{this.reportName});
        }
        return data != null ? (this.renderFormat.isBase64Encoded() ? Base64.decode((String)data) : data.getBytes()) : null;
    }

    private String getOutputPage(AsynchReply response) {
        AsynchDetailReportOutput reportOutput = null;
        for (int i = 0; i < response.getDetails().length; ++i) {
            if (!(response.getDetails()[i] instanceof AsynchDetailReportOutput)) continue;
            reportOutput = (AsynchDetailReportOutput)response.getDetails()[i];
            break;
        }
        return reportOutput != null ? reportOutput.getOutputPages()[0].toString() : null;
    }

    private boolean outputIsReady(AsynchReply response) {
        boolean isReady = false;
        for (int i = 0; i < response.getDetails().length; ++i) {
            if (!(response.getDetails()[i] instanceof AsynchDetailReportStatus) || ((AsynchDetailReportStatus)response.getDetails()[i]).getStatus() != AsynchDetailReportStatusEnum.responseReady || !Render.hasSecondaryRequest((AsynchReply)response, (String)"getOutput")) continue;
            isReady = true;
        }
        return isReady;
    }

    private static boolean hasSecondaryRequest(AsynchReply response, String secondaryRequest) {
        boolean hasSecRequest = false;
        AsynchSecondaryRequest[] secondaryRequests = response.getSecondaryRequests();
        for (int i = 0; i < secondaryRequests.length; ++i) {
            if (secondaryRequests[i].getName().compareTo(secondaryRequest) != 0) continue;
            hasSecRequest = true;
        }
        return hasSecRequest;
    }

    private ReportService_PortType getReportService(boolean isNewConversation) throws IRException {
        ReportService_PortType reportService = this.reportServer.getReportService();
        BiBusHeader bibus = this.getHeaderObject(((Stub)reportService).getResponseHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader"), isNewConversation);
        if (bibus == null) {
            bibus = this.getHeaderObject(((Stub)this.reportServer.getContentManagementService()).getResponseHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader"), true);
        }
        ((Stub)reportService).clearHeaders();
        ((Stub)reportService).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)bibus);
        return reportService;
    }

    private BiBusHeader getHeaderObject(SOAPHeaderElement sourceHeader, boolean isNewConversation) throws IRException {
        BiBusHeader bibus = null;
        if (sourceHeader != null) {
            try {
                bibus = (BiBusHeader)sourceHeader.getValueAsType(new QName("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader"));
                if (isNewConversation) {
                    bibus.setTracking(null);
                }
            }
            catch (Exception e) {
                logger.error(Logger.EVENT_FAILURE, IRMessage.CANNOT_RENDER_REPORT.getLogMessage(new Object[]{this.reportName}));
                throw new IRException(IRMessage.CANNOT_RENDER_REPORT, new Object[]{this.reportName});
            }
        }
        return bibus;
    }

    private void setRenderFormat(String format) throws IRException {
        StringBuilder supportedFormats = new StringBuilder();
        for (RenderFormat rf : RenderFormat.values()) {
            String name = rf.name();
            if (name.equals(format)) {
                this.renderFormat = rf;
                break;
            }
            supportedFormats.append("'").append(name).append("', ");
        }
        if (this.renderFormat == null) {
            logger.error(Logger.EVENT_FAILURE, String.format("Unsupported report rendering format '%s'.", format));
            throw new IRException(IRMessage.UNSUPPORTED_REPORT_RENDERING_FORMAT, new Object[]{format, supportedFormats.toString()});
        }
    }
}

