/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.reportserver.cognos;

import com.cognos.developer.schemas.bibus._3.AccessEnum;
import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.Folder;
import com.cognos.developer.schemas.bibus._3.MultilingualToken;
import com.cognos.developer.schemas.bibus._3.MultilingualTokenProp;
import com.cognos.developer.schemas.bibus._3.Permission;
import com.cognos.developer.schemas.bibus._3.Policy;
import com.cognos.developer.schemas.bibus._3.PolicyArrayProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.Role;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.UpdateOptions;
import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class InitialFoldersInstallation {
    protected static final String COGNOS_NAMESPACE = "CAMID(\":\")";
    private static final String LOCALE_EN_ZW = "en-zw";
    private static final String LOCALE_EN = "en-us";
    private static final String LN_BUS_AUTHOR = "infor.ln.businessauthor";
    private static final String LN_ADMIN = "infor.ln.administrator";
    private static final String LN_CONSUMER = "infor.ln.consumer";
    private static final String[] FOLDER_I10R = new String[]{"i10r", "Infor Reporting"};
    private static final String[] FOLDER_LN = new String[]{"infor.ln", "Infor LN"};
    private static final String[] FOLDER_REP = new String[]{"rep", "SessionReports"};
    private static final String MSG_FOLDER_PRESENT = "Folder '%s' will not be created (already present)";
    private static final String SETTING_PERMISSIONS = "Setting permissions for '%s' on %s '%s'";
    private static final String PERMISSIONS_SET = "Permissions on %s '%s' have been set";
    private static Logger logger = ESAPI.getLogger(InitialFoldersInstallation.class);
    private static final Permission[] LA_PERMISSIONS = new Permission[]{new Permission(AccessEnum.grant, "read"), new Permission(AccessEnum.grant, "write"), new Permission(AccessEnum.grant, "traverse")};
    private static final Permission[] LB_PERMISSIONS = new Permission[]{new Permission(AccessEnum.grant, "read"), new Permission(AccessEnum.grant, "write"), new Permission(AccessEnum.grant, "execute"), new Permission(AccessEnum.grant, "traverse")};
    private static final Permission[] LC_PERMISSIONS = new Permission[]{new Permission(AccessEnum.grant, "read"), new Permission(AccessEnum.grant, "execute"), new Permission(AccessEnum.grant, "traverse")};
    protected ContentManagerService_PortType mCMService;

    protected Role getRole(String rolename) throws IRException {
        PropEnum[] properties = new PropEnum[]{PropEnum.searchPath, PropEnum.defaultName, PropEnum.members};
        String pathString = String.format("%s//role[@name='%s']", "CAMID(\":\")", rolename);
        SearchPathMultipleObject searchPath = new SearchPathMultipleObject(pathString);
        Role matchingRole = null;
        try {
            BaseClass[] result = this.mCMService.query(searchPath, properties, new Sort[0], new QueryOptions());
            if (result != null && result.length > 0 && result[0] instanceof Role) {
                matchingRole = (Role)result[0];
            }
        }
        catch (RemoteException e) {
            logger.error(Logger.EVENT_FAILURE, IRMessage.ERROR_QUERYING_LN_ROLE.getLogMessage(new Object[]{rolename}), (Throwable)e);
            throw new IRException(IRMessage.ERROR_QUERYING_LN_ROLE, new Object[]{rolename});
        }
        return matchingRole;
    }

    public InitialFoldersInstallation(ContentManagerService_PortType cmService) throws IRException {
        this.mCMService = cmService;
    }

    protected void createLNFolders() throws IRException {
        LinkedHashMap<String, String> translations = new LinkedHashMap<String, String>();
        translations.put("en-zw", FOLDER_I10R[0]);
        translations.put("en-us", FOLDER_I10R[1]);
        if (this.getFolder(InitialFoldersInstallation.createFolderSearchPath((String[])new String[]{FOLDER_I10R[0]})) == null) {
            this.createFolder("/content", translations);
        } else if (logger.isInfoEnabled()) {
            logger.info(Logger.EVENT_UNSPECIFIED, String.format("Folder '%s' will not be created (already present)", FOLDER_I10R[0]));
        }
        translations.clear();
        translations.put("en-zw", FOLDER_LN[0]);
        translations.put("en-us", FOLDER_LN[1]);
        if (this.getFolder(InitialFoldersInstallation.createFolderSearchPath((String[])new String[]{FOLDER_I10R[0], FOLDER_LN[0]})) == null) {
            Folder folder = this.createFolder(InitialFoldersInstallation.createFolderSearchPath((String[])new String[]{FOLDER_I10R[0]}), translations);
            if (folder != null) {
                this.removePolicies((BaseClass)folder);
                String name = "infor.ln.administrator";
                this.setRWPermission((BaseClass)this.getRole(name), (BaseClass)folder, LA_PERMISSIONS);
                name = "infor.ln.businessauthor";
                this.setRWPermission((BaseClass)this.getRole(name), (BaseClass)folder, LB_PERMISSIONS);
                name = "infor.ln.consumer";
                this.setRWPermission((BaseClass)this.getRole(name), (BaseClass)folder, LC_PERMISSIONS);
            }
        } else if (logger.isInfoEnabled()) {
            logger.info(Logger.EVENT_UNSPECIFIED, String.format("Folder '%s' will not be created (already present)", FOLDER_LN[0]));
        }
        translations.put("en-zw", FOLDER_REP[0]);
        translations.put("en-us", FOLDER_REP[1]);
        if (this.getFolder(InitialFoldersInstallation.createFolderSearchPath((String[])new String[]{FOLDER_I10R[0], FOLDER_LN[0], FOLDER_REP[0]})) == null) {
            this.createFolder(InitialFoldersInstallation.createFolderSearchPath((String[])new String[]{FOLDER_I10R[0], FOLDER_LN[0]}), translations);
        } else if (logger.isInfoEnabled()) {
            logger.info(Logger.EVENT_UNSPECIFIED, String.format("Folder '%s' will not be created (already present)", FOLDER_REP[0]));
        }
    }

    private BaseClass getFolder(String folderPath) throws IRException {
        PropEnum[] properties = new PropEnum[]{PropEnum.searchPath, PropEnum.defaultName, PropEnum.policies};
        SearchPathMultipleObject searchPath = new SearchPathMultipleObject(folderPath);
        BaseClass folder = null;
        try {
            BaseClass[] result = this.mCMService.query(searchPath, properties, new Sort[0], new QueryOptions());
            if (result != null && result.length > 0) {
                folder = result[0];
            }
        }
        catch (RemoteException e) {
            logger.error(Logger.EVENT_FAILURE, IRMessage.ERROR_QUERYING_FOLDER.getLogMessage(new Object[]{folderPath}), (Throwable)e);
            throw new IRException(IRMessage.ERROR_QUERYING_FOLDER, new Object[]{folderPath});
        }
        return folder;
    }

    private static String createFolderSearchPath(String ... aFolders) {
        StringBuilder searchPath = new StringBuilder("/content");
        if (aFolders != null) {
            for (String folder : aFolders) {
                searchPath.append("/folder[@name='").append(folder).append("']");
            }
        }
        return searchPath.toString();
    }

    private Folder createFolder(String parentPath, Map<String, String> localizedNames) throws IRException {
        Folder folder = null;
        BaseClass parent = this.getFolder(parentPath);
        if (parent != null) {
            StringBuilder logMessage = new StringBuilder("Creating folder with localized names:");
            ArrayList<MultilingualToken> tokens = new ArrayList<MultilingualToken>();
            for (Map.Entry<String, String> localeNamePair : localizedNames.entrySet()) {
                String locale = localeNamePair.getKey();
                String name = localeNamePair.getValue();
                tokens.add(new MultilingualToken(locale, name));
                logMessage.append(" (").append(locale).append(": ").append(name).append(")");
            }
            if (logger.isInfoEnabled()) {
                logger.info(Logger.EVENT_UNSPECIFIED, logMessage.toString());
            }
            MultilingualTokenProp nameProp = new MultilingualTokenProp();
            nameProp.setValue(tokens.toArray(new MultilingualToken[tokens.size()]));
            Folder newFolder = new Folder();
            newFolder.setName(nameProp);
            SearchPathSingleObject parentSearchPath = new SearchPathSingleObject(parentPath);
            try {
                AddOptions options = new AddOptions();
                options.setReturnProperties(new PropEnum[]{PropEnum.searchPath, PropEnum.defaultName, PropEnum.policies});
                BaseClass[] result = this.mCMService.add(parentSearchPath, new BaseClass[]{newFolder}, options);
                if (result != null && result.length > 0 && result[0] instanceof Folder) {
                    folder = (Folder)result[0];
                }
            }
            catch (RemoteException e) {
                String name = nameProp.getValue()[0].getValue();
                logger.error(Logger.EVENT_FAILURE, IRMessage.CREATE_FOLDER_EXCEPTION.getLogMessage(new Object[]{name}), (Throwable)e);
                throw new IRException(IRMessage.CREATE_FOLDER_EXCEPTION, new Object[]{name});
            }
        }
        return folder;
    }

    private void setRWPermission(BaseClass account, BaseClass object, Permission[] permissions) throws IRException {
        Policy newPolicy = new Policy();
        newPolicy.setPermissions(permissions);
        newPolicy.setSecurityObject(account);
        ArrayList<Policy> newPolicies = new ArrayList<Policy>();
        PolicyArrayProp existingPoliciesProp = object.getPolicies();
        Policy[] existingPolicies = null;
        if (existingPoliciesProp != null) {
            existingPolicies = existingPoliciesProp.getValue();
        }
        if (existingPolicies == null) {
            existingPolicies = new Policy[]{};
        }
        String searchPath = account.getSearchPath().getValue();
        boolean found = false;
        for (Policy existingPolicy : existingPolicies) {
            if (searchPath.equals(existingPolicy.getSecurityObject().getSearchPath().getValue())) {
                found = true;
                newPolicies.add(newPolicy);
                continue;
            }
            newPolicies.add(existingPolicy);
        }
        if (!found) {
            newPolicies.add(newPolicy);
        }
        PolicyArrayProp newPoliciesProp = new PolicyArrayProp();
        newPoliciesProp.setValue(newPolicies.toArray(new Policy[newPolicies.size()]));
        object.setPolicies(newPoliciesProp);
        String accountName = account.getDefaultName() != null ? account.getDefaultName().getValue() : account.getSearchPath().getValue();
        String objectName = object.getDefaultName() != null ? object.getDefaultName().getValue() : account.getSearchPath().getValue();
        String objectType = object.getClass().getSimpleName().toLowerCase();
        try {
            if (logger.isInfoEnabled()) {
                logger.info(Logger.EVENT_UNSPECIFIED, String.format("Setting permissions for '%s' on %s '%s'", accountName, objectType, objectName));
            }
            this.mCMService.update(new BaseClass[]{object}, new UpdateOptions());
            if (logger.isInfoEnabled()) {
                logger.info(Logger.EVENT_UNSPECIFIED, String.format("Permissions on %s '%s' have been set", objectType, objectName));
            }
        }
        catch (RemoteException e) {
            logger.error(Logger.EVENT_FAILURE, IRMessage.ERROR_SETTING_PERMISSIONS.getLogMessage(new Object[]{objectType, objectName}), (Throwable)e);
            throw new IRException(IRMessage.ERROR_SETTING_PERMISSIONS, new Object[]{objectType, objectName});
        }
    }

    private void removePolicies(BaseClass object) {
        PolicyArrayProp policiesProp = new PolicyArrayProp();
        object.setPolicies(policiesProp);
    }
}

