/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.reportserver.cognos;

import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.AnyTypeProp;
import com.cognos.developer.schemas.bibus._3.AsynchDetailEventID;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AuditLevelEnum;
import com.cognos.developer.schemas.bibus._3.AuthoredReport;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.Content;
import com.cognos.developer.schemas.bibus._3.DeploymentImportRule;
import com.cognos.developer.schemas.bibus._3.DeploymentOption;
import com.cognos.developer.schemas.bibus._3.DeploymentOptionArrayProp;
import com.cognos.developer.schemas.bibus._3.DeploymentOptionAuditLevel;
import com.cognos.developer.schemas.bibus._3.DeploymentOptionBoolean;
import com.cognos.developer.schemas.bibus._3.DeploymentOptionEnum;
import com.cognos.developer.schemas.bibus._3.DeploymentOptionImportRuleArray;
import com.cognos.developer.schemas.bibus._3.DeploymentOptionString;
import com.cognos.developer.schemas.bibus._3.Folder;
import com.cognos.developer.schemas.bibus._3.GuidProp;
import com.cognos.developer.schemas.bibus._3.ImportDeployment;
import com.cognos.developer.schemas.bibus._3.MultilingualToken;
import com.cognos.developer.schemas.bibus._3.MultilingualTokenProp;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.cognos.developer.schemas.bibus._3.UpdateOptions;
import com.cognos.developer.schemas.bibus._3._package;
import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.reportserver.cognos.CognosReportServer;
import com.infor.erpln.soap.XMLUtil;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class Import {
    private static final String IMPORT_DEPLOYMENT_SUFFIX = "_import";
    private static final String IMPORT_DEPLOYMENT_PATH = "/adminFolder/importDeployment[@name='%s']";
    private static final String PARSE_ERROR = "Error parsing the report XML";
    private static final String UNEXPECTED_ERROR = "Unexpected error";
    private static final String LOCALE_EN = "en";
    private static final String LOCALE_EN_US = "en-us";
    private static final String LOCALE_EN_ZW = "en-zw";
    private static final String ATTR_EXPRESSION_LOCALE = "expressionLocale";
    private static Logger logger = ESAPI.getLogger(Import.class);
    private static Pattern subFolderPattern;
    private final CognosReportServer reportServer;

    public Import(CognosReportServer reportServer) {
        this.reportServer = reportServer;
    }

    public IRMessage importPackage(String archiveName, String destinationFolder, String tenantID) throws IRException {
        IRMessage ret = IRMessage.OK;
        int separatorIndex = archiveName.lastIndexOf(95);
        String packageName = archiveName.substring(separatorIndex + 1);
        String destinationPath = destinationFolder;
        if (destinationFolder == null || destinationFolder.isEmpty()) {
            destinationPath = "/content";
        }
        destinationPath = destinationPath.trim();
        if (logger.isDebugEnabled()) {
            logger.debug(Logger.EVENT_UNSPECIFIED, String.format("Starting import for archive '%s' to destination folder: %s", archiveName, destinationPath));
        }
        if (!this.validateFolders(destinationPath)) {
            throw new IRException(IRMessage.CANNOT_IMPORT_PACKAGE, new Object[]{archiveName});
        }
        String deploymentName = Import.getDeploymentName((String)archiveName, (String)tenantID);
        String importSearchPath = String.format("/adminFolder/importDeployment[@name='%s']", deploymentName);
        this.addImportDeploymentEntry(archiveName, deploymentName, destinationPath);
        this.runImportDeploymentEntry(importSearchPath, archiveName);
        ret = this.patchSearchPaths(packageName, destinationPath);
        return ret;
    }

    private static String getDeploymentName(String archiveName, String tenantID) {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank((String)tenantID)) {
            builder.append(tenantID).append("_");
        }
        builder.append(archiveName).append("_import");
        return builder.toString();
    }

    private boolean validateFolders(String searchPath) {
        if (logger.isDebugEnabled()) {
            logger.debug(Logger.EVENT_UNSPECIFIED, String.format("Validating presence of search path '%s'", searchPath));
        }
        try {
            SearchPathMultipleObject path = new SearchPathMultipleObject(searchPath);
            PropEnum[] properties = new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath};
            Sort[] sortBy = new Sort[]{};
            QueryOptions options = new QueryOptions();
            BaseClass[] queryResult = this.reportServer.getContentManagementService().query(path, properties, sortBy, options);
            if (queryResult != null && queryResult.length > 0 && (queryResult[0] instanceof Folder || queryResult[0] instanceof Content)) {
                if (logger.isDebugEnabled()) {
                    logger.debug(Logger.EVENT_SUCCESS, String.format("OK, found search path '%s'", searchPath));
                }
                return true;
            }
            Matcher matcher = subFolderPattern.matcher(searchPath);
            if (matcher.matches()) {
                String parentPath = matcher.group(1);
                String folderName = matcher.group(2);
                if (this.validateFolders(parentPath)) {
                    Folder subFolder = new Folder();
                    MultilingualToken[] nameValues = new MultilingualToken[]{new MultilingualToken("en-zw", folderName), new MultilingualToken("en-us", folderName)};
                    MultilingualTokenProp name = new MultilingualTokenProp();
                    name.setValue(nameValues);
                    subFolder.setName(name);
                    AddOptions addOptions = new AddOptions();
                    addOptions.setUpdateAction(UpdateActionEnum.update);
                    if (logger.isDebugEnabled()) {
                        logger.debug(Logger.EVENT_UNSPECIFIED, String.format("Trying to create subfolder '%s' in search path '%s'", folderName, parentPath));
                    }
                    this.reportServer.getContentManagementService().add(new SearchPathSingleObject(parentPath), new BaseClass[]{subFolder}, addOptions);
                    if (logger.isDebugEnabled()) {
                        logger.debug(Logger.EVENT_SUCCESS, String.format("OK, subfolder '%s' was created", folderName));
                    }
                    return true;
                }
            } else {
                logger.error(Logger.EVENT_FAILURE, String.format("Cannot create missing path '%s'", searchPath));
            }
        }
        catch (RemoteException ex) {
            logger.error(Logger.EVENT_FAILURE, String.format("Exception when validating search path '%s': ", searchPath, ex.getMessage()));
        }
        return false;
    }

    private void addImportDeploymentEntry(String archiveName, String deploymentName, String destinationPath) throws IRException {
        SearchPathMultipleObject spMulti = new SearchPathMultipleObject();
        spMulti.set_value("/adminFolder");
        PropEnum[] props = new PropEnum[]{PropEnum.searchPath, PropEnum.policies};
        BaseClass[] importDeplFolder = null;
        try {
            importDeplFolder = this.reportServer.getContentManagementService().query(spMulti, props, new Sort[0], new QueryOptions());
        }
        catch (RemoteException ex) {
            logger.error(Logger.EVENT_FAILURE, String.format("Unable to locate the deployment folder for importing archive '%s'", archiveName), (Throwable)ex);
            throw new IRException(IRMessage.CANNOT_IMPORT_PACKAGE, new Object[]{archiveName});
        }
        ImportDeployment newImport = new ImportDeployment();
        TokenProp tp = new TokenProp();
        tp.setValue(deploymentName);
        newImport.setDefaultName(tp);
        BaseClassArrayProp parent = new BaseClassArrayProp();
        parent.setValue(importDeplFolder);
        newImport.setParent(parent);
        DeploymentOptionArrayProp doap = new DeploymentOptionArrayProp();
        DeploymentOption[] options = this.getDeploymentOptions(archiveName, destinationPath);
        if (options.length == 0) {
            throw new IRException(IRMessage.ARCHIVE_MISSING, new Object[]{archiveName});
        }
        doap.setValue(options);
        newImport.setDeploymentOptions(doap);
        AddOptions ao = new AddOptions();
        ao.setUpdateAction(UpdateActionEnum.replace);
        SearchPathSingleObject spSingle = new SearchPathSingleObject("/adminFolder");
        BaseClass[] archive = null;
        if (logger.isDebugEnabled()) {
            logger.debug(Logger.EVENT_UNSPECIFIED, String.format("Adding import deployment entry for archive '%s'", archiveName));
        }
        try {
            archive = this.reportServer.getContentManagementService().add(spSingle, new BaseClass[]{newImport}, ao);
        }
        catch (RemoteException ex) {
            logger.error(Logger.EVENT_FAILURE, "No Import was added to the Content Store.", (Throwable)ex);
        }
        if (archive == null || archive.length <= 0) {
            throw new IRException(IRMessage.CANNOT_IMPORT_PACKAGE, new Object[]{archiveName});
        }
    }

    private void runImportDeploymentEntry(String importSearchPath, String archiveName) throws IRException {
        SearchPathSingleObject spSingle = new SearchPathSingleObject(importSearchPath);
        String eventID = null;
        if (logger.isDebugEnabled()) {
            logger.debug(Logger.EVENT_UNSPECIFIED, String.format("Running import deployment entry for archive '%s'", archiveName));
        }
        try {
            String statusValue;
            AsynchReply reply = this.reportServer.getMonitorService().run(spSingle, new ParameterValue[0], new Option[0]);
            if (!reply.getStatus().equals((Object)AsynchReplyStatusEnum.conversationComplete)) {
                while (!reply.getStatus().equals((Object)AsynchReplyStatusEnum.conversationComplete)) {
                    reply = this.reportServer.getMonitorService().wait(reply.getPrimaryRequest(), new ParameterValue[0], new Option[0]);
                }
            }
            if ("conversationComplete".equals(statusValue = reply.getStatus().getValue()) || "complete".equals(statusValue)) {
                eventID = ((AsynchDetailEventID)reply.getDetails()[0]).getEventID();
            }
        }
        catch (RemoteException ex) {
            logger.error(Logger.EVENT_FAILURE, String.format("Failure when running the import for archive '%s'", archiveName), (Throwable)ex);
            throw new IRException(IRMessage.CANNOT_IMPORT_PACKAGE, new Object[]{archiveName});
        }
        if (eventID == null) {
            logger.error(Logger.EVENT_FAILURE, String.format("Import was unsuccessful. Check the Import History for entry '%s_import' in the Administration web page", archiveName));
            throw new IRException(IRMessage.CANNOT_IMPORT_PACKAGE, new Object[]{archiveName});
        }
    }

    private DeploymentOption[] getDeploymentOptions(String archiveName, String destinationPath) {
        ArrayList<Object> optionList = new ArrayList<Object>();
        try {
            Option[] existingOptions = this.reportServer.getContentManagementService().getDeploymentOptions(archiveName, new Option[0]);
            DeploymentOptionEnum ownershipOptionEnum = DeploymentOptionEnum.fromString((String)"takeOwnership");
            optionList.add(new DeploymentOptionBoolean(ownershipOptionEnum, true));
            DeploymentOptionEnum packageOptionEnum = DeploymentOptionEnum.fromString((String)"package");
            DeploymentOptionEnum importOptionEnum = DeploymentOptionEnum.fromString((String)"import");
            DeploymentOptionEnum archiveOptionEnum = DeploymentOptionEnum.fromString((String)"archive");
            optionList.add(new DeploymentOptionString(archiveOptionEnum, archiveName));
            DeploymentOptionEnum recordingLevelOptionEnum = DeploymentOptionEnum.fromString((String)"recordingLevel");
            optionList.add(new DeploymentOptionAuditLevel(recordingLevelOptionEnum, AuditLevelEnum.full));
            for (Option option : existingOptions) {
                DeploymentOption deploymentOption = (DeploymentOption)option;
                DeploymentOptionEnum optionName = deploymentOption.getName();
                if (optionName.equals((Object)importOptionEnum)) {
                    DeploymentImportRule[] ruleArray = ((DeploymentOptionImportRuleArray)option).getValue();
                    if (ruleArray == null || ruleArray.length <= 0) continue;
                    ruleArray[0].setParent(new SearchPathSingleObject(destinationPath));
                    optionList.add(deploymentOption);
                    continue;
                }
                if (optionName.equals((Object)ownershipOptionEnum) || optionName.equals((Object)packageOptionEnum) || optionName.equals((Object)recordingLevelOptionEnum) || optionName.equals((Object)archiveOptionEnum)) continue;
                optionList.add(deploymentOption);
            }
        }
        catch (Exception ex) {
            logger.error(Logger.EVENT_FAILURE, "Error during retrieval of deployment options.", (Throwable)ex);
        }
        return optionList.toArray(new DeploymentOption[optionList.size()]);
    }

    private IRMessage patchSearchPaths(String packageName, String installedPath) throws IRException {
        IRMessage ret = IRMessage.OK;
        try {
            String packagePath = String.format("%s/package[@name='%s']", installedPath, packageName);
            SearchPathMultipleObject queryPath = new SearchPathMultipleObject(packagePath);
            PropEnum[] properties = new PropEnum[]{PropEnum.searchPath, PropEnum.storeID};
            Sort[] sortBy = new Sort[]{};
            QueryOptions options = new QueryOptions();
            BaseClass[] results = this.reportServer.getContentManagementService().query(queryPath, properties, sortBy, options);
            if (results != null && results.length == 1) {
                StringProp packageSearchPath = results[0].getSearchPath();
                GuidProp packageStoreID = results[0].getStoreID();
                queryPath = new SearchPathMultipleObject(packagePath + "/report");
                properties = new PropEnum[]{PropEnum.searchPath, PropEnum.defaultName};
                results = this.reportServer.getContentManagementService().query(queryPath, properties, sortBy, options);
                if (results != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(Logger.EVENT_UNSPECIFIED, String.format("About to patch %d reports", results.length));
                    }
                    for (BaseClass result : results) {
                        if (!(result instanceof AuthoredReport)) continue;
                        String reportName = ((AuthoredReport)result).getDefaultName().getValue();
                        queryPath = new SearchPathMultipleObject(String.format("%s/report[@name='%s']", packagePath, reportName));
                        properties = new PropEnum[]{PropEnum.searchPath, PropEnum.specification, PropEnum.metadataModel, PropEnum.metadataModelPackage, PropEnum.defaultName};
                        BaseClass[] details = this.reportServer.getContentManagementService().query(queryPath, properties, sortBy, options);
                        if (details != null && details.length == 1 && details[0] instanceof AuthoredReport) {
                            if (logger.isDebugEnabled()) {
                                logger.debug(Logger.EVENT_UNSPECIFIED, String.format("Patching report '%s'", reportName));
                            }
                            this.patchReport((AuthoredReport)details[0], packageName, packagePath, packageSearchPath, packageStoreID);
                            continue;
                        }
                        logger.error(Logger.EVENT_FAILURE, String.format("Failed to obtain details for report '%s'", reportName));
                    }
                } else {
                    logger.warning(Logger.EVENT_FAILURE, "patchSearchPaths: Query did not return a report!");
                    ret = IRMessage.REPORT_NOT_FOUND;
                }
            } else {
                logger.warning(Logger.EVENT_FAILURE, "patchSearchPaths: Query did not return a package!");
                ret = IRMessage.PACKAGE_NOT_FOUND;
            }
        }
        catch (RemoteException ex) {
            logger.error(Logger.EVENT_FAILURE, "Error when querying the imported package/report", (Throwable)ex);
            throw new IRException(IRMessage.CANNOT_IMPORT_REPORT, new Object[]{installedPath});
        }
        return ret;
    }

    private void patchReport(AuthoredReport report, String packageName, String packagePath, StringProp packageSearchPath, GuidProp packageStoreID) {
        try {
            BaseClassArrayProp model;
            BaseClass[] modelValue;
            BaseClassArrayProp modelPackage;
            BaseClass[] modelPackageValue;
            boolean changed = false;
            AnyTypeProp specification = report.getSpecification();
            String reportSpec = specification.getValue();
            String newModelPath = packagePath + "/model[@name='model']";
            String patchedReportSpec = this.replaceModelPath(reportSpec, newModelPath);
            if (!patchedReportSpec.equals(reportSpec)) {
                specification.setValue(patchedReportSpec);
                changed = true;
            }
            if ((modelPackageValue = (modelPackage = report.getMetadataModelPackage()).getValue()) == null) {
                modelPackageValue = new BaseClass[]{new _package()};
                modelPackageValue[0].setSearchPath(packageSearchPath);
                modelPackageValue[0].setStoreID(packageStoreID);
                if (logger.isDebugEnabled()) {
                    logger.debug(Logger.EVENT_UNSPECIFIED, "Setting 'metadataModelPackage' of report to: " + packagePath);
                }
                modelPackage.setValue(modelPackageValue);
                changed = true;
            }
            if ((modelValue = (model = report.getMetadataModel()).getValue()) == null) {
                SearchPathMultipleObject queryPath = new SearchPathMultipleObject(newModelPath);
                PropEnum[] properties = new PropEnum[]{PropEnum.searchPath, PropEnum.storeID};
                Sort[] sortBy = new Sort[]{};
                QueryOptions options = new QueryOptions();
                BaseClass[] results = this.reportServer.getContentManagementService().query(queryPath, properties, sortBy, options);
                if (results != null && results.length == 1) {
                    StringProp modelSearchPath = results[0].getSearchPath();
                    GuidProp modelStoreID = results[0].getStoreID();
                    modelValue = new BaseClass[]{new _package()};
                    modelValue[0].setSearchPath(modelSearchPath);
                    modelValue[0].setStoreID(modelStoreID);
                    if (logger.isDebugEnabled()) {
                        logger.debug(Logger.EVENT_UNSPECIFIED, "Setting 'metadataModel' of report to: " + newModelPath);
                    }
                    model.setValue(modelValue);
                    changed = true;
                } else {
                    logger.warning(Logger.EVENT_FAILURE, "patchSearchPaths: Query did not return a model!");
                }
            }
            if (changed) {
                UpdateOptions updateOptions = new UpdateOptions();
                BaseClass[] results = this.reportServer.getContentManagementService().update(new BaseClass[]{report}, updateOptions);
                logger.debug(Logger.EVENT_UNSPECIFIED, "Report has been changed");
                if (results == null || results.length == 0) {
                    logger.error(Logger.EVENT_FAILURE, String.format("Updating report '%s' in the Content Store failed", packageName));
                }
            } else {
                logger.debug(Logger.EVENT_SUCCESS, "No changes were made to report");
            }
        }
        catch (RemoteException ex) {
            logger.error(Logger.EVENT_FAILURE, "Error when patching the searchpath in the imported report", (Throwable)ex);
        }
    }

    private String replaceModelPath(String reportXML, String modelPath) {
        String result = reportXML;
        try {
            DocumentBuilderFactory documentFactory = XMLUtil.getSecureDocumentBuilderFactory();
            documentFactory.setNamespaceAware(true);
            DocumentBuilder builder = documentFactory.newDocumentBuilder();
            InputSource in = new InputSource(new StringReader(reportXML));
            Document reportDocument = builder.parse(in);
            String nsURI = reportDocument.getFirstChild().getNamespaceURI();
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext((NamespaceContext)new /* Unavailable Anonymous Inner Class!! */);
            boolean changed = false;
            Node modelPathNode = (Node)xpath.evaluate("/ns:report/ns:modelPath", reportDocument, XPathConstants.NODE);
            if (modelPathNode instanceof Element) {
                String oldPath = modelPathNode.getTextContent();
                if (!oldPath.equals(modelPath)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(Logger.EVENT_UNSPECIFIED, "Replacing model path in report specification: old: " + oldPath + " new: " + modelPath);
                    }
                    modelPathNode.setTextContent(modelPath);
                    changed = true;
                } else {
                    logger.debug(Logger.EVENT_UNSPECIFIED, "Model path in report does not need to be replaced");
                }
            } else {
                logger.debug(Logger.EVENT_FAILURE, "Could not find 'modelPath' node in report specification");
            }
            Element modelNode = (Element)xpath.evaluate("/ns:report", reportDocument, XPathConstants.NODE);
            String expressionLocale = modelNode.getAttribute("expressionLocale");
            if (!"en".equals(expressionLocale)) {
                logger.warning(Logger.EVENT_FAILURE, "Expression locale of report was \"" + expressionLocale + "\"; this should be \"en\"");
            }
            if (changed) {
                result = this.printXmlToString((Node)reportDocument);
            }
        }
        catch (ParserConfigurationException e) {
            logger.error(Logger.EVENT_FAILURE, "Unexpected error", (Throwable)e);
        }
        catch (SAXException e) {
            logger.error(Logger.EVENT_FAILURE, "Error parsing the report XML", (Throwable)e);
        }
        catch (IOException e) {
            logger.error(Logger.EVENT_FAILURE, "Error parsing the report XML", (Throwable)e);
        }
        catch (XPathExpressionException e) {
            logger.error(Logger.EVENT_FAILURE, "Unexpected error", (Throwable)e);
        }
        return result;
    }

    private String printXmlToString(Node node) {
        String result = null;
        try {
            Transformer transformer = XMLUtil.getSecureTransformerFactory().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(writer));
            result = writer.getBuffer().toString();
        }
        catch (TransformerFactoryConfigurationError e) {
            logger.error(Logger.EVENT_FAILURE, "Unexpected error", (Throwable)e);
        }
        catch (TransformerException e) {
            logger.error(Logger.EVENT_FAILURE, "Unexpected error", (Throwable)e);
        }
        return result;
    }

    static {
        try {
            subFolderPattern = Pattern.compile("^(.*)/folder\\[@name=['\"]([^\\]]+)['\"]\\]$");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }
}

