/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.reportserver.cognos;

import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.DeploymentImportRule;
import com.cognos.developer.schemas.bibus._3.DeploymentOption;
import com.cognos.developer.schemas.bibus._3.DeploymentOptionBoolean;
import com.cognos.developer.schemas.bibus._3.DeploymentOptionEnum;
import com.cognos.developer.schemas.bibus._3.DeploymentOptionImportRuleArray;
import com.cognos.developer.schemas.bibus._3.DeploymentOptionMultilingualString;
import com.cognos.developer.schemas.bibus._3.DeploymentOptionSearchPathSingleObjectArray;
import com.cognos.developer.schemas.bibus._3.DeploymentOptionString;
import com.cognos.developer.schemas.bibus._3.ExportDeployment;
import com.cognos.developer.schemas.bibus._3.MultilingualString;
import com.cognos.developer.schemas.bibus._3.MultilingualToken;
import com.cognos.developer.schemas.bibus._3.MultilingualTokenProp;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OptionArrayProp;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.cognos.developer.schemas.bibus._3.UpdateOptions;
import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.reportserver.cognos.CognosReportServer;
import java.rmi.RemoteException;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class Export {
    private static final int NUMBER_DEPLOYMENT_OPTIONS = 8;
    private static final String DEPLOYMENT_OPTION_EXPORT = "export";
    private static final String DEPLOYMENT_OPTION_IMPORT = "import";
    private static final String DEPLOYMENT_OPTION_ARCHIVE_OVERWRITE = "archiveOverwrite";
    private static final String DEPLOYMENT_OPTION_DEPLOYMENT_NAME = "deploymentName";
    private static final String DEPLOYMENT_OPTION_ARCHIVE = "archive";
    private static final String DEPLOYMENT_OPTION_TAKE_OWNERSHIP = "takeOwnership";
    private static final String DEPLOYMENT_OPTION_NAMESPACE_THIRD_PARTY = "namespaceThirdParty";
    private static final String DEPLOYMENT_OPTION_OBJECT_POLICIES = "objectPolicies";
    private static final String LOCALE_EN_US = "en-us";
    private static Logger logger = ESAPI.getLogger(Export.class);
    private final CognosReportServer reportServer;

    public Export(CognosReportServer reportServer) {
        this.reportServer = reportServer;
    }

    public String exportPackage(String archiveName, String reportFolder, boolean overwrite) throws IRException {
        SearchPathSingleObject archiveSearchPath = new SearchPathSingleObject();
        try {
            ExportDeployment archive = this.addArchive(archiveName, overwrite);
            archiveSearchPath.set_value(archive.getSearchPath().getValue());
            Option[] dop = this.setDeploymentOptionEnum(archiveName, reportFolder);
            OptionArrayProp doap = new OptionArrayProp();
            doap.setValue(dop);
            archive.setOptions(doap);
            this.reportServer.getContentManagementService().update(new BaseClass[]{archive}, new UpdateOptions());
        }
        catch (RemoteException e) {
            logger.error(Logger.EVENT_FAILURE, String.format("Failed to add Export Deployment '%s' to the Content Store.", archiveName), (Throwable)e);
            throw new IRException(IRMessage.CANNOT_EXPORT_REPORT, new Object[]{archiveName});
        }
        this.doExport(archiveName, archiveSearchPath);
        return archiveName;
    }

    private ExportDeployment addArchive(String archiveName, boolean overwrite) throws IRException, RemoteException {
        ExportDeployment exportDeployment = null;
        BaseClass[] addedDeploymentObjects = new BaseClass[1];
        AddOptions addOptions = null;
        if (logger.isInfoEnabled()) {
            logger.info(Logger.EVENT_UNSPECIFIED, String.format("Adding export deployment '%s' to the Content Store.", archiveName));
        }
        SearchPathSingleObject adminFolderSearchPath = new SearchPathSingleObject();
        adminFolderSearchPath.set_value("/adminFolder");
        MultilingualTokenProp multilingualTokenProperty = new MultilingualTokenProp();
        MultilingualToken[] multilingualTokenArr = new MultilingualToken[1];
        MultilingualToken myMultilingualToken = new MultilingualToken();
        myMultilingualToken.setLocale(LOCALE_EN_US);
        myMultilingualToken.setValue(archiveName);
        multilingualTokenArr[0] = myMultilingualToken;
        multilingualTokenProperty.setValue(multilingualTokenArr);
        exportDeployment = new ExportDeployment();
        addOptions = new AddOptions();
        exportDeployment.setName(multilingualTokenProperty);
        if (overwrite) {
            addOptions.setUpdateAction(UpdateActionEnum.replace);
        } else {
            addOptions.setUpdateAction(UpdateActionEnum.fail);
        }
        addedDeploymentObjects = this.reportServer.getContentManagementService().add(adminFolderSearchPath, new BaseClass[]{exportDeployment}, addOptions);
        if (addedDeploymentObjects == null || addedDeploymentObjects.length <= 0) {
            logger.error(Logger.EVENT_FAILURE, "No Export Deployment was added to the Content Store.");
            throw new IRException(IRMessage.CANNOT_EXPORT_REPORT, new Object[]{archiveName});
        }
        return (ExportDeployment)addedDeploymentObjects[0];
    }

    private void doExport(String archiveName, SearchPathSingleObject exportPath) throws IRException {
        AsynchReply res = null;
        try {
            if (logger.isInfoEnabled()) {
                logger.info(Logger.EVENT_UNSPECIFIED, String.format("Exporting '%s' to the Content Store.", archiveName));
            }
            if (!(res = this.reportServer.getMonitorService().run(exportPath, new ParameterValue[0], new Option[0])).getStatus().equals((Object)AsynchReplyStatusEnum.conversationComplete)) {
                while (!res.getStatus().equals((Object)AsynchReplyStatusEnum.conversationComplete)) {
                    logger.debug(Logger.EVENT_UNSPECIFIED, "Waiting for the export to complete.");
                    res = this.reportServer.getMonitorService().wait(res.getPrimaryRequest(), new ParameterValue[0], new Option[0]);
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info(Logger.EVENT_SUCCESS, String.format("Export of '%s' to the Content Store did succeed.", archiveName));
            }
        }
        catch (Exception e) {
            logger.error(Logger.EVENT_FAILURE, String.format("Exporting '%s' to the Content Store failed.", archiveName), (Throwable)e);
            throw new IRException(IRMessage.CANNOT_EXPORT_REPORT, new Object[]{archiveName});
        }
    }

    private Option[] setDeploymentOptionEnum(String archiveName, String packageFolder) {
        DeploymentOption[] deploymentOptions = null;
        int num = 0;
        deploymentOptions = new DeploymentOption[8];
        deploymentOptions[num] = this.setImportDeploymentOptionPackageInfo(archiveName, packageFolder);
        deploymentOptions[++num] = this.setExportDeploymentOptionPackageInfo(packageFolder);
        deploymentOptions[++num] = this.setDeploymentOptionString(archiveName);
        deploymentOptions[++num] = this.setArchiveOverWrite(true);
        deploymentOptions[++num] = this.setNameSpaceThirdParty(false);
        deploymentOptions[++num] = this.setTakeOwnership(true);
        deploymentOptions[++num] = this.setDeploymentOptionMultilingualString(DEPLOYMENT_OPTION_DEPLOYMENT_NAME, archiveName);
        deploymentOptions[++num] = this.setObjectPolicies(false);
        return deploymentOptions;
    }

    private DeploymentOptionMultilingualString setDeploymentOptionMultilingualString(String name, String value) {
        MultilingualString deploymentName = new MultilingualString();
        deploymentName.setLocale(LOCALE_EN_US);
        deploymentName.setValue(value);
        DeploymentOptionMultilingualString doms = new DeploymentOptionMultilingualString();
        doms.setName(DeploymentOptionEnum.fromString((String)name));
        doms.setValue(new MultilingualString[]{deploymentName});
        return doms;
    }

    private DeploymentOptionImportRuleArray setImportDeploymentOptionPackageInfo(String archiveName, String packageFolder) {
        String[] archiveNames;
        DeploymentImportRule[] pkgDeployInfoArr = new DeploymentImportRule[1];
        String packageName = archiveName;
        for (String name : archiveNames = archiveName.split("_")) {
            if (name.length() < 14) continue;
            packageName = name;
            break;
        }
        MultilingualToken multilingualToken = new MultilingualToken();
        MultilingualToken[] multilingualTokenArr = new MultilingualToken[1];
        DeploymentImportRule pkgDeployInfo = new DeploymentImportRule();
        multilingualToken.setLocale(LOCALE_EN_US);
        multilingualToken.setValue(packageName);
        multilingualTokenArr[0] = multilingualToken;
        SearchPathSingleObject exportSearchPath = new SearchPathSingleObject(packageFolder);
        pkgDeployInfo.setArchiveSearchPath(exportSearchPath);
        pkgDeployInfo.setName(multilingualTokenArr);
        pkgDeployInfo.setParent(new SearchPathSingleObject("/content"));
        pkgDeployInfoArr[0] = pkgDeployInfo;
        DeploymentOptionImportRuleArray deployOptionPkgInfo = new DeploymentOptionImportRuleArray();
        deployOptionPkgInfo.setName(DeploymentOptionEnum.fromString((String)DEPLOYMENT_OPTION_IMPORT));
        deployOptionPkgInfo.setValue(pkgDeployInfoArr);
        return deployOptionPkgInfo;
    }

    private DeploymentOptionSearchPathSingleObjectArray setExportDeploymentOptionPackageInfo(String packageFolder) {
        SearchPathSingleObject exportSearchPath = new SearchPathSingleObject(packageFolder);
        SearchPathSingleObject[] exportPkgDeployInfoArr = new SearchPathSingleObject[]{exportSearchPath};
        DeploymentOptionSearchPathSingleObjectArray exportDeployOptionPkgInfo = new DeploymentOptionSearchPathSingleObjectArray();
        exportDeployOptionPkgInfo.setName(DeploymentOptionEnum.fromString((String)DEPLOYMENT_OPTION_EXPORT));
        exportDeployOptionPkgInfo.setValue(exportPkgDeployInfoArr);
        return exportDeployOptionPkgInfo;
    }

    private DeploymentOptionString setDeploymentOptionString(String archiveName) {
        MultilingualString archiveDefault = new MultilingualString();
        archiveDefault.setLocale(LOCALE_EN_US);
        archiveDefault.setValue(archiveName);
        DeploymentOptionString deployOptionStr = new DeploymentOptionString();
        deployOptionStr.setName(DeploymentOptionEnum.fromString((String)DEPLOYMENT_OPTION_ARCHIVE));
        deployOptionStr.setValue(archiveDefault.getValue());
        return deployOptionStr;
    }

    private DeploymentOptionBoolean setArchiveOverWrite(boolean value) {
        DeploymentOptionBoolean deployOptionBool = new DeploymentOptionBoolean();
        deployOptionBool.setName(DeploymentOptionEnum.fromString((String)DEPLOYMENT_OPTION_ARCHIVE_OVERWRITE));
        deployOptionBool.setValue(value);
        return deployOptionBool;
    }

    private DeploymentOptionBoolean setNameSpaceThirdParty(boolean value) {
        DeploymentOptionBoolean deployOptionBool = new DeploymentOptionBoolean();
        deployOptionBool.setName(DeploymentOptionEnum.fromString((String)DEPLOYMENT_OPTION_NAMESPACE_THIRD_PARTY));
        deployOptionBool.setValue(value);
        return deployOptionBool;
    }

    private DeploymentOptionBoolean setTakeOwnership(boolean value) {
        DeploymentOptionBoolean deployOptionBool = new DeploymentOptionBoolean();
        deployOptionBool.setName(DeploymentOptionEnum.fromString((String)DEPLOYMENT_OPTION_TAKE_OWNERSHIP));
        deployOptionBool.setValue(value);
        return deployOptionBool;
    }

    private DeploymentOptionBoolean setObjectPolicies(boolean value) {
        DeploymentOptionBoolean deployOptionBool = new DeploymentOptionBoolean();
        deployOptionBool.setName(DeploymentOptionEnum.fromString((String)DEPLOYMENT_OPTION_OBJECT_POLICIES));
        deployOptionBool.setValue(value);
        return deployOptionBool;
    }
}

