/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.reportserver.cognos;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.MonitorService_PortType;
import com.cognos.developer.schemas.bibus._3.MonitorService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.MoveOptions;
import com.cognos.developer.schemas.bibus._3.Report;
import com.cognos.developer.schemas.bibus._3.ReportService_PortType;
import com.cognos.developer.schemas.bibus._3.ReportService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.infor.erpln.c4ws.util.C4WSPropertiesManager;
import com.infor.erpln.ir.connector.ConnectorUtil;
import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.reportserver.IReportServer;
import com.infor.erpln.ir.connector.reportserver.cognos.CognosReportServer;
import com.infor.erpln.ir.connector.reportserver.cognos.Export;
import com.infor.erpln.ir.connector.reportserver.cognos.Import;
import com.infor.erpln.ir.connector.reportserver.cognos.InitialFoldersInstallation;
import com.infor.erpln.ir.connector.reportserver.cognos.Render;
import com.infor.erpln.ir.connector.reportserver.cognos.RoleInstallation;
import com.infor.erpln.soap.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.ServiceException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class CognosReportServer
implements IReportServer {
    public static final String ADMIN_FOLDER = "/adminFolder";
    public static final String PUBLIC_FOLDERS_PATH = "/content";
    private static final int UPPER_RANGE = 48;
    private static final int LOWER_RANGE = 55;
    private static final int LENGTH_USERNAME_STRING = 10;
    private static final int SERVICE_TIMEOUT = 0;
    private static final String CANNOT_READ_DEPLOYMENT_PATH = "Cannot read deployment path from configuration file.";
    private static final String DEPLOY_PATH_XPATH_EXPRESSION = "//crn:parameter[@name=\"deploymentPath\"]/crn:value/text()";
    private static final String PACKAGEREPORT_PATH_TEMPLATE = "%s/package[@name='%s']/report[@name='report']";
    private static final String FOLDER_START = "/folder[@name='";
    private static final String FOLDER_END = "']";
    private static final String NOTHING = "nothing";
    private static final String NOWHERE = "nowhere";
    private static final String PARAMETER_TAG = "parameter";
    private static final String CONFIGURATION_FOLDER = "configuration";
    private static final String CONFIGURATION_FILE = "cogstartup.xml";
    private static final String USERPREF_CONTENT_LOCALE = "contentLocale";
    private static final String EN_ZW_LOCALE = "en-zw";
    private static final String BIBUS_NAMESPACE_URI = "http://developer.cognos.com/schemas/bibus/3/";
    private static final String BIBUS_HEADER = "biBusHeader";
    private static Logger logger = ESAPI.getLogger(CognosReportServer.class);
    private static String reportServerDeployPath;
    private ContentManagerService_PortType cmService;
    private ReportService_PortType reportService;
    private MonitorService_PortType mService;
    private static C4WSPropertiesManager propManager;
    private final String reportServerPath;

    @Deprecated
    public CognosReportServer(String endpointUrl, String reportServerPath) throws IRException {
        this.reportServerPath = reportServerPath;
        this.connectToReportServer(endpointUrl);
    }

    public CognosReportServer(String endpointUrl) throws IRException {
        this(endpointUrl, null);
    }

    public boolean logon(String credentials) throws IRException {
        String userId = null;
        boolean succes = false;
        if (credentials != null && !credentials.isEmpty()) {
            int posUserId = credentials.indexOf("<username>") + 10;
            userId = credentials.substring(posUserId, credentials.indexOf("</username>"));
            int posPWId = credentials.indexOf("<password>");
            XmlEncodedXML xmlCredentials = new XmlEncodedXML();
            if (posPWId >= 0) {
                xmlCredentials.set_value(ConnectorUtil.getDecodedWord((String)credentials, (int[])new int[]{48, 55}));
            } else {
                xmlCredentials.set_value(credentials);
            }
            try {
                UserPreferenceVar[] userPreferences;
                this.cmService.logon(xmlCredentials, new SearchPathSingleObject[0]);
                SOAPHeaderElement temp = ((Stub)this.cmService).getResponseHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
                BiBusHeader cmBiBusHeader = (BiBusHeader)temp.getValueAsType(new QName("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader"));
                for (UserPreferenceVar preference : userPreferences = cmBiBusHeader.getUserPreferenceVars()) {
                    if (!"contentLocale".equals(preference.getName())) continue;
                    preference.setValue("en-zw");
                    break;
                }
                ((Stub)this.cmService).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)cmBiBusHeader);
                ((Stub)this.mService).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)cmBiBusHeader);
                succes = true;
            }
            catch (Exception e) {
                succes = false;
                logger.error(Logger.EVENT_FAILURE, String.format("Logon not successful as '%s'.", userId), (Throwable)e);
                throw new IRException(IRMessage.CANNOT_LOGON_REPORT_SERVER, new Object[]{userId});
            }
            if (logger.isInfoEnabled()) {
                logger.info(Logger.EVENT_SUCCESS, String.format("Logon successful as '%s'.", userId));
            }
        } else {
            succes = true;
            logger.info(Logger.EVENT_SUCCESS, "Anonymous logon.");
        }
        return succes;
    }

    public void exportReport(String reportName, String reportFolder, boolean overwrite) throws IRException {
        Export cognosExporter = new Export(this);
        cognosExporter.exportPackage(reportName, reportFolder, overwrite);
    }

    public void connectToReportServer(String endPoint) throws IRException {
        ContentManagerService_ServiceLocator cmServiceLocator = new ContentManagerService_ServiceLocator();
        MonitorService_ServiceLocator mServiceLocator = new MonitorService_ServiceLocator();
        ReportService_ServiceLocator reportServiceLocator = new ReportService_ServiceLocator();
        try {
            this.cmService = cmServiceLocator.getcontentManagerService(new URL(endPoint));
            this.mService = mServiceLocator.getmonitorService(new URL(endPoint));
            this.reportService = reportServiceLocator.getreportService(new URL(endPoint));
            ((Stub)this.cmService).setTimeout(0);
            ((Stub)this.mService).setTimeout(0);
        }
        catch (MalformedURLException e) {
            logger.error(Logger.EVENT_FAILURE, "Malformed endpoint URL.", (Throwable)e);
            throw new IRException(IRMessage.COMMUNICATION_FAILURE_REPORT_SERVER, new Object[0]);
        }
        catch (ServiceException e) {
            logger.error(Logger.EVENT_FAILURE, "Cannot connect to report server.", (Throwable)e);
            throw new IRException(IRMessage.COMMUNICATION_FAILURE_REPORT_SERVER, new Object[0]);
        }
    }

    public void logoff() throws IRException {
        try {
            this.cmService.logoff();
        }
        catch (RemoteException e) {
            logger.error(Logger.EVENT_FAILURE, "Cannot logoff from report server.", (Throwable)e);
            throw new IRException(IRMessage.COMMUNICATION_FAILURE_REPORT_SERVER, new Object[0]);
        }
    }

    public void installRoles() throws IRException {
        RoleInstallation roleInstallation = new RoleInstallation(this.cmService);
        roleInstallation.createLNRoles();
    }

    public void installInitialFolders() throws IRException {
        InitialFoldersInstallation initialFoldersInstallation = new InitialFoldersInstallation(this.cmService);
        initialFoldersInstallation.createLNFolders();
    }

    public ContentManagerService_PortType getContentManagementService() {
        return this.cmService;
    }

    public MonitorService_PortType getMonitorService() {
        return this.getMonitorService(false);
    }

    public ReportService_PortType getReportService() {
        return this.getReportService(false);
    }

    public MonitorService_PortType getMonitorService(boolean isNewConversation) {
        this.updateHeaderOfService((Stub)this.mService, isNewConversation);
        return this.mService;
    }

    public ReportService_PortType getReportService(boolean isNewConversation) {
        this.updateHeaderOfService((Stub)this.reportService, isNewConversation);
        return this.reportService;
    }

    private void updateHeaderOfService(Stub service, boolean isNewConversation) {
        BiBusHeader bibus = CognosReportServer.getHeaderObject((SOAPHeaderElement)service.getResponseHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader"), (boolean)isNewConversation);
        if (bibus == null) {
            BiBusHeader cmBibus = CognosReportServer.getHeaderObject((SOAPHeaderElement)((Stub)this.cmService).getResponseHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader"), (boolean)true);
            service.setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)cmBibus);
        } else {
            service.clearHeaders();
            service.setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)bibus);
        }
    }

    private static BiBusHeader getHeaderObject(SOAPHeaderElement sourceHeader, boolean isNewConversation) {
        BiBusHeader bibus = null;
        if (sourceHeader != null) {
            try {
                bibus = (BiBusHeader)sourceHeader.getValueAsType(new QName("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader"));
                if (isNewConversation) {
                    bibus.setTracking(null);
                    bibus.setRouting(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bibus;
    }

    private String readDeployPathFromConfigurationFile() throws SAXException, ParserConfigurationException, IOException, XPathExpressionException {
        String configFolderPath = this.reportServerPath + "/" + "configuration";
        String configFilePath = configFolderPath + "/" + "cogstartup.xml";
        String deployPath = this.reportServerPath;
        DocumentBuilderFactory factory = XMLUtil.getSecureDocumentBuilderFactory();
        factory.setNamespaceAware(true);
        Document doc = null;
        XPathExpression expr = null;
        DocumentBuilder builder = factory.newDocumentBuilder();
        doc = builder.parse(configFilePath);
        doc.getDocumentElement().getElementsByTagName("parameter");
        XPathFactory xFactory = XPathFactory.newInstance();
        XPath xpath = xFactory.newXPath();
        xpath.setNamespaceContext((NamespaceContext)new CognosConfigNamespaceContext(this, null));
        expr = xpath.compile("//crn:parameter[@name=\"deploymentPath\"]/crn:value/text()");
        String deploymentPath = expr.evaluate(doc);
        File deploymentFolder = new File(deploymentPath);
        if (!deploymentFolder.isAbsolute()) {
            URI configFolderURI = new File(configFolderPath).toURI();
            deployPath = configFolderURI.resolve(deploymentPath).getPath();
        } else {
            deployPath = deploymentFolder.getAbsolutePath();
        }
        return deployPath;
    }

    public void importReport(String reportName, String reportPath) throws IRException {
        this.importReport(reportName, reportPath, null);
    }

    public void importReport(String reportName, String reportPath, String tenantID) throws IRException {
        Import importer = new Import(this);
        if (importer.importPackage(reportName, reportPath, tenantID) == IRMessage.OK) {
            this.moveImportedReport(reportName, reportPath);
        }
    }

    public String getDeploymentFolder() throws IRException {
        if (reportServerDeployPath == null) {
            try {
                reportServerDeployPath = this.readDeployPathFromConfigurationFile();
            }
            catch (Exception e) {
                logger.error(Logger.EVENT_FAILURE, "Cannot read deployment path from configuration file.", (Throwable)e);
                throw new IRException(IRMessage.CANNOT_READ_DEPLOYMENT_PATH, new Object[0]);
            }
        }
        return reportServerDeployPath;
    }

    public byte[] renderReport(Datafile dataFileName, String reportName, String format) throws IRException {
        Render cognosRenderer = new Render(this, dataFileName, reportName, format);
        return cognosRenderer.executeReport();
    }

    private void moveImportedReport(String reportName, String reportPath) throws IRException {
        String folderName = this.getLastFolderSearch(reportPath);
        if (folderName.equals(reportName)) {
            String orgPath = String.format("%s/package[@name='%s']/report[@name='report']", reportPath, reportName);
            this.moveReport(orgPath, reportPath);
        }
    }

    private String getLastFolderSearch(String reportPath) {
        String find = "/folder[@name='";
        int pos1 = reportPath.lastIndexOf("/folder[@name='");
        int pos2 = reportPath.lastIndexOf("']");
        String lastFolderName = reportPath.substring(pos1 + "/folder[@name='".length(), pos2);
        return lastFolderName;
    }

    private String moveReport(String orgPath, String destPath) throws IRException {
        StringProp orgSearchPath = new StringProp();
        orgSearchPath.setValue(orgPath);
        Report destReport = new Report();
        destReport.setSearchPath(orgSearchPath);
        BaseClass[] bcMove = new BaseClass[]{destReport};
        SearchPathSingleObject destSearchPath = new SearchPathSingleObject();
        destSearchPath.set_value(destPath);
        String results = this.doMoveBC(bcMove, destSearchPath);
        return results;
    }

    private String doMoveBC(BaseClass[] bcMove, SearchPathSingleObject moveTargetSearchPath) throws IRException {
        String moveResults = null;
        String dest = "";
        String org = "";
        org = bcMove == null ? "nothing" : bcMove.getClass().getName();
        dest = moveTargetSearchPath == null ? "nowhere" : moveTargetSearchPath.get_value();
        if (bcMove == null || moveTargetSearchPath == null) {
            throw new IRException(IRMessage.CANNOT_MOVE_BC, new Object[]{org, dest});
        }
        MoveOptions moveOptions = new MoveOptions();
        moveOptions.setUpdateAction(UpdateActionEnum.replace);
        try {
            BaseClass[] bcMoveResults = this.cmService.move(bcMove, moveTargetSearchPath, moveOptions);
            if (bcMoveResults == null || bcMoveResults.length <= 0) {
                throw new IRException(IRMessage.CANNOT_MOVE_BC, new Object[]{org, dest});
            }
            moveResults = bcMoveResults[0].getStoreID().getValue().get_value();
        }
        catch (RemoteException e) {
            logger.error(Logger.EVENT_FAILURE, "Report Server could not move a BaseClass object", (Throwable)e);
            throw new IRException(IRMessage.CANNOT_MOVE_BC, new Object[]{org, dest});
        }
        return moveResults;
    }

    public static C4WSPropertiesManager getPropManager() {
        return propManager;
    }

    public static void setPropManager(C4WSPropertiesManager propManager) {
        CognosReportServer.propManager = propManager;
    }
}

