/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.images;

import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.images.AbstractImageDescriptor;
import com.infor.erpln.ir.connector.images.SensitivityLabel;
import com.infor.erpln.jca.dllclient.BaanDLLCall;
import com.infor.erpln.jca.dllclient.BaanDLLCallException;
import com.infor.erpln.jca.dllclient.Parameter;
import com.infor.erpln.soap.XMLUtil;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.resource.cci.Connection;
import javax.swing.JLabel;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SensitivityImage
extends AbstractImageDescriptor {
    private static final String FILENAME_PREFIX = "1_";
    private static final String METHOD_NAME = "GetSensitivityLevels";
    private static final String LIBRARY_NAME = "ottrpidllutil";
    private final int height;
    private final int width;
    private BufferedImage image;
    private final Map<String, SensitivityLabel> sensitivityLabels;

    public SensitivityImage(Datafile dataFile, Map<String, SensitivityLabel> sl, int height, int width) {
        super(dataFile);
        this.sensitivityLabels = sl;
        this.height = height;
        this.width = width;
        this.setImageFileName(FILENAME_PREFIX + String.valueOf(height) + "_" + String.valueOf(width));
    }

    public String executeDllCall() throws BaanDLLCallException, IOException, IRException {
        String sensitivityLevel;
        SensitivityLabel sl;
        if (this.sensitivityLabels.size() == 0) {
            BaanDLLCall call = new BaanDLLCall();
            call.attachConnection((Connection)this.connection);
            call.setDLL(LIBRARY_NAME);
            call.setFunction(METHOD_NAME);
            Parameter sensitivityLevelsParameter = new Parameter("sensitivityLevels", "out");
            sensitivityLevelsParameter.setType("xmlstring");
            call.setParameters(new Parameter[]{sensitivityLevelsParameter});
            call.execute();
            this.createSensitivityLevels(sensitivityLevelsParameter.getXMLValueAsString());
        }
        if (null == (sl = (SensitivityLabel)this.sensitivityLabels.get(sensitivityLevel = this.getPropertyValue("SensitivityLevel")))) {
            throw new IRException(IRMessage.UNKNOWN_SENSITIVITY_LEVEL, new Object[]{sensitivityLevel});
        }
        return "<html><h3 style=\"background-color:" + sl.getBackgroundColor() + ";color:" + sl.getForegroundColor() + "\">" + sl.getDescription() + "</h3></html>";
    }

    public String storeImage(String dataFolderPath, String baseURL) throws IOException, BaanDLLCallException, IRException {
        this.constructImage(this.executeDllCall());
        String applicationPath = this.getApplicationPath();
        String filePath = "image/" + applicationPath + this.getImageFileName() + ".gif";
        File tempFile = File.createTempFile("ir_", ".gif");
        ImageIO.write((RenderedImage)this.image, "gif", tempFile);
        this.writeImageFile(dataFolderPath, filePath, tempFile);
        tempFile.delete();
        return this.getURL(baseURL, filePath);
    }

    private void createSensitivityLevels(String levels) throws IOException, IRException {
        try {
            Element node = XMLUtil.getSecureDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(levels.getBytes())).getDocumentElement();
            NodeList nList = node.getElementsByTagName("LEVEL");
            for (int levelElement = 0; levelElement < nList.getLength(); ++levelElement) {
                Node nNode = nList.item(levelElement);
                String code = nNode.getAttributes().getNamedItem("CODE").getNodeValue();
                String label = nNode.getAttributes().getNamedItem("LABEL").getNodeValue();
                String bgColor = nNode.getAttributes().getNamedItem("BACKGROUND_COLOR").getNodeValue();
                String fgColor = nNode.getAttributes().getNamedItem("FOREGROUND_COLOR").getNodeValue();
                this.sensitivityLabels.put(code, new SensitivityLabel(label, bgColor, fgColor));
            }
        }
        catch (ParserConfigurationException e) {
            throw new IRException(IRMessage.FAULT, new Object[]{e.getMessage()});
        }
        catch (SAXException e) {
            throw new IRException(IRMessage.FAULT, new Object[]{e.getMessage()});
        }
    }

    private void constructImage(String html) {
        JLabel label = new JLabel(html, 0);
        label.setSize(this.width, this.height);
        this.image = new BufferedImage(label.getWidth(), label.getHeight(), 1);
        Graphics g = this.image.getGraphics();
        label.paint(g);
        g.dispose();
    }
}

