/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.images;

import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.images.AbstractImageDescriptor;
import com.infor.erpln.jca.dllclient.BaanDLLCallException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class PDFPageImage
extends AbstractImageDescriptor {
    private final BufferedImage image;

    public PDFPageImage(Datafile dataFile, BufferedImage image, String suffix) {
        super(dataFile);
        this.image = image;
        this.setImageFileName(dataFile.getName() + "_" + suffix);
    }

    public String executeDllCall() throws BaanDLLCallException, IOException, IRException {
        return "";
    }

    public String storeImage(String dataFolderPath, String baseURL) throws IOException, BaanDLLCallException, IRException {
        String applicationPath = this.getApplicationPath();
        String filePath = "image/" + applicationPath + this.getImageFileName() + ".png";
        File tempFile = File.createTempFile("ir_", ".png");
        ImageIO.write((RenderedImage)this.image, "png", tempFile);
        this.image.flush();
        this.writeImageFile(dataFolderPath, filePath, tempFile);
        tempFile.delete();
        return this.getURL(baseURL, filePath);
    }
}

