/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.images;

import com.infor.erpln.ir.connector.caching.RetentionMap;
import com.infor.erpln.ir.connector.images.CachedImage;
import com.infor.erpln.ir.connector.images.SensitivityLabel;
import java.util.HashMap;
import java.util.Map;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class ImageCacheEntry {
    private static Logger logger = ESAPI.getLogger(ImageCacheEntry.class);
    private final RetentionMap<String, CachedImage> imageCache = new RetentionMap();
    private final Map<String, SensitivityLabel> sensitivyLabels = new HashMap();

    public Map<String, SensitivityLabel> getSensitivyLabels() {
        return this.sensitivyLabels;
    }

    public String getImage(String fileName) {
        CachedImage ci = (CachedImage)this.imageCache.get((Object)fileName);
        return ci != null ? ci.getImageURL() : null;
    }

    public void putImage(String fileName, String url, String imageFullPath) {
        this.imageCache.put((Object)fileName, (Object)new CachedImage(fileName, url, imageFullPath));
        if (logger.isInfoEnabled()) {
            logger.info(Logger.EVENT_SUCCESS, String.format("Image '%s' stored in the image cache.", url));
        }
    }

    public CachedImage[] getAllImages() {
        return this.imageCache.values().toArray(new CachedImage[this.imageCache.size()]);
    }

    public void removeImage(String fileName) {
        this.imageCache.remove((Object)fileName);
        if (logger.isInfoEnabled()) {
            logger.info(Logger.EVENT_SUCCESS, String.format("Image file '%s' removed from cache.", fileName));
        }
    }
}

