/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.images;

import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.images.AbstractImageDescriptor;
import com.infor.erpln.jca.dllclient.BaanDLLCall;
import com.infor.erpln.jca.dllclient.BaanDLLCallException;
import com.infor.erpln.jca.dllclient.Parameter;
import javax.resource.cci.Connection;

public class EnumFile
extends AbstractImageDescriptor {
    private static final String METHOD_NAME = "GetEnumIcon";
    private static final String FILENAME_PREFIX = "3";
    private final String enumDomain;
    private final int enumValue;

    public EnumFile(Datafile dataFile, String domain, int value) {
        super(dataFile);
        this.enumDomain = domain;
        this.enumValue = value;
        this.setImageFileName(FILENAME_PREFIX + "_" + domain + "_" + value);
    }

    public String executeDllCall() throws BaanDLLCallException {
        BaanDLLCall call = new BaanDLLCall();
        call.attachConnection((Connection)this.connection);
        call.setDLL("ottrpidllimage");
        call.setFunction(METHOD_NAME);
        Parameter enumDomainParameter = new Parameter("domain", "in");
        enumDomainParameter.setType("string");
        enumDomainParameter.setValue(this.enumDomain);
        Parameter enumValueParameter = new Parameter("value", "in");
        enumValueParameter.setType("i8");
        enumValueParameter.setValue(Long.valueOf(this.enumValue).longValue());
        call.setParameters(new Parameter[]{enumDomainParameter, enumValueParameter});
        call.execute();
        return call.getReturnStringValue();
    }
}

