/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.images;

import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.images.AbstractImageDescriptor;
import com.infor.erpln.jca.dllclient.BaanDLLCall;
import com.infor.erpln.jca.dllclient.BaanDLLCallException;
import com.infor.erpln.jca.dllclient.Parameter;
import javax.resource.cci.Connection;

public class CompanyLogo
extends AbstractImageDescriptor {
    private static final String METHOD_NAME_FALLBACK = "GetCompanyLogo";
    private static final String METHOD_NAME = "GetCompanyLogoForComp";
    private static final String FILENAME_PREFIX = "0";
    private static final String FILENAME = "CompanyLogo";

    public CompanyLogo(Datafile dataFile) {
        super(dataFile);
        String compnr = (String)dataFile.getPropertyCache().getProperties().properties.get("CompanyNumber");
        if (compnr == null || compnr.isEmpty()) {
            compnr = "000";
        }
        this.setImageFileName(FILENAME_PREFIX + "_" + compnr + "_" + FILENAME);
    }

    public String executeDllCall() throws BaanDLLCallException, IRException {
        try {
            BaanDLLCall call = new BaanDLLCall();
            call.attachConnection((Connection)this.connection);
            call.setDLL("ottrpidllimage");
            call.setFunction(METHOD_NAME);
            Parameter companyParameter = new Parameter("company", "in");
            companyParameter.setType("i8");
            companyParameter.setValue(Long.valueOf(this.getPropertyValue("CompanyNumber")).longValue());
            call.setParameters(new Parameter[]{companyParameter});
            call.execute();
            return call.getReturnStringValue();
        }
        catch (Exception e) {
            BaanDLLCall call = new BaanDLLCall();
            call.attachConnection((Connection)this.connection);
            call.setDLL("ottrpidllimage");
            call.setFunction(METHOD_NAME_FALLBACK);
            call.execute();
            return call.getReturnStringValue();
        }
    }
}

