/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.images;

import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.ResultMessage;
import com.java4less.qrcode.ImageEncoder;
import com.java4less.qrcode.QRCode;
import com.java4less.raztec.AztecCode;
import com.java4less.rbarcode.BarCode;
import com.java4less.rbarcode.BarCode2D;
import com.java4less.rbarcode.BarCodeEncoder;
import com.java4less.rdatamatrix.RDataMatrix;
import java.awt.Component;
import java.awt.Font;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class BarcodeImageFactory {
    public static final int QRCODE = 500;
    public static final int AZTECCODE = 600;
    private static final List<String> GENERAL_PARAMETERS = Arrays.asList("width".toUpperCase(), "height".toUpperCase(), "barType".toUpperCase(), "fileType".toUpperCase(), "fontSize".toUpperCase(), "fontFamily".toUpperCase(), "fit".toUpperCase(), "topMargin".toUpperCase(), "leftMargin".toUpperCase());
    private static final String TRUE_VALUE = "true";
    private static final String BARCODE_1D_CLASS = "com.java4less.rbarcode.BarCode";
    private static final String BARCODE_PDF_CLASS = "com.java4less.rbarcode.BarCode2D";
    private static final String BARCODE_QRCODE_CLASS = "com.java4less.qrcode.QRCode";
    private static final String BARCODE_AZTECCODE_CLASS = "com.java4less.raztec.AztecCode";
    private static final String BARCODE_DATAMATRIX_CLASS = "com.java4less.rdatamatrix.RDataMatrix";
    private static Logger logger = ESAPI.getLogger(BarcodeImageFactory.class);
    private final int barType;
    private final String value;
    private final Map<String, String> parameters;
    private final String targetFile;
    private final String fileType;

    public BarcodeImageFactory(int barType, String value, Map<String, String> parameters, String targetFile, String fileType) {
        this.barType = barType;
        this.value = value;
        this.parameters = parameters;
        this.targetFile = targetFile;
        this.fileType = fileType;
    }

    public void createBarcode() throws IRException {
        try {
            switch (this.barType) {
                case 30: {
                    this.createBarcode2D();
                    break;
                }
                case 500: {
                    this.createQRCode();
                    break;
                }
                case 600: {
                    this.createAztecCode();
                    break;
                }
                case 31: {
                    this.createDataMatrix();
                    break;
                }
                default: {
                    this.createBarcode1D();
                    break;
                }
            }
        }
        catch (InstantiationException e) {
            ResultMessage resultMessage = new ResultMessage(IRMessage.CANNOT_INSTANTIATE_CLASS, new Object[0]);
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)e);
            throw new IRException(IRMessage.CANNOT_INSTANTIATE_CLASS, new Object[0]);
        }
        catch (IllegalAccessException e) {
            ResultMessage resultMessage = new ResultMessage(IRMessage.ILLEGAL_ACCESS_FOR_CLASS, new Object[0]);
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)e);
            throw new IRException(IRMessage.ILLEGAL_ACCESS_FOR_CLASS, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            ResultMessage resultMessage = new ResultMessage(IRMessage.CLASS_NOT_FOUND, new Object[0]);
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)e);
            throw new IRException(IRMessage.CLASS_NOT_FOUND, new Object[0]);
        }
    }

    private void createBarcode1D() throws IRException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> c = Class.forName("com.java4less.rbarcode.BarCode");
        BarCode barCode = (BarCode)c.newInstance();
        int width = Integer.parseInt((String)this.parameters.get("width"));
        int height = Integer.parseInt((String)this.parameters.get("height"));
        barCode.setSize(width, height);
        barCode.barType = this.barType;
        barCode.code = this.value;
        barCode.codeText = this.value;
        if (this.parameters.containsKey("fontSize")) {
            try {
                barCode.textFont = barCode.textFont.deriveFont(Float.parseFloat((String)this.parameters.get("fontSize")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (barCode.textFont.getSize() == 0) {
            barCode.fontColor = barCode.backColor;
        }
        if (this.parameters.containsKey("fontFamily")) {
            barCode.textFont = new Font((String)this.parameters.get("fontFamily"), barCode.textFont.getStyle(), barCode.textFont.getSize());
        }
        if (this.parameters.containsKey("topMargin")) {
            barCode.topMarginCM = Double.parseDouble((String)this.parameters.get("topMargin"));
        }
        if (this.parameters.containsKey("leftMargin")) {
            barCode.leftMarginCM = Double.parseDouble((String)this.parameters.get("leftMargin"));
        }
        this.createBarcode((Object)barCode, c);
        if (!(this.barType != 0 && this.barType != 1 && this.barType != 2 || this.parameters.containsKey("checkCharacter"))) {
            barCode.checkCharacter = false;
        }
        if ("true".equals(this.parameters.get("fit"))) {
            this.fitBarcode1D(barCode, width, height);
        }
        if (!new BarCodeEncoder((BarCode)barCode, (String)this.fileType, (String)this.targetFile).result) {
            throw new IRException(IRMessage.CANNOT_CREATE_BARCODE_FILE, new Object[]{this.targetFile});
        }
    }

    private void fitBarcode1D(BarCode barCode, int width, int height) {
        int xModules = 0;
        double yModules = 0.0;
        switch (this.barType) {
            case 0: 
            case 1: {
                int i;
                xModules = 25;
                yModules = 25.0;
                for (i = 0; i < barCode.code.length(); ++i) {
                    if ("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. ".contains(barCode.code.subSequence(i, i + 1))) {
                        xModules += 13;
                        yModules += 13.0;
                        continue;
                    }
                    xModules += 26;
                    yModules += 26.0;
                }
                if (!barCode.checkCharacter) break;
                xModules += 13;
                yModules += 13.0;
                break;
            }
            case 9: 
            case 14: {
                int i;
                xModules = 19;
                yModules = 19.0;
                for (i = 0; i < barCode.code.length(); ++i) {
                    if ("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-.$/+% ".contains(barCode.code.subSequence(i, i + 1))) {
                        xModules += 9;
                        yModules += 10.0;
                        continue;
                    }
                    xModules += 18;
                    yModules += 20.0;
                }
                if (!barCode.checkCharacter) break;
                xModules += 18;
                yModules += 10.0;
                break;
            }
            case 3: {
                int i;
                xModules = 15;
                yModules = 21.0;
                for (i = 0; i < barCode.code.length(); ++i) {
                    xModules = "12345678".contains(barCode.code.subSequence(i, i + 1)) ? (xModules += 8) : (xModules += 7);
                    yModules += 7.0;
                }
                if (barCode.checkCharacter) {
                    xModules = this.value.length() > 10 ? (xModules += 16) : (xModules += 16);
                    yModules += 7.0;
                    break;
                }
                if (this.value.length() <= 10) break;
                yModules += 7.0;
                break;
            }
            case 4: {
                int i;
                xModules = 21;
                yModules = 20.0;
                for (i = 0; i < barCode.code.length(); ++i) {
                    xModules = "0123456789-$".contains(barCode.code.subSequence(i, i + 1)) ? (xModules += 10) : (xModules += 11);
                    yModules += 10.0;
                }
                if (!barCode.checkCharacter) break;
                xModules += 10;
                yModules += 10.0;
                break;
            }
            case 13: 
            case 16: {
                int barCodeCharacters = 0;
                int charSet = 66;
                String barText = this.value;
                while (!barText.isEmpty()) {
                    int numOfDigits = 0;
                    for (int i = 0; i < barText.length() && Character.isDigit(barText.charAt(i)); ++i) {
                        ++numOfDigits;
                    }
                    if (numOfDigits % 2 == 1) {
                        --numOfDigits;
                    }
                    if (numOfDigits < 4) {
                        if (charSet != 66) {
                            charSet = 66;
                            ++barCodeCharacters;
                        }
                        barText = barText.substring(1);
                        ++barCodeCharacters;
                        continue;
                    }
                    if (charSet != 67) {
                        charSet = 67;
                        ++barCodeCharacters;
                    }
                    barText = barText.substring(numOfDigits);
                    barCodeCharacters += numOfDigits / 2;
                }
                xModules = 11 + barCodeCharacters * 11 + 13;
                yModules = (double)this.value.length() * 5.5 + 35.0;
                if (!barCode.checkCharacter) break;
                xModules += 11;
                yModules += 5.5;
                break;
            }
            case 10: {
                xModules = 95;
                yModules = 102.0;
                break;
            }
            case 11: {
                xModules = 67;
                yModules = 67.0;
                break;
            }
            case 2: {
                xModules = 8;
                yModules = 7.0;
                if (barCode.code.length() % 2 == 0) {
                    if (barCode.checkCharacter) {
                        xModules += 7 * (barCode.code.length() + 2);
                        yModules += 3.5 * (double)(barCode.code.length() + 2);
                        break;
                    }
                    xModules += 7 * barCode.code.length();
                    yModules += 3.5 * (double)barCode.code.length();
                    break;
                }
                xModules += 7 * (barCode.code.length() + 1);
                yModules += 3.5 * (double)(barCode.code.length() + 1);
                break;
            }
            case 15: {
                break;
            }
            case 6: {
                xModules = 95;
                if (barCode.checkCharacter) {
                    yModules = 102.0;
                    break;
                }
                yModules = 95.0;
                break;
            }
            case 12: {
                xModules = 51;
                if (barCode.checkCharacter) {
                    yModules = 102.0;
                    break;
                }
                yModules = 95.0;
                break;
            }
            default: {
                return;
            }
        }
        double desiredWidthCM = (double)width / (double)barCode.resolution - barCode.leftMarginCM * 2.0;
        double textHeightCM = 1.5 * (double)barCode.textFont.getSize() / (double)barCode.resolution;
        double desiredHeightCM = (double)height / (double)barCode.resolution - barCode.topMarginCM * 2.0 - textHeightCM;
        if (!this.parameters.containsKey("X")) {
            barCode.X = desiredWidthCM / (double)xModules;
        }
        if (!this.parameters.containsKey("H")) {
            barCode.H = desiredHeightCM / (barCode.X * yModules);
        }
    }

    private void createBarcode2D() throws InstantiationException, IllegalAccessException, IRException, ClassNotFoundException {
        Class<?> c = Class.forName("com.java4less.rbarcode.BarCode2D");
        BarCode2D bc2d = (BarCode2D)c.newInstance();
        bc2d.setSize(Integer.parseInt((String)this.parameters.get("width")), Integer.parseInt((String)this.parameters.get("height")));
        bc2d.barType = this.barType;
        bc2d.code = this.value;
        this.createBarcode((Object)bc2d, c);
        if (!new BarCodeEncoder((BarCode)bc2d, (String)this.fileType, (String)this.targetFile).result) {
            throw new IRException(IRMessage.CANNOT_CREATE_BARCODE_FILE, new Object[]{this.targetFile});
        }
    }

    private void createQRCode() throws InstantiationException, IllegalAccessException, IRException, ClassNotFoundException {
        Class<?> c = Class.forName("com.java4less.qrcode.QRCode");
        QRCode qrCode = (QRCode)c.newInstance();
        qrCode.setSize(Integer.parseInt((String)this.parameters.get("width")), Integer.parseInt((String)this.parameters.get("height")));
        qrCode.setCode(this.value);
        this.createBarcode((Object)qrCode, c);
        if (!new ImageEncoder((QRCode)qrCode, (String)this.fileType, (String)this.targetFile).result) {
            throw new IRException(IRMessage.CANNOT_CREATE_BARCODE_FILE, new Object[]{this.targetFile});
        }
    }

    private void createAztecCode() throws IRException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> c = Class.forName("com.java4less.raztec.AztecCode");
        AztecCode azCode = (AztecCode)c.newInstance();
        azCode.setSize(Integer.parseInt((String)this.parameters.get("width")), Integer.parseInt((String)this.parameters.get("height")));
        azCode.setCode(this.value);
        this.createBarcode((Object)azCode, c);
        if (!new com.java4less.encoder.ImageEncoder((Component)azCode, (String)this.fileType, (String)this.targetFile).result) {
            throw new IRException(IRMessage.CANNOT_CREATE_BARCODE_FILE, new Object[]{this.targetFile});
        }
    }

    private void createDataMatrix() throws IRException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> c = Class.forName("com.java4less.rdatamatrix.RDataMatrix");
        RDataMatrix dmCode = (RDataMatrix)c.newInstance();
        dmCode.setSize(Integer.parseInt((String)this.parameters.get("width")), Integer.parseInt((String)this.parameters.get("height")));
        dmCode.code = this.value;
        this.createBarcode((Object)dmCode, c);
        if (!new com.java4less.encoder.ImageEncoder((Component)dmCode, (String)this.fileType, (String)this.targetFile).result) {
            throw new IRException(IRMessage.CANNOT_CREATE_BARCODE_FILE, new Object[]{this.targetFile});
        }
    }

    private void createBarcode(Object barcode, Class<?> c) throws IRException {
        for (Map.Entry entry : this.parameters.entrySet()) {
            if (GENERAL_PARAMETERS.contains(((String)entry.getKey()).toUpperCase()) || this.setMethod(c, barcode, (String)entry.getKey(), (String)entry.getValue())) continue;
            BarcodeImageFactory.setField(c, (Object)barcode, (String)((String)entry.getKey()), (String)((String)entry.getValue()));
        }
    }

    private boolean setMethod(Class<?> c, Object barcode, String parName, String parValue) throws IRException {
        boolean methodFound = false;
        try {
            String methodName = "set" + parName;
            Method mt = this.searchForMethod(c, methodName);
            if (null != mt) {
                Class<?> clType = mt.getParameterTypes()[0];
                if (clType == Integer.TYPE) {
                    mt.invoke(barcode, Integer.parseInt(parValue));
                    methodFound = true;
                } else if (clType == String.class) {
                    mt.invoke(barcode, parValue);
                    methodFound = true;
                } else if (clType == Byte.TYPE) {
                    mt.invoke(barcode, (byte)Integer.parseInt(parValue));
                    methodFound = true;
                } else if (clType == Boolean.TYPE) {
                    mt.invoke(barcode, parValue.equalsIgnoreCase("true"));
                    methodFound = true;
                } else if (clType == Double.TYPE) {
                    mt.invoke(barcode, Double.parseDouble(parValue));
                    methodFound = true;
                }
            }
        }
        catch (Exception e) {
            throw new IRException(IRMessage.CANNOT_INVOKE_METHOD, new Object[]{parName, barcode.toString()});
        }
        return methodFound;
    }

    private Method searchForMethod(Class<?> c, String name) {
        Method method = null;
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] types;
            if (!methods[i].getName().equalsIgnoreCase(name) || (types = methods[i].getParameterTypes()).length != 1) continue;
            method = methods[i];
            break;
        }
        return method;
    }

    private static boolean setField(Class<?> c, Object barcode, String parName, String parValue) throws IRException {
        boolean fieldFound = false;
        try {
            Field fld = BarcodeImageFactory.searchForField(c, (String)parName);
            Class<?> flType = fld.getType();
            if (flType == Integer.TYPE) {
                fld.setInt(barcode, Integer.parseInt(parValue));
                fieldFound = true;
            } else if (flType == String.class) {
                fld.set(barcode, parValue);
                fieldFound = true;
            } else if (flType == Byte.TYPE) {
                fld.setByte(barcode, (byte)Integer.parseInt(parValue));
                fieldFound = true;
            } else if (flType == Boolean.TYPE) {
                fld.setBoolean(barcode, parValue.equalsIgnoreCase("true"));
                fieldFound = true;
            } else if (flType == Double.TYPE) {
                fld.setDouble(barcode, Double.parseDouble(parValue));
                fieldFound = true;
            }
        }
        catch (Exception e) {
            throw new IRException(IRMessage.CANNOT_SET_FIELD, new Object[]{parName, barcode.toString()});
        }
        return fieldFound;
    }

    private static Field searchForField(Class<?> c, String name) {
        Field field = null;
        Field[] fields = c.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equalsIgnoreCase(name)) continue;
            field = fields[i];
            break;
        }
        return field;
    }
}

