/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.images;

import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.images.AbstractImageDescriptor;
import com.infor.erpln.ir.connector.images.BarcodeImageFactory;
import com.infor.erpln.jca.dllclient.BaanDLLCallException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class BarcodeImage
extends AbstractImageDescriptor {
    private static final String FILENAME_PREFIX = "5";
    public static final String BARTYPE = "barType";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String FILETYPE = "fileType";
    public static final String FONTSIZE = "fontSize";
    public static final String FONTFAMILY = "fontFamily";
    public static final String FIT = "fit";
    public static final String TOPMARGIN = "topMargin";
    public static final String LEFTMARGIN = "leftMargin";
    private static final String JPG = "jpg";
    private static final String PNG = "png";
    private static final String DEFAULT_FILETYPE = "png";
    private static final Map<String, Integer> TYPES = new /* Unavailable Anonymous Inner Class!! */;
    private final String value;
    private final Map<String, String> parameters = new HashMap();

    public BarcodeImage(Datafile dataFile, String value, String parameters) {
        super(dataFile);
        this.value = value;
        this.setParameterMap(parameters);
        String hashedFilename = BarcodeImage.constructHashCode((String)(this.value + parameters));
        this.setImageFileName("5" + "_" + hashedFilename);
    }

    public String executeDllCall() throws BaanDLLCallException, IOException, IRException {
        return "";
    }

    public String storeImage(String dataFolderPath, String baseURL) throws IOException, BaanDLLCallException, IRException {
        String fileType = this.getParameterValue("fileType");
        this.validateParameters();
        if (StringUtils.isEmpty((String)fileType)) {
            fileType = "png";
        }
        if (!fileType.equalsIgnoreCase("jpg") && !fileType.equalsIgnoreCase("png")) {
            throw new IRException(IRMessage.NOT_SUPPORTED_FILETYPE, new Object[]{fileType});
        }
        String applicationPath = this.getApplicationPath();
        String filePath = "image/" + applicationPath + this.getImageFileName() + "." + fileType;
        File tempFile = File.createTempFile("ir_", "." + fileType);
        try {
            BarcodeImageFactory bif = new BarcodeImageFactory(((Integer)TYPES.get(this.getParameterValue("barType"))).intValue(), this.value, this.parameters, tempFile.getAbsolutePath(), fileType);
            bif.createBarcode();
        }
        catch (NullPointerException ex) {
            throw new IRException(IRMessage.NOT_SUPPORTED_BARCODE, new Object[]{this.getParameterValue("barType")});
        }
        this.writeImageFile(dataFolderPath, filePath, tempFile);
        tempFile.delete();
        return this.getURL(baseURL, filePath);
    }

    private void validateParameters() throws IRException {
        if (!this.parameters.containsKey("height") || Integer.parseInt((String)this.parameters.get("height")) == 0) {
            throw new IRException(IRMessage.MISSING_MANDATORY_PARAMETER, new Object[]{"height"});
        }
        if (!this.parameters.containsKey("width") || Integer.parseInt((String)this.parameters.get("width")) == 0) {
            throw new IRException(IRMessage.MISSING_MANDATORY_PARAMETER, new Object[]{"width"});
        }
    }

    private void setParameterMap(String parameters) {
        String pairDelim = "[;]";
        String keyValueDelim = "[=]";
        String[] tokens = parameters.split("[;]");
        for (int i = 0; i < tokens.length; ++i) {
            String key = tokens[i];
            String[] keyValuePair = key.split("[=]");
            this.parameters.put(keyValuePair[0].trim(), keyValuePair[1].trim());
        }
    }

    private String getParameterValue(String key) {
        String param = (String)this.parameters.get(key);
        return param != null ? param : "";
    }
}

