/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.images;

import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.images.AbstractImageDescriptor;
import com.infor.erpln.jca.dllclient.BaanDLLCall;
import com.infor.erpln.jca.dllclient.BaanDLLCallException;
import com.infor.erpln.jca.dllclient.Parameter;
import javax.resource.cci.Connection;

public class AdditionalFile
extends AbstractImageDescriptor {
    private static final String METHOD_NAME = "GetImage";
    private static final String FILENAME_PREFIX = "4";
    private final String packageCode;
    private final String moduleCode;
    private final String additionalFile;

    public AdditionalFile(Datafile dataFile, String packageCode, String moduleCode, String additionalFile) {
        super(dataFile);
        this.packageCode = packageCode;
        this.moduleCode = moduleCode;
        this.additionalFile = additionalFile;
        this.setImageFileName(FILENAME_PREFIX + "_" + packageCode + "_" + moduleCode + "_" + additionalFile);
    }

    public String executeDllCall() throws BaanDLLCallException {
        BaanDLLCall call = new BaanDLLCall();
        call.attachConnection((Connection)this.connection);
        call.setDLL("ottrpidllimage");
        call.setFunction(METHOD_NAME);
        Parameter packageParameter = new Parameter("package", "in");
        packageParameter.setType("string");
        packageParameter.setValue(this.packageCode);
        Parameter moduleParameter = new Parameter("module", "in");
        moduleParameter.setType("string");
        moduleParameter.setValue(this.moduleCode);
        Parameter additionalFileParameter = new Parameter("additionalFile", "in");
        additionalFileParameter.setType("string");
        additionalFileParameter.setValue(this.additionalFile);
        call.setParameters(new Parameter[]{packageParameter, moduleParameter, additionalFileParameter});
        call.execute();
        return call.getReturnStringValue();
    }
}

