/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.images;

import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.connection.AbstractCustomFunctions;
import com.infor.erpln.ir.connector.images.IImageDescriptor;
import com.infor.erpln.jca.dllclient.BaanDLLCallException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractImageDescriptor
extends AbstractCustomFunctions
implements IImageDescriptor {
    public static final String ERROR_GIF = "error.gif";
    public static final String EMPTY_GIF = "empty.gif";
    protected static final String IMAGE_PATH = "image/";
    private static Map<String, String> illegalCharacterMap = new HashMap();
    private String imageFileName;

    public AbstractImageDescriptor(Datafile dataFile) {
        super(dataFile);
    }

    public String storeImage(String dataFolderPath, String baseURL) throws IOException, BaanDLLCallException, IRException {
        String value = this.executeDllCall();
        if (value != null && !value.isEmpty()) {
            Base64 decoder = new Base64();
            byte[] imgBytes = decoder.decode(value);
            String applicationPath = this.getApplicationPath();
            String filePath = "image/" + applicationPath + this.imageFileName + ".gif";
            this.writeImageFile(dataFolderPath, filePath, imgBytes);
            return this.getURL(baseURL, filePath);
        }
        return this.getErrorImageURL();
    }

    protected void writeImageFile(String dataFolderPath, String filePath, byte[] contents) throws IRException, IOException {
        String outputFileName = dataFolderPath + "/" + filePath;
        this.ensureParentExists(outputFileName);
        try (FileOutputStream osf = new FileOutputStream(new File(outputFileName));){
            osf.write(contents);
            osf.flush();
        }
    }

    protected void writeImageFile(String dataFolderPath, String filePath, File tempFile) throws IOException, IRException {
        String outputFileName = dataFolderPath + "/" + filePath;
        FileUtils.copyFile((File)tempFile, (File)new File(outputFileName));
    }

    protected String getURL(String baseURL, String filePath) {
        return baseURL + this.escapePath(filePath);
    }

    protected void ensureParentExists(String filePath) throws IRException {
        File file = new File(filePath);
        File parent = file.getParentFile();
        if (parent == null || !parent.exists() && !parent.mkdirs()) {
            throw new IRException(IRMessage.CREATE_FOLDER_EXCEPTION, new Object[]{file});
        }
    }

    public String getApplicationPath() throws IRException {
        String bse = this.getPropertyValue("BSEConverted");
        String packageCombination = this.getPropertyValue("PackageCombination");
        String hostName = this.getPropertyValue("HostName");
        String tenantID = this.dataFile.getTenantID();
        if (tenantID == null) {
            tenantID = "";
        }
        String digestedTenantHostBSE = DigestUtils.md5Hex((String)(tenantID + "/" + hostName + "/" + bse));
        return digestedTenantHostBSE + "/" + packageCombination + "/";
    }

    private String escapePath(String fileSystemPath) {
        String result = fileSystemPath;
        try {
            URI uri = new URI(null, null, null, -1, fileSystemPath, null, null);
            result = uri.getRawPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public void setImageFileName(String imageFileName) {
        this.imageFileName = imageFileName;
    }

    public static String getErrorImageURL(String imageBaseURL) {
        return imageBaseURL.replaceAll("image$", "error.gif");
    }

    public static String getEmptyImageURL(String imageBaseURL) {
        return imageBaseURL.replaceAll("image$", "empty.gif");
    }

    public String getErrorImageURL() {
        return AbstractImageDescriptor.getErrorImageURL((String)this.dataFile.getDestinationURL());
    }

    public String getEmptyImageURL() {
        return AbstractImageDescriptor.getEmptyImageURL((String)this.dataFile.getDestinationURL());
    }

    public static String replaceIllegalCharacters(String guid) {
        String legalGuid = guid;
        legalGuid = legalGuid.replace("%", "%25%");
        for (Map.Entry entry : AbstractImageDescriptor.getIllegalCharacterMap().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            legalGuid = legalGuid.replace(key, value);
        }
        return legalGuid;
    }

    public static String constructHashCode(String filename) {
        String strippedFilename = filename.trim().replaceAll(" +", "");
        return String.valueOf(strippedFilename.hashCode());
    }

    private static Map<String, String> getIllegalCharacterMap() {
        if (illegalCharacterMap.isEmpty()) {
            AbstractImageDescriptor.setIllegalCharacterMap();
        }
        return illegalCharacterMap;
    }

    private static void setIllegalCharacterMap() {
        int size = "*?/&|<>$;{}\"`'".length();
        for (int i = 0; i < size; ++i) {
            char ch = "*?/&|<>$;{}\"`'".charAt(i);
            illegalCharacterMap.put(String.valueOf(ch), "%" + Integer.toHexString(ch).toUpperCase() + "%");
        }
    }
}

