/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.connection;

import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.caching.RetentionMap;
import com.infor.erpln.ir.connector.connection.RetentionCacheChecker;
import com.infor.erpln.jca.ConnectionImpl;
import java.io.File;
import java.io.FileFilter;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class RetentionCacheChecker
extends TimerTask {
    private static Logger logger = ESAPI.getLogger(RetentionCacheChecker.class);
    private static final String DATAFILE_WILDCARD = "*";
    private final RetentionMap<String, Datafile> dataFileCache;
    private final String targetFilePath;

    public RetentionCacheChecker(RetentionMap<String, Datafile> dataFileCache, String filePath) {
        this.targetFilePath = filePath;
        this.dataFileCache = dataFileCache;
    }

    @Override
    public void run() {
        try {
            if (logger.isInfoEnabled()) {
                logger.info(Logger.EVENT_UNSPECIFIED, String.format("Retention time check on %s cached data file(s)", this.dataFileCache.size()));
            }
            this.cleanTemporaryObjects(86400000L);
        }
        catch (Throwable t) {
            logger.error(Logger.EVENT_FAILURE, "Unexpected error when checking for outdated files", t);
        }
    }

    public void cleanTemporaryObjects(long retentionTime) {
        this.cleanRetentionCachedObjects(retentionTime);
        this.cleanOtherOutdatedObjects(retentionTime);
    }

    public void deleteDatafilesForConnection(ConnectionImpl connection) {
        Iterator it = this.dataFileCache.values().iterator();
        while (it.hasNext()) {
            Datafile datafile = (Datafile)it.next();
            if (datafile.getConnection() != connection) continue;
            try {
                if (logger.isInfoEnabled()) {
                    logger.info(Logger.EVENT_UNSPECIFIED, String.format("Removing datafile '%s' for closed bshell connection.", datafile.getName()));
                }
                this.deleteDataFiles(datafile.getName());
                it.remove();
            }
            catch (Exception ex) {
                logger.error(Logger.EVENT_FAILURE, "Unexpected exception while deleting data files", (Throwable)ex);
            }
        }
    }

    private void cleanRetentionCachedObjects(long retentionTime) {
        long now = new Timestamp(new Date().getTime()).getTime();
        Set dataFileSet = this.dataFileCache.entrySet();
        try {
            Iterator it = dataFileSet.iterator();
            while (it.hasNext()) {
                Map.Entry dataFile = (Map.Entry)it.next();
                Datafile cachedFile = (Datafile)dataFile.getValue();
                if (now - cachedFile.getLastRetrievalTimeStamp() <= retentionTime) continue;
                if (logger.isInfoEnabled()) {
                    logger.info(Logger.EVENT_UNSPECIFIED, String.format("Cleaning cache for data file '%s'.", cachedFile.getName()));
                }
                this.deleteDataFiles(cachedFile.getName());
                it.remove();
                if (!logger.isInfoEnabled()) continue;
                logger.info(Logger.EVENT_SUCCESS, String.format("Datafile '%s' removed from cache.", cachedFile.getName()));
            }
        }
        catch (Exception e) {
            logger.error(Logger.EVENT_FAILURE, "An unforseen exception occurs while cleaning the retention cache.", (Throwable)e);
        }
    }

    private void deleteDataFiles(String fileName) {
        WildcardFileFilter fileFilter = new WildcardFileFilter(fileName + DATAFILE_WILDCARD);
        File[] files = new File(this.targetFilePath).listFiles((FileFilter)fileFilter);
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            this.removeFileFromFileSystem(f);
        }
    }

    private void cleanOtherOutdatedObjects(long retentionTime) {
        int i;
        long now = new Timestamp(new Date().getTime()).getTime();
        if (null != this.targetFilePath) {
            WildcardFileFilter fileFilter = new WildcardFileFilter(new String[]{"*-l", "*-p", "*-i", "*-f", "*.pdf"});
            File[] files = new File(this.targetFilePath).listFiles((FileFilter)fileFilter);
            for (i = 0; i < files.length; ++i) {
                File f = files[i];
                if (now - f.lastModified() <= retentionTime) continue;
                this.removeFileFromFileSystem(f);
            }
        }
        this.cleanImages(new File(this.targetFilePath + "/" + "image"), retentionTime, now);
        1 directoryFilter = new /* Unavailable Anonymous Inner Class!! */;
        File[] directories = new File(this.targetFilePath).listFiles((FileFilter)directoryFilter);
        for (i = 0; i < directories.length; ++i) {
            this.cleanImages(new File(directories[i], "image"), retentionTime, now);
        }
    }

    private void cleanImages(File file, long retentionTime, long now) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            for (File lFile : file.listFiles()) {
                this.cleanImages(lFile, retentionTime, now);
            }
        } else if (file.isFile() && now - file.lastModified() > retentionTime) {
            this.removeFileFromFileSystem(file);
        }
    }

    private void removeFileFromFileSystem(File file) {
        if (file.exists() && file.canWrite() && file.delete() && logger.isInfoEnabled()) {
            logger.info(Logger.EVENT_SUCCESS, String.format("File '%s' removed from file system.", file.getPath()));
        }
    }
}

