/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.connection;

import com.infor.erpln.ir.connector.TransferFile;
import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.jca.dllclient.BaanDLLCall;
import com.infor.erpln.jca.dllclient.BaanDLLCallException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import javax.resource.cci.Connection;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class IsAliveTask
extends TimerTask {
    private static Logger logger = ESAPI.getLogger(IsAliveTask.class);
    private static final String LIBRARY_NAME = "ottidebl100sf00";
    private static final String METHOD_NAME = "ttide.bl100sf00.execute.get.tiv";
    private final Hashtable<String, ConnectionImpl> bshellConnections;

    public IsAliveTask(Hashtable<String, ConnectionImpl> bshellConnections) {
        this.bshellConnections = bshellConnections;
    }

    @Override
    public void run() {
        try {
            int keysLength = this.bshellConnections.size();
            if (logger.isInfoEnabled()) {
                logger.info(Logger.EVENT_UNSPECIFIED, String.format("Regular check on %s cached connection(s)", keysLength));
            }
            Set set = this.bshellConnections.entrySet();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                Map.Entry connection = it.next();
                ConnectionImpl bshellConnection = (ConnectionImpl)connection.getValue();
                BaanDLLCall call = new BaanDLLCall();
                call.attachConnection((Connection)bshellConnection);
                call.setDLL(LIBRARY_NAME);
                call.setFunction(METHOD_NAME);
                try {
                    call.execute();
                }
                catch (BaanDLLCallException e) {
                    if (logger.isInfoEnabled()) {
                        logger.info(Logger.EVENT_UNSPECIFIED, String.format("Removing non-functional connection '%s' from cache.", connection.getKey()));
                    }
                    it.remove();
                    TransferFile.getCacheChecker().deleteDatafilesForConnection(bshellConnection);
                }
            }
            if (set.size() == 0) {
                logger.info(Logger.EVENT_SUCCESS, "Closed the timer for regular checks since no connections are cached anymore.");
                this.cancel();
            }
        }
        catch (Throwable t) {
            logger.error(Logger.EVENT_FAILURE, "Unexpected error during check for broken connections", t);
        }
    }
}

