/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.connection;

import com.infor.erpln.ir.connector.connection.IsAliveTask;
import com.infor.erpln.jca.ConnectionFactoryImpl;
import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.jca.ConnectionSpecImpl;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.PatternSyntaxException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionSpec;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class ConnectionCacheHelper {
    private static Logger logger = ESAPI.getLogger(ConnectionCacheHelper.class);
    private static final String ACTIVATION_SOCKET_TICKET = "socket_ticket";
    private static final String JCA_URI_SEPARATOR = ":";
    private static final int HOSTNAME_ARGUMENT = 1;
    private static final int PORT_ARGUMENT = 2;
    private static final int URI_ARGUMENTS = 3;
    private static final int TIMER_INTERVAL = 600000;
    private final Hashtable<String, ConnectionImpl> bshellConnections;
    private final Timer timer;
    private final String jcaUri;
    private final String jcaTicket;
    private final ConnectionFactoryImpl jcaConnectionFactory = new ConnectionFactoryImpl();

    public ConnectionCacheHelper(Hashtable<String, ConnectionImpl> connections, Timer timer, String jcaUri, String jcaTicket) {
        this.bshellConnections = connections;
        this.timer = timer;
        this.jcaUri = jcaUri;
        this.jcaTicket = jcaTicket;
    }

    public ConnectionImpl getConnection() throws ResourceException {
        ConnectionImpl bshellConnection = null;
        String connectionKey = this.createKey(this.jcaUri, this.jcaTicket);
        if (this.bshellConnections.containsKey(connectionKey)) {
            if (logger.isInfoEnabled()) {
                logger.info(Logger.EVENT_SUCCESS, String.format("Connection obtained from cache for jcaUri '%s' and jcaTicket '%s'.", this.jcaUri, this.jcaTicket));
            }
            bshellConnection = (ConnectionImpl)this.bshellConnections.get(connectionKey);
        } else {
            bshellConnection = this.addConnection();
            this.bshellConnections.put(connectionKey, bshellConnection);
            logger.info(Logger.EVENT_SUCCESS, "New back-end connection added to cache.");
            if (this.bshellConnections.size() == 1) {
                this.timer.schedule((TimerTask)new IsAliveTask(this.bshellConnections), 1000L, 600000L);
                logger.info(Logger.EVENT_SUCCESS, "IsAliveTask timer scheduled.");
            }
        }
        return bshellConnection;
    }

    private String createKey(String uri, String ticket) {
        return uri + ";" + ticket;
    }

    private ConnectionImpl addConnection() throws ResourceException {
        String[] jcaUriArguments = this.jcaUri.split(JCA_URI_SEPARATOR);
        if (jcaUriArguments.length != 3) {
            throw new PatternSyntaxException("JCA URI has more than 3 arguments", JCA_URI_SEPARATOR, 0);
        }
        int portNumber = Integer.valueOf(jcaUriArguments[2]);
        String hostname = jcaUriArguments[1].replace('/', ' ').trim();
        ConnectionSpecImpl spec = new ConnectionSpecImpl();
        spec.setBackend(hostname);
        spec.setActivationType(ACTIVATION_SOCKET_TICKET);
        spec.setPort(portNumber);
        spec.setPassword(this.jcaTicket);
        ConnectionImpl newConnection = (ConnectionImpl)this.jcaConnectionFactory.getConnection((ConnectionSpec)spec);
        if (logger.isInfoEnabled()) {
            logger.info(Logger.EVENT_SUCCESS, String.format("New socket connection created on host '%s', port number '%s' and jcaTicket '%s'.", hostname, portNumber, this.jcaTicket));
        }
        return newConnection;
    }

    public boolean isPresent() {
        return this.bshellConnections.containsKey(this.createKey(this.jcaUri, this.jcaTicket));
    }

    public void closeConnection() {
        ConnectionImpl toBeClosed = (ConnectionImpl)this.bshellConnections.get(this.createKey(this.jcaUri, this.jcaTicket));
        if (toBeClosed != null) {
            try {
                toBeClosed.close();
            }
            catch (ResourceException e) {
                logger.warning(Logger.EVENT_FAILURE, String.format("Failed to close the JCA connection on URI %s, error cause: '%s'", this.jcaUri, e.getMessage()));
            }
        }
    }
}

