/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.connection;

import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.caching.PropertyMap;
import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.soap.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbstractCustomFunctions {
    public static final String ENCODING = "UTF-8";
    protected final Datafile dataFile;
    protected final ConnectionImpl connection;
    private final PropertyMap pm;

    public AbstractCustomFunctions(Datafile dataFile) {
        this.dataFile = dataFile;
        this.pm = this.dataFile.getPropertyCache().getProperties();
        this.connection = dataFile.getConnection();
    }

    public String getPropertyValue(String property) throws IRException {
        String propertyValue = (String)this.pm.properties.get(property);
        if (null == propertyValue) {
            throw new IRException(IRMessage.EMPTY_REPORT_PROPERTY, new Object[]{property, this.dataFile.getName()});
        }
        return propertyValue;
    }

    public ConnectionImpl getConnection() {
        return this.connection;
    }

    public String getResultFromNode(String xmlString) throws IOException, IRException {
        Element node;
        try {
            node = XMLUtil.getSecureDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(xmlString.getBytes(ENCODING))).getDocumentElement();
        }
        catch (ParserConfigurationException pce) {
            throw new IRException(IRMessage.FAULT, new Object[]{pce.getMessage()});
        }
        catch (SAXException ire) {
            throw new IRException(IRMessage.FAULT, new Object[]{ire.getMessage()});
        }
        return node.getFirstChild().getTextContent();
    }
}

