/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.caching;

import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.images.CachedImage;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class RetentionMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = 1L;

    @Override
    public V get(Object object) {
        Object result = super.get(object);
        if (result instanceof Datafile) {
            ((Datafile)result).setLastRetrievalTimeStamp(this.getTimeStamp());
        }
        if (result instanceof CachedImage) {
            ((CachedImage)result).setLastRetrievalTimeStamp(this.getTimeStamp());
        }
        return result;
    }

    @Override
    public V put(K key, V value) {
        if (value instanceof Datafile) {
            ((Datafile)value).setLastRetrievalTimeStamp(this.getTimeStamp());
        }
        if (value instanceof CachedImage) {
            ((CachedImage)value).setLastRetrievalTimeStamp(this.getTimeStamp());
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Collection<V> c = map.values();
        for (V obj : c) {
            if (obj instanceof Datafile) {
                ((Datafile)obj).setLastRetrievalTimeStamp(this.getTimeStamp());
            }
            if (!(obj instanceof CachedImage)) continue;
            ((CachedImage)obj).setLastRetrievalTimeStamp(this.getTimeStamp());
        }
        super.putAll(map);
    }

    private long getTimeStamp() {
        return new Timestamp(new Date().getTime()).getTime();
    }
}

