/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector.caching;

import com.infor.erpln.ir.connector.caching.PropertyCache;
import com.infor.erpln.jca.ConnectionImpl;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class Datafile {
    private static final char DOT = '.';
    private static final String LANGUAGE_ISO_SEPARATOR = "-";
    protected boolean isUSLocale;
    private final String name;
    private final PropertyCache propCache = new PropertyCache();
    private ConnectionImpl connection;
    private String originatingFileName;
    private long lastRetrievalTimeStamp;
    private String sessionID;
    private String targetFilePath;
    private String destinationURL;
    private String irEndPoint;
    private String irCredentials;
    private String tenantID;
    private List<String> errorMessages;

    public Datafile(String name) {
        this.name = name;
    }

    public PropertyCache getPropertyCache() {
        return this.propCache;
    }

    public String getName() {
        return this.name;
    }

    public ConnectionImpl getConnection() {
        return this.connection;
    }

    public void setConnection(ConnectionImpl connection) {
        this.connection = connection;
    }

    public String getOriginatingFileName() {
        return this.originatingFileName;
    }

    public void setOriginatingFileName(String originatingFileName) {
        this.originatingFileName = originatingFileName;
    }

    public boolean isUSLocale() {
        return this.isUSLocale;
    }

    public void setUSLocale() {
        String languageISO = (String)this.getPropertyCache().properties.properties.get("LanguageISO");
        String[] parts = languageISO.split(LANGUAGE_ISO_SEPARATOR);
        Locale lc = parts.length > 1 ? new Locale(parts[0], parts[1]) : new Locale(parts[0]);
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(lc);
        DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
        this.isUSLocale = symbols.getDecimalSeparator() == '.';
    }

    public boolean isRuntimeFile() {
        return !this.getOriginatingFileName().toLowerCase().contains("ier");
    }

    public boolean isMainReport() {
        return this.originatingFileName.endsWith("_main.xml") || this.originatingFileName.endsWith("_main");
    }

    public void setIrEndpoint(String endPoint) {
        this.irEndPoint = endPoint;
    }

    public String getIrEndpoint() {
        return this.irEndPoint;
    }

    public void setCredentials(String credentials) {
        this.irCredentials = credentials;
    }

    public String getIrCredentials() {
        return this.irCredentials;
    }

    public long getLastRetrievalTimeStamp() {
        return this.lastRetrievalTimeStamp;
    }

    public void setLastRetrievalTimeStamp(long lastRetrievalTimeStamp) {
        this.lastRetrievalTimeStamp = lastRetrievalTimeStamp;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public void setTargetFilePath(String trgFilePath) {
        this.targetFilePath = trgFilePath;
    }

    public String getTargetFilePath() {
        return this.targetFilePath;
    }

    public void setDestinationURL(String destURL) {
        this.destinationURL = destURL;
    }

    public String getDestinationURL() {
        return this.destinationURL;
    }

    public String getTenantID() {
        return this.tenantID;
    }

    public void setTenantID(String tenantID) {
        this.tenantID = tenantID;
    }

    public void addError(String message) {
        if (this.errorMessages == null) {
            this.errorMessages = new ArrayList();
        }
        this.errorMessages.add(message);
    }

    public List<String> getErrors() {
        if (this.errorMessages != null) {
            return this.errorMessages;
        }
        return Collections.emptyList();
    }

    public void clearErrors() {
        if (this.errorMessages != null) {
            this.errorMessages.clear();
        }
    }
}

