/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector;

import com.infor.erpln.c4ws.util.oauth.BaseUriUtil;
import com.infor.erpln.ir.connector.AbstractConnector;
import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.ResultMessage;
import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.caching.RetentionMap;
import com.infor.erpln.ir.connector.connection.RetentionCacheChecker;
import com.infor.erpln.ir.connector.transform.DatafileTransformer;
import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.soap.XMLUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class TransferFile
extends AbstractConnector {
    private static final long serialVersionUID = 1L;
    private static RetentionCacheChecker cacheChecker;
    private static Logger logger;
    private static Validator validator;

    public static RetentionCacheChecker getCacheChecker() {
        return cacheChecker;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Hashtable bshellConnections;
        ServletContext sc = this.getServletContext();
        String imageURL = BaseUriUtil.getBaseUri((HttpServletRequest)request).replaceFirst("/transfer", "/image");
        String webserviceURL = BaseUriUtil.getBaseUri((HttpServletRequest)request);
        int endIndex = webserviceURL.lastIndexOf("/transfer");
        if (endIndex > 0) {
            webserviceURL = webserviceURL.substring(0, endIndex);
        }
        HttpSession httpSession = request.getSession(true);
        String sessionID = httpSession.getId();
        if (logger.isDebugEnabled()) {
            if (httpSession.isNew()) {
                logger.debug(Logger.EVENT_UNSPECIFIED, "Starting new HttpSession with ID " + sessionID);
            } else if (request.isRequestedSessionIdFromCookie()) {
                logger.debug(Logger.EVENT_UNSPECIFIED, "Reusing HttpSession ID from cookie: " + sessionID);
            } else {
                logger.warning(Logger.EVENT_UNSPECIFIED, "Reusing existing HttpSession -- no matching cookie in request");
            }
        }
        if ((bshellConnections = (Hashtable)sc.getAttribute("bshellConnections")) == null) {
            sc.setAttribute("bshellConnections", new Hashtable());
            sc.setAttribute("datafiles", (Object)new RetentionMap());
            sc.setAttribute("scheduledTasks", (Object)new Timer());
        }
        ResultMessage resultMessage = new ResultMessage(IRMessage.OK, new Object[0]);
        String xmlResponse = "";
        try {
            DocumentBuilderFactory factory = XMLUtil.getSecureDocumentBuilderFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource((InputStream)request.getInputStream());
            Document doc = builder.parse(is);
            Element element = (Element)doc.getElementsByTagName("transferRequest").item(0);
            String jcaURI = this.getNodeValue(element, "jcaURI");
            String jcaTicket = this.getNodeValue(element, "jcaTicket");
            String dataFileName = this.getNodeValue(element, "dataFileName");
            String endpoint = this.getNodeValue(element, "endpoint");
            String credentials = this.getNodeValue(element, "credentials");
            String destinationFileName = this.getNodeValue(element, "destinationFileName");
            String destFolder = this.getNodeValue(element, "destFolder");
            if (!validator.isValidInput("TransferFile_destinationFileName", destinationFileName, "FileName", 255, false, false)) {
                logger.always(Logger.SECURITY_FAILURE, String.format("Attempt to use invalid file name: '%s'", destinationFileName));
                throw new IRException(IRMessage.SECURITY_ERROR, new Object[]{"Invalid destination file name in 'TransferFile' request"});
            }
            String officialDataFolder = (String)sc.getAttribute("com.infor.erpln.ir.dataFolder");
            if (officialDataFolder == null) {
                logger.info(Logger.EVENT_UNSPECIFIED, String.format("Setting data folder to '%s'", destFolder));
                sc.setAttribute("com.infor.erpln.ir.dataFolder", (Object)destFolder);
            } else if (!destFolder.equals(officialDataFolder)) {
                logger.always(Logger.SECURITY_FAILURE, String.format("Attempting to change the data folder ('%s') to '%s'", officialDataFolder, destFolder));
                throw new IRException(IRMessage.SECURITY_ERROR, new Object[]{"Attempting to use a different data folder"});
            }
            String transferFolder = destFolder;
            int posTenantID = credentials.indexOf("<tenantID>") + 10;
            String tenantID = posTenantID > 10 ? credentials.substring(posTenantID, credentials.indexOf("</tenantID>")) : "";
            resultMessage = this.transferFile(jcaURI, jcaTicket, dataFileName, endpoint, credentials, transferFolder, destinationFileName, imageURL, tenantID);
            if (resultMessage.getCode() == IRMessage.OK.messageCode()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(Logger.EVENT_SUCCESS, String.format("TransferFile was successful. 'datafile' report parameter = %s", destinationFileName));
                }
                xmlResponse = "<transferResponse>" + resultMessage.asXmlFragment() + "<sessionID>" + sessionID + "</sessionID></transferResponse>";
            } else {
                xmlResponse = this.createXmlResponse(resultMessage);
            }
            this.writeInformationFile(transferFolder, destinationFileName, webserviceURL, sessionID);
        }
        catch (IRException ex) {
            resultMessage.setIRException(ex);
            xmlResponse = this.createXmlResponse(resultMessage);
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription());
        }
        catch (Exception ex) {
            resultMessage.setIRMessage(IRMessage.INVALID_OR_MISSING_XML, new Object[]{ex.getMessage()});
            xmlResponse = this.createXmlResponse(resultMessage);
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)ex);
        }
        response.setContentType("text/xml; charset=UTF-8");
        try (PrintWriter out = response.getWriter();){
            out.write(xmlResponse);
        }
    }

    private String createXmlResponse(ResultMessage result) {
        return String.format("<transferResponse>%s</transferResponse>", result.asXmlFragment());
    }

    private ResultMessage transferFile(String jcaUri, String jcaTicket, String dataFileName, String endpoint, String credentials, String destinationFolder, String destinationFileName, String imageURL, String tenantID) {
        if (logger.isInfoEnabled()) {
            logger.info(Logger.EVENT_UNSPECIFIED, String.format("TransferFile servlet called with jcaUri '%s' and jcaTicket '%s', file to be stored in '%s'.", jcaUri, jcaTicket, destinationFolder + "/" + destinationFileName));
        }
        ServletContext servletContext = this.getServletContext();
        Timer timer = (Timer)servletContext.getAttribute("scheduledTasks");
        RetentionMap dataFileCache = (RetentionMap)servletContext.getAttribute("datafiles");
        ResultMessage resultMessage = new ResultMessage(IRMessage.OK, new Object[0]);
        Datafile datafile = new Datafile(destinationFileName);
        datafile.setOriginatingFileName(dataFileName);
        datafile.getPropertyCache().addProperty("DatafileName", destinationFolder + "/" + destinationFileName + "-f");
        try {
            ConnectionImpl bshellConnection = this.getBackendConnection(jcaUri, jcaTicket);
            datafile.setConnection(bshellConnection);
            datafile.setIrEndpoint(endpoint);
            datafile.setCredentials(credentials);
            datafile.setTargetFilePath(destinationFolder);
            datafile.setDestinationURL(imageURL);
            datafile.setTenantID(tenantID);
            resultMessage = new DatafileTransformer(datafile, dataFileCache, destinationFolder).transform();
            datafile.getPropertyCache().addProperty("DecimalSeparator", datafile.isUSLocale() ? "." : ",");
            if (resultMessage.getCode() == IRMessage.OK.messageCode() && cacheChecker == null) {
                cacheChecker = new RetentionCacheChecker(dataFileCache, destinationFolder);
                timer.schedule((TimerTask)cacheChecker, 21600000L, 21600000L);
                logger.info(Logger.EVENT_SUCCESS, "RetentionCacheChecker task scheduled.");
            }
        }
        catch (IRException e) {
            resultMessage.setIRException(e);
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)e);
        }
        return resultMessage;
    }

    private void writeInformationFile(String destinationFolder, String destinationFileName, String webserviceURL, String jsessionId) throws IRException {
        File file = new File(destinationFolder, destinationFileName + "-i");
        if (!file.getParentFile().canWrite()) {
            throw new IRException(IRMessage.CANNOT_WRITE_FOLDER, new Object[]{destinationFolder});
        }
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            out.write("<info><webserviceURL>");
            out.write(webserviceURL);
            out.write("</webserviceURL><jsessionId>");
            out.write(jsessionId);
            out.write("</jsessionId></info>\n");
            ((Writer)out).flush();
        }
        catch (IOException e) {
            throw new IRException(IRMessage.CANNOT_CREATE_FILE, new Object[]{file.getPath()});
        }
    }

    static {
        logger = ESAPI.getLogger(TransferFile.class);
        validator = ESAPI.validator();
    }
}

