/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector;

import com.infor.erpln.c4ws.util.oauth.BaseUriUtil;
import com.infor.erpln.ir.connector.AbstractConnector;
import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.ResultMessage;
import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.caching.RetentionMap;
import com.infor.erpln.ir.connector.images.AdditionalFile;
import com.infor.erpln.ir.connector.images.ApplicationImage;
import com.infor.erpln.ir.connector.images.BarcodeImage;
import com.infor.erpln.ir.connector.images.CompanyLogo;
import com.infor.erpln.ir.connector.images.EnumFile;
import com.infor.erpln.ir.connector.images.SensitivityImage;
import com.infor.erpln.jca.dllclient.BaanDLLCallException;
import com.infor.erpln.soap.XMLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class StoreImage
extends AbstractConnector {
    private static final long serialVersionUID = 1L;
    private static Logger logger = ESAPI.getLogger(StoreImage.class);
    private static Encoder encoder = ESAPI.encoder();
    private static final String COMPANY_LOGO = "0";
    private static final String SENSITIVITY_IMAGE = "1";
    private static final String APPLICATION_IMAGE = "2";
    private static final String ENUM_IMAGE = "3";
    private static final String ADDITIONAL_FILE = "4";
    private static final String BARCODE = "5";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String imageResult = "";
        String destinationURL = BaseUriUtil.getBaseUri((HttpServletRequest)request);
        int indexOfStore = destinationURL.lastIndexOf("/store");
        if (indexOfStore <= 0) {
            throw new ServletException("URL for 'StoreImage' request is incorrect");
        }
        destinationURL = destinationURL.substring(0, indexOfStore + 1);
        ResultMessage resultMessage = new ResultMessage(IRMessage.OK, new Object[0]);
        if (!request.isRequestedSessionIdFromCookie()) {
            logger.error(Logger.EVENT_FAILURE, "\"/store\" was invoked without JSESSIONID cookie");
        }
        try {
            DocumentBuilderFactory factory = XMLUtil.getSecureDocumentBuilderFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource((InputStream)request.getInputStream());
            Document doc = builder.parse(is);
            Element reqElement = (Element)doc.getElementsByTagName("imageRequest").item(0);
            String datafile = this.getNodeValue(reqElement, "datafile");
            String type = this.getNodeValue(reqElement, "type");
            try {
                imageResult = this.retrieveImage(datafile, type, reqElement, destinationURL);
            }
            catch (BaanDLLCallException e) {
                resultMessage.setIRMessage(IRMessage.UNABLE_TO_STORE_IMAGE, new Object[]{datafile, e.getMessage()});
                logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)e);
            }
            catch (IRException e) {
                resultMessage.setIRException(e);
                logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)e);
            }
        }
        catch (Exception ex) {
            resultMessage.setIRMessage(IRMessage.INVALID_OR_MISSING_XML, new Object[]{ex.getMessage()});
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)ex);
        }
        String xmlResponse = this.constructResponseMessage(resultMessage, imageResult);
        response.setContentType("text/xml; charset=UTF-8");
        try (PrintWriter out = response.getWriter();){
            out.write(xmlResponse);
        }
    }

    private Datafile getDataFile(String fileName) {
        ServletContext sc = this.getServletContext();
        RetentionMap datafiles = (RetentionMap)sc.getAttribute("datafiles");
        Datafile dataFile = (Datafile)datafiles.get((Object)fileName);
        return dataFile;
    }

    private String retrieveImage(String dataFileName, String type, Element reqElement, String destinationURL) throws IRException, BaanDLLCallException, IOException {
        String imageURL = "";
        ServletContext sc = this.getServletContext();
        String targetFilePath = (String)sc.getAttribute("com.infor.erpln.ir.dataFolder");
        String packageCode = this.getNodeValue(reqElement, "package");
        String moduleCode = this.getNodeValue(reqElement, "module");
        String additinalFileName = this.getNodeValue(reqElement, "name");
        String imageGuid = this.getNodeValue(reqElement, "guid");
        String domain = this.getNodeValue(reqElement, "domain");
        String value = this.getNodeValue(reqElement, "value");
        String parameters = this.getNodeValue(reqElement, "parameters");
        String height = this.getNodeValue(reqElement, "height");
        String width = this.getNodeValue(reqElement, "width");
        CompanyLogo imgDescr = null;
        Datafile dataFile = this.getDataFile(dataFileName);
        switch (type) {
            case "0": {
                imgDescr = new CompanyLogo(dataFile);
                break;
            }
            case "1": {
                HashMap sl = new HashMap(0);
                imgDescr = new SensitivityImage(dataFile, sl, Integer.valueOf(height).intValue(), Integer.valueOf(width).intValue());
                break;
            }
            case "2": {
                imgDescr = new ApplicationImage(dataFile, imageGuid);
                break;
            }
            case "3": {
                imgDescr = new EnumFile(dataFile, domain, Integer.valueOf(value).intValue());
                break;
            }
            case "4": {
                imgDescr = new AdditionalFile(dataFile, packageCode, moduleCode, additinalFileName);
                break;
            }
            case "5": {
                imgDescr = new BarcodeImage(dataFile, value, parameters);
                break;
            }
            default: {
                throw new IRException(IRMessage.UNSUPPORTED_IMAGE_FILE_TYPE, new Object[]{type});
            }
        }
        imageURL = imgDescr.storeImage(targetFilePath, destinationURL);
        if (logger.isDebugEnabled()) {
            logger.debug(Logger.EVENT_SUCCESS, String.format("Custom Function call to store an image of type '%s' succeeds.", type));
        }
        return imageURL;
    }

    private String constructResponseMessage(ResultMessage resultMessage, String imageResult) {
        String response = "<imageResponse><status>" + resultMessage.getCode() + "</status><message>" + encoder.encodeForXML(resultMessage.getUserDescription()) + "</message>";
        if (resultMessage.getCode() == IRMessage.OK.messageCode()) {
            response = response + "<url>" + imageResult + "</url>";
        }
        response = response + "</imageResponse>";
        return response;
    }
}

