/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector;

import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;

public class ResultMessage {
    private static Encoder encoder = ESAPI.encoder();
    private int code;
    private String userDescription;
    private String logDescription;
    private ResultMessage detailedMessage;

    public ResultMessage(IRMessage irMessage, Object ... args) {
        this.setIRMessage(irMessage, args);
    }

    public ResultMessage(IRException irException) {
        this.setIRException(irException);
    }

    public int getCode() {
        return this.code;
    }

    public String getUserDescription() {
        return this.userDescription;
    }

    public String getLogDescription() {
        return this.logDescription;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setLogDescription(String description) {
        this.logDescription = description;
    }

    public final void setIRMessage(IRMessage irMessage, Object ... args) {
        this.code = irMessage.messageCode();
        this.userDescription = irMessage.getUserMessage();
        this.logDescription = irMessage.getLogMessage(args);
    }

    public final void setIRException(IRException irException) {
        this.code = irException.getIRMessage().messageCode();
        this.userDescription = irException.getUserMessage();
        this.logDescription = irException.getLogMessage();
    }

    public ResultMessage getDetailedMessage() {
        return this.detailedMessage;
    }

    public void setDetailedMessage(ResultMessage detailedMessage) {
        this.detailedMessage = detailedMessage;
    }

    public boolean isSuccess() {
        return this.code < 2;
    }

    public String asXmlFragment() {
        return String.format("<status>%d</status><message>%s</message>", this.code, encoder.encodeForXML(this.userDescription));
    }
}

