/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector;

import com.infor.erpln.ir.connector.AbstractConnector;
import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.ResultMessage;
import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.caching.RetentionMap;
import com.infor.erpln.ir.connector.reportserver.cognos.CognosReportServer;
import com.infor.erpln.soap.XMLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import javax.resource.ResourceException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class RenderReport
extends AbstractConnector {
    private static final long serialVersionUID = 1L;
    private static Logger logger = ESAPI.getLogger(RenderReport.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ResultMessage result;
        if (!request.isRequestedSessionIdFromCookie()) {
            logger.error(Logger.EVENT_FAILURE, "\"/render\" was invoked without JSESSIONID cookie");
        }
        try {
            DocumentBuilderFactory factory = XMLUtil.getSecureDocumentBuilderFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource((InputStream)request.getInputStream());
            Document doc = builder.parse(is);
            Element element = (Element)doc.getElementsByTagName("renderRequest").item(0);
            String datafile = this.getNodeValue(element, "datafile");
            String reportPath = this.getNodeValue(element, "reportPath");
            String format = this.getNodeValue(element, "format");
            String destinationFileName = this.getNodeValue(element, "destinationFileName");
            String endpoint = this.getNodeValue(element, "endpoint");
            String credentials = this.getNodeValue(element, "credentials");
            result = this.renderReport(datafile, reportPath, format, destinationFileName, endpoint, credentials);
        }
        catch (Exception ex) {
            result = new ResultMessage(IRMessage.INVALID_OR_MISSING_XML, new Object[]{ex.getMessage()});
            logger.error(Logger.EVENT_FAILURE, result.getLogDescription(), (Throwable)ex);
        }
        response.setContentType("text/xml; charset=UTF-8");
        try (PrintWriter out = response.getWriter();){
            out.write("<renderResponse>");
            out.write(result.asXmlFragment());
            out.write("</renderResponse>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultMessage renderReport(String dataFileName, String reportName, String format, String destinationFileName, String irEndpoint, String irCredentials) {
        ResultMessage resultMessage = new ResultMessage(IRMessage.OK, new Object[0]);
        ServletContext servletContext = this.getServletContext();
        RetentionMap datafiles = (RetentionMap)servletContext.getAttribute("datafiles");
        Datafile datafile = (Datafile)datafiles.get((Object)dataFileName);
        if (datafile != null) {
            CognosReportServer reportServer = null;
            try {
                reportServer = new CognosReportServer(irEndpoint);
                if (!reportServer.logon(irCredentials)) return resultMessage;
                datafile.clearErrors();
                byte[] renderedReport = reportServer.renderReport(datafile, reportName, format);
                List errors = datafile.getErrors();
                if (!errors.isEmpty()) {
                    String errorMessage = StringUtils.join((Collection)errors, (String)", ");
                    throw new IRException(IRMessage.ERROR_DURING_RENDER, new Object[]{errorMessage});
                }
                if (renderedReport == null) return resultMessage;
                if (logger.isInfoEnabled()) {
                    logger.info(Logger.EVENT_UNSPECIFIED, IRMessage.WRITING_RENDERED_REPORT.getLogMessage(new Object[]{destinationFileName}));
                }
                OutputStream destStream = datafile.getConnection().openForWrite(destinationFileName, false);
                destStream.write(renderedReport);
                destStream.close();
                return resultMessage;
            }
            catch (IRException e) {
                resultMessage.setIRException(e);
                logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)e);
                return resultMessage;
            }
            catch (IOException ioe) {
                resultMessage.setIRMessage(IRMessage.CANNOT_WRITE_RENDERED_REPORT, new Object[]{destinationFileName});
                logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)ioe);
                return resultMessage;
            }
            catch (ResourceException e) {
                resultMessage.setIRMessage(IRMessage.CANNOT_EXPORT_REPORT, new Object[]{reportName});
                logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)e);
                return resultMessage;
            }
            finally {
                if (reportServer != null && StringUtils.isNotBlank((String)irCredentials)) {
                    try {
                        reportServer.logoff();
                    }
                    catch (IRException e) {}
                }
            }
        }
        resultMessage.setIRMessage(IRMessage.DATA_FILE_NOT_FOUND, new Object[]{dataFileName});
        logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription());
        return resultMessage;
    }
}

