/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector;

import com.infor.erpln.ir.connector.AbstractConnector;
import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.ResultMessage;
import com.infor.erpln.ir.connector.reportserver.cognos.CognosReportServer;
import com.infor.erpln.soap.XMLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class InstallInitialFolders
extends AbstractConnector {
    private static final long serialVersionUID = 1L;
    private static Logger logger = ESAPI.getLogger(InstallInitialFolders.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ResultMessage result;
        try {
            DocumentBuilderFactory factory = XMLUtil.getSecureDocumentBuilderFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource((InputStream)request.getInputStream());
            Document doc = builder.parse(is);
            Element element = (Element)doc.getElementsByTagName("installInitialFolders").item(0);
            String endpoint = this.getNodeValue(element, "endpoint");
            String credentials = this.getNodeValue(element, "credentials");
            result = this.installInitialFolders(endpoint, credentials);
        }
        catch (Exception ex) {
            result = new ResultMessage(IRMessage.INVALID_OR_MISSING_XML, new Object[]{ex.getMessage()});
            logger.error(Logger.EVENT_FAILURE, result.getLogDescription(), (Throwable)ex);
        }
        response.setContentType("text/xml; charset=UTF-8");
        try (PrintWriter out = response.getWriter();){
            out.write("<installInitialFoldersResponse>");
            out.write(result.asXmlFragment());
            out.write("</installInitialFoldersResponse>\n");
        }
    }

    public ResultMessage installInitialFolders(String irEndpoint, String irCredentials) {
        ResultMessage resultMessage = new ResultMessage(IRMessage.OK, new Object[0]);
        try {
            CognosReportServer reportServer = new CognosReportServer(irEndpoint);
            if (reportServer.logon(irCredentials)) {
                reportServer.installInitialFolders();
            }
            if (irCredentials != null && !irCredentials.isEmpty()) {
                reportServer.logoff();
            }
        }
        catch (IRException e) {
            resultMessage.setIRException(e);
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)e);
        }
        return resultMessage;
    }
}

