/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector;

import com.infor.erpln.ir.connector.AbstractConnector;
import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.ResultMessage;
import com.infor.erpln.ir.connector.reportserver.cognos.CognosReportServer;
import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.soap.XMLUtil;
import com.infor.erpln.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.resource.ResourceException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImportServlet
extends AbstractConnector {
    private static final long serialVersionUID = 1L;
    private static final String CONTENT_TYPE = "text/xml;charset=UTF-8";
    private static final String TAG_ACTION = "action";
    private static final String TAG_SRC_FILE = "srcFile";
    private static final String TAG_DEST_FOLDER = "destFolder";
    private static final String TAG_JCA_URI = "jcaUri";
    private static final String TAG_JCA_TICKET = "jcaTicket";
    private static final String TAG_ARCHIVE = "archive";
    private static final String TAG_DEST_PATH = "destPath";
    private static final String TAG_IR_ADDRESS = "irAddress";
    private static final String TAG_IR_CREDENTIALS = "irCredentials";
    private static final String ZIP_EXTENSION = ".zip";
    private static final String TAG_TENANT_ID = "tenantID";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ResultMessage message = new ResultMessage(IRMessage.OK, new Object[0]);
        Element xmlRequest = this.parseXml(request, message);
        if (message.isSuccess()) {
            this.dispatchRequest(xmlRequest, message);
        }
        response.setContentType("text/xml;charset=UTF-8");
        try (PrintWriter writer = response.getWriter();){
            writer.write("<response>");
            writer.write(message.asXmlFragment());
            writer.write("</response>\n");
            writer.close();
        }
    }

    private Element parseXml(HttpServletRequest request, ResultMessage message) {
        Element result = null;
        try {
            DocumentBuilderFactory factory = XMLUtil.getSecureDocumentBuilderFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            try (ServletInputStream inputStream = request.getInputStream();){
                Document document = builder.parse((InputStream)inputStream);
                result = document.getDocumentElement();
            }
        }
        catch (Throwable t) {
            message.setIRMessage(IRMessage.ERROR_PARSE_XML_REQUEST, new Object[]{t.getClass().getSimpleName(), t.getMessage()});
        }
        return result;
    }

    private void dispatchRequest(Element xmlRequest, ResultMessage message) {
        if (xmlRequest == null) {
            message.setIRMessage(IRMessage.INVALID_OR_MISSING_XML, new Object[]{"XML request is missing"});
            return;
        }
        String action = this.getTextValue(xmlRequest, "action");
        if (action == null) {
            message.setIRMessage(IRMessage.INVALID_OR_MISSING_XML, new Object[]{"XML request does not contain an 'action' element"});
            return;
        }
        if (action.equalsIgnoreCase("transfer")) {
            this.doTransfer(xmlRequest, message);
        } else if (action.equalsIgnoreCase("deploy")) {
            this.doDeploy(xmlRequest, message);
        } else {
            message.setIRMessage(IRMessage.INVALID_OR_MISSING_XML, new Object[]{"XML request contains unknown action: '" + action + "'"});
        }
    }

    private String getTextValue(Element xmlRequest, String name) {
        Node namedNode = xmlRequest.getElementsByTagName(name).item(0);
        if (namedNode instanceof Element) {
            return namedNode.getTextContent();
        }
        return null;
    }

    private String checkRequiredElements(Element xmlRequest, String ... parameters) {
        String error = null;
        ArrayList<String> missing = new ArrayList<String>();
        for (String parameter : parameters) {
            String value = this.getTextValue(xmlRequest, parameter);
            if (value != null && !value.isEmpty()) continue;
            missing.add(parameter);
        }
        if (missing.size() > 0) {
            StringBuilder builder = new StringBuilder("XML request does not contain required ");
            builder.append(missing.size() == 1 ? "parameter:" : "parameters:");
            for (String parameter : missing) {
                builder.append(" '").append(parameter).append("'");
            }
            error = builder.toString();
        }
        return error;
    }

    private void doTransfer(Element xmlRequest, ResultMessage message) {
        String error = this.checkRequiredElements(xmlRequest, new String[]{"destFolder", "jcaUri", "jcaTicket", "srcFile"});
        if (error != null) {
            message.setIRMessage(IRMessage.INVALID_OR_MISSING_XML, new Object[]{error});
            return;
        }
        String destFolder = this.getTextValue(xmlRequest, "destFolder");
        String jcaUri = this.getTextValue(xmlRequest, "jcaUri");
        String jcaTicket = this.getTextValue(xmlRequest, "jcaTicket");
        this.validateDestFolder(destFolder, message);
        if (message.isSuccess()) {
            try {
                ConnectionImpl connection = this.getBackendConnection(jcaUri, jcaTicket);
                NodeList srcFiles = xmlRequest.getElementsByTagName("srcFile");
                StringBuilder errorMessage = new StringBuilder();
                for (int i = 0; i < srcFiles.getLength(); ++i) {
                    Element source = (Element)srcFiles.item(i);
                    String srcName = source.getTextContent();
                    String archiveName = source.getAttribute("archive");
                    if (archiveName == null || archiveName.isEmpty()) {
                        message.setIRMessage(IRMessage.TRANSFER_IRPACK_FAILED, new Object[0]);
                        errorMessage.append("\n").append("Target archive name missing for source file '").append(srcName).append("'");
                        continue;
                    }
                    try {
                        this.copyArchiveFromBackend(srcName, archiveName, destFolder, connection);
                        continue;
                    }
                    catch (IOException | ResourceException e) {
                        message.setIRMessage(IRMessage.TRANSFER_IRPACK_FAILED, new Object[0]);
                        errorMessage.append("\n").append(archiveName).append(": ").append(e.getMessage());
                    }
                }
                if (!message.isSuccess()) {
                    message.setLogDescription(errorMessage.substring(1));
                }
                this.closeBackendConnection(jcaUri, jcaTicket);
            }
            catch (IRException ex) {
                message.setIRMessage(IRMessage.TRANSFER_IRPACK_FAILED, new Object[0]);
                message.setLogDescription("Failed to open connection to JCA URI '" + jcaUri + "'");
            }
        }
    }

    private void validateDestFolder(String folderName, ResultMessage message) {
        File folder = new File(folderName);
        try {
            if (folder.isDirectory()) {
                if (!folder.canWrite()) {
                    message.setIRMessage(IRMessage.CANNOT_WRITE_FOLDER, new Object[]{folderName});
                }
            } else if (folder.isFile()) {
                message.setIRMessage(IRMessage.CANNOT_WRITE_FOLDER, new Object[]{folderName});
                message.setLogDescription("'" + folderName + "' is not a folder but a regular file.");
            } else if (!folder.mkdirs()) {
                message.setIRMessage(IRMessage.CREATE_FOLDER_EXCEPTION, new Object[]{folderName});
            } else if (!folder.canWrite()) {
                message.setIRMessage(IRMessage.CANNOT_WRITE_FOLDER, new Object[]{folderName});
            }
        }
        catch (Exception ex) {
            message.setIRMessage(IRMessage.ERROR_VALIDATING_FOLDER, new Object[]{ex.getClass().getSimpleName(), ex.getMessage()});
        }
    }

    private void copyArchiveFromBackend(String srcFile, String destArchive, String destFolder, ConnectionImpl connection) throws IOException, ResourceException {
        InputStream jcaStream = connection.openForRead(srcFile, false);
        File target = new File(destFolder, destArchive + ".zip");
        FileUtils.copyInputStreamToFile((InputStream)jcaStream, (File)target);
    }

    private void doDeploy(Element xmlRequest, ResultMessage message) {
        String error = this.checkRequiredElements(xmlRequest, new String[]{"archive", "destPath", "irCredentials"});
        if (error != null) {
            message.setIRMessage(IRMessage.INVALID_OR_MISSING_XML, new Object[]{error});
            return;
        }
        String archive = this.getTextValue(xmlRequest, "archive");
        String destPath = this.getTextValue(xmlRequest, "destPath");
        String irAddress = this.getTextValue(xmlRequest, "irAddress");
        String credentialString = this.getTextValue(xmlRequest, "irCredentials");
        String tenantID = ImportServlet.getTenantID((String)credentialString);
        CognosReportServer reportServer = null;
        try {
            reportServer = new CognosReportServer(irAddress);
        }
        catch (Exception ex) {
            message.setIRMessage(IRMessage.COMMUNICATION_FAILURE_REPORT_SERVER, new Object[0]);
            return;
        }
        try {
            reportServer.logon(credentialString);
        }
        catch (IRException ex) {
            message.setIRException(ex);
            return;
        }
        try {
            reportServer.importReport(archive, destPath, tenantID);
        }
        catch (IRException ex) {
            message.setIRException(ex);
        }
        try {
            reportServer.logoff();
        }
        catch (IRException iRException) {
            // empty catch block
        }
    }

    private static String getTenantID(String credentials) {
        try {
            Element credentialElement = (Element)XmlUtil.convertStringToNode((String)credentials);
            Element tenantIdElement = (Element)credentialElement.getElementsByTagName("tenantID").item(0);
            return tenantIdElement.getTextContent();
        }
        catch (Throwable t) {
            return null;
        }
    }
}

