/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector;

import java.util.IllegalFormatException;

public enum IRMessage {
    OK(1, "Ok."),
    FAULT(2, "Failure.", "Failure: %s."),
    CANNOT_OPEN_CONNECTION(3, "Unable to open back-end connection."),
    DATA_FILE_NOT_TRANSFERRED(4, "Unable to transfer data file.", "Unable to transfer data file '%s'."),
    DATA_FILE_NOT_FOUND(5, "Data file not found", "Data file '%s' not found."),
    MALFORMED_URI(6, "Malformed JCA URI. Expected: 'tcp://[hostname]:[portnumber]"),
    CANNOT_WRITE_COGNOS_XML(7, "Unable to convert data file and write Cognos XML.", "Unable to convert data file and write Cognos XML in '%s'."),
    EMPTY_REPORT_PROPERTY(8, "Missing or empty report property", "Missing or empty report property '%s' in data file '%s'."),
    CREATE_FOLDER_EXCEPTION(9, "Unable to create folder.", "Unable to create folder '%s'."),
    UNAUTHORIZED_LAUNCH_REPORT_VIEWER(10, "Not authorized to launch report viewer.", "Not authorized to launch report viewer for data file '%s'."),
    UNKNOWN_SENSITIVITY_LEVEL(11, "Unknown sensitivity level.", "Unknown sensitivity level '%s'."),
    CANNOT_RETRIEVE_MIME_TYPE(12, "Unable to retrieve MIME type.", "Unable to retrieve MIME type for '%s'."),
    CANNOT_LAUNCH_REPORT_VIEWER(13, "Unable to launch report viewer.", "Unable to launch report viewer for data file '%s'."),
    CANNOT_LOGON_REPORT_SERVER(14, "Unable to logon to the report server.", "Unable to logon to the report server for user '%s'."),
    CANNOT_EXPORT_REPORT(15, "Unable to export report.", "Unable to export report '%s' from the report server."),
    COMMUNICATION_FAILURE_REPORT_SERVER(16, "Communication failure with the report server. See logfiles for more information."),
    CANNOT_WRITE_RENDERED_REPORT(17, "Unable to write rendered report to the back-end.", "Unable to write rendered report '%s' to the back-end."),
    WRITING_RENDERED_REPORT(18, "Writing rendered report output...", "Writing rendered report output to '%s' ..."),
    UNSUPPORTED_REPORT_RENDERING_FORMAT(19, "Unsupported report rendering format.", "Unsupported report rendering format '%s'. Use one of '%s'."),
    CANNOT_RENDER_REPORT(20, "Unable to render report on the report server.", "Unable to render report '%s' on the report server."),
    CANNOT_IMPORT_PACKAGE(21, "Unable to import package into the report server.", "Unable to import package '%s' into the report server."),
    CANNOT_READ_DEPLOYMENT_PATH(22, "Unable to read deployment path from configuration file."),
    CANNOT_RENDER_PDF(23, "Unable to render PDF document.", "Unable to render PDF document '%s'."),
    CANNOT_OPEN_PDF(24, "Unable to open PDF document.", "Unable to open PDF document '%s'."),
    NOT_AUTHORIZED_PDF(25, "No authorization to open PDF document.", "No authorization to open PDF document '%s'."),
    CANNOT_CREATE_DOC(26, "Unable to create main report document.", "Unable to create main report document '%s'."),
    INVALID_REGULAR_EXPRESSION(27, "Invalid regular expression.", "Invalid regular expression '%s'"),
    CANNOT_CREATE_BARCODE_FILE(28, "Unable to create a barcode file.", "Unable to create a barcode file for '%s'."),
    NOT_SUPPORTED_FILETYPE(29, "Unsupported barcode image file type.", "Unsupported barcode image file type '%s'. Supported file types are jpg and png."),
    MISSING_MANDATORY_PARAMETER(30, "Mandatory barcode parameter is missing or empty.", "Mandatory barcode parameter '%s' is missing or empty."),
    NOT_SUPPORTED_BARCODE(31, "Unsupported barcode type.", "Unsupported barcode type '%s'."),
    CANNOT_INVOKE_METHOD(32, "Unable to invoke java method for barcode.", "Unable to invoke java method '%s' for barcode '%s'."),
    CANNOT_INSTANTIATE_CLASS(33, "Unable to instantiate class."),
    ILLEGAL_ACCESS_FOR_CLASS(34, "Illegal access for class."),
    CLASS_NOT_FOUND(35, "Class not found."),
    CANNOT_SET_FIELD(36, "Unable to set java property for barcode.", "Unable to set java property '%s' for barcode '%s'."),
    CANNOT_CREATE_FILE(37, "Unable to create file.", "Unable to create file '%s'"),
    CANNOT_MOVE_BC(38, "Unable to move report", "Unable to move baseclass %s to '%s'"),
    CANNOT_IMPORT_REPORT(39, "Unable to import report into the report server.", "Unable to import report into '%s' of the report server."),
    PACKAGE_NOT_FOUND(40, "Package not found.", "Package '%s' not found."),
    REPORT_NOT_FOUND(41, "Report not found.", "Report for '%s' not found."),
    INVALID_OR_MISSING_XML(42, "Unable to retrieve data from the xml document.", "Unable to retrieve data from the xml document. Reason: '%s'."),
    UNABLE_TO_READ_DATAFILE(43, "Unable to retrieve content for datafile.", "Unable to retrieve content for datafile '%s'."),
    UNABLE_TO_EXECUTE_FUNCTION(44, "Unable to execute function.", "Unable to execute function. Reason: '%s'."),
    UNABLE_TO_PARSE_DLL_REQUEST(45, "Unable to parse DLL request.", "Unable to parse DLL request. Reason: '%s'."),
    ILLEGAL_CHARACTERS(46, "Datafile contains illegal characters.", "Datafile '%s' contains illegal characters."),
    UNABLE_TO_GET_PROPERTIES(47, "Unable to retrieve properties for datafile.", "Unable to retrieve properties for datafile '%s'."),
    UNSUPPORTED_IMAGE_FILE_TYPE(48, "Unsupported image file type.", "Unsupported image file type '%s'."),
    UNABLE_TO_STORE_IMAGE(49, "Unable to store image for datafile.", "Unable to store image for datafile '%s'. Reason: '%s'."),
    UNABLE_TO_GET_VERSIONINFO(50, "Unable to retrieve version information.", "Unable to retrieve version information. Reason: '%s'."),
    CANNOT_ADD_ROLE(51, "Error when creating a new LN Role.", "Error when creating new LN Role '%s'."),
    ERROR_ADDING_LN_ROLE_TO_COGNOS_ROLE(52, "Error when adding LN Role to Cognos Role.", "Error when adding LN Role '%s' to Cognos Role '%s'. "),
    ERROR_QUERYING_LN_ROLE(53, "Error when querying role.", "Error when querying role '%s'."),
    ERROR_PARSE_XML_REQUEST(54, "Error when parsing XML request.", "Error (%s) when parsing XML request: %s"),
    TRANSFER_IRPACK_FAILED(55, "Transfer of IRPACK archive failed."),
    CANNOT_WRITE_FOLDER(56, "Cannot write to folder.", "Cannot write to folder '%s'."),
    ERROR_VALIDATING_FOLDER(57, "Error when validating destination folder", "Error (%s) when validating destination folder: %s"),
    ARCHIVE_MISSING(58, "Deployment archive not present.", "Deployment archive '%s' not present."),
    ERROR_QUERYING_FOLDER(59, "Error when querying folder.", "Error when querying folder '%s'. "),
    ERROR_SETTING_PERMISSIONS(60, "Error when setting permissions.", "Error when trying to set permissions on %s '%s'."),
    ERROR_DURING_RENDER(61, "Errors during rendering.", "Errors were logged during rendering: %s"),
    SECURITY_ERROR(62, "Security error.", "Security error: %s");

    private final int messageCode;
    private final String userMessage;
    private final String logMessage;

    private IRMessage(int code, String userMessage) {
        this(string, n, code, userMessage, userMessage);
    }

    private IRMessage(int code, String userMessage, String logMessage) {
        this.messageCode = code;
        this.userMessage = userMessage;
        this.logMessage = logMessage;
    }

    public int messageCode() {
        return this.messageCode;
    }

    public String getUserMessage() {
        return this.userMessage;
    }

    public String getLogMessage(Object ... arguments) {
        try {
            return String.format(this.logMessage, arguments);
        }
        catch (IllegalFormatException ex) {
            return this.userMessage;
        }
    }
}

