/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector;

import com.infor.erpln.ir.connector.AbstractConnector;
import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.ResultMessage;
import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.caching.RetentionMap;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.Logger;

public class GetProperties
extends AbstractConnector {
    private static final long serialVersionUID = 1L;
    private static Logger logger = ESAPI.getLogger(GetProperties.class);
    private static Encoder encoder = ESAPI.encoder();

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!request.isRequestedSessionIdFromCookie()) {
            logger.error(Logger.EVENT_FAILURE, "\"/properties\" was invoked without JSESSIONID cookie");
        }
        ServletContext sc = this.getServletContext();
        String datafile = "";
        String properties = "";
        ResultMessage resultMessage = new ResultMessage(IRMessage.OK, new Object[0]);
        String xmlReq = this.getXmlContent(request);
        int endpos = xmlReq.lastIndexOf("</datafile>");
        if (endpos > 0) {
            datafile = (endpos = (xmlReq = xmlReq.substring(0, endpos)).lastIndexOf(">")) > 0 ? xmlReq.substring(endpos + 1) : "";
        }
        RetentionMap dataFileCache = (RetentionMap)sc.getAttribute("datafiles");
        try {
            properties = this.getCachedProperties((Datafile)dataFileCache.get((Object)datafile));
        }
        catch (IRException e) {
            resultMessage.setIRMessage(IRMessage.UNABLE_TO_GET_PROPERTIES, new Object[]{datafile});
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)e);
        }
        String xmlResponse = this.constructResponseMessage(resultMessage, properties);
        response.setContentType("text/xml; charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.write(xmlResponse);
        out.close();
    }

    private String getCachedProperties(Datafile datafile) throws IRException {
        String result = "";
        if (null != datafile) {
            for (Map.Entry entry : datafile.getPropertyCache().getProperties().properties.entrySet()) {
                result = result + "<property name='" + encoder.encodeForXMLAttribute((String)entry.getKey()) + "'>" + encoder.encodeForXML((String)entry.getValue()) + "</property>";
            }
        } else {
            throw new IRException(IRMessage.UNABLE_TO_GET_PROPERTIES, new Object[]{"<null>"});
        }
        return result;
    }

    private String constructResponseMessage(ResultMessage resultMessage, String callResult) {
        String response = "<propertiesResponse><status>" + resultMessage.getCode() + "</status><message>" + encoder.encodeForXML(resultMessage.getUserDescription()) + "</message>";
        if (resultMessage.getCode() == IRMessage.OK.messageCode()) {
            response = response + "<properties>" + callResult + "</properties>";
        }
        response = response + "</propertiesResponse>";
        return response;
    }
}

