/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector;

import com.infor.erpln.ir.connector.IRMessage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.Validator;

public class GetImage
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger logger = ESAPI.getLogger(GetImage.class);
    private static Validator validator = ESAPI.validator();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletContext sc = this.getServletContext();
        String targetPath = (String)sc.getAttribute("com.infor.erpln.ir.dataFolder");
        String pathInfo = request.getPathInfo();
        String filename = targetPath + '/' + "image" + pathInfo;
        if (pathInfo.contains("../")) {
            response.setStatus(404);
            logger.error(Logger.EVENT_FAILURE, IRMessage.ILLEGAL_CHARACTERS.getLogMessage(new Object[]{pathInfo}));
            return;
        }
        File file = new File(filename);
        if (!file.exists()) {
            response.setStatus(404);
            logger.error(Logger.EVENT_FAILURE, String.format("Image file '%s' not found", filename));
            return;
        }
        String mimeType = sc.getMimeType(filename);
        if (!validator.isValidInput("MIME type", mimeType, "HTTPHeaderValue", 100, false, false)) {
            response.setStatus(500);
            logger.error(Logger.EVENT_FAILURE, IRMessage.CANNOT_RETRIEVE_MIME_TYPE.getLogMessage(new Object[]{filename}));
            return;
        }
        response.setContentType(mimeType);
        response.setContentLength((int)file.length());
        Files.copy(file.toPath(), (OutputStream)response.getOutputStream());
    }
}

