/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector;

import com.infor.erpln.ir.connector.AbstractConnector;
import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.ResultMessage;
import com.infor.erpln.ir.connector.reportserver.cognos.CognosReportServer;
import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.soap.XMLUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.resource.ResourceException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExportServlet
extends AbstractConnector {
    private static final long serialVersionUID = 1L;
    private static final int KB = 1024;
    private static final String CONTENT_TYPE = "text/xml;charset=UTF-8";
    private static final String TAG_ACTION = "action";
    private static final String TAG_SRC_PACKAGE = "srcPackage";
    private static final String TAG_SRC_FOLDER = "srcFolder";
    private static final String TAG_DEST_PATH = "destPath";
    private static final String TAG_JCA_URI = "jcaUri";
    private static final String TAG_JCA_TICKET = "jcaTicket";
    private static final String TAG_ARCHIVE = "archive";
    private static final String TAG_IR_ADDRESS = "irAddress";
    private static final String TAG_IR_CREDENTIALS = "irCredentials";
    private static final String ZIP_EXTENSION = ".zip";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ResultMessage message = new ResultMessage(IRMessage.OK, new Object[0]);
        Element xmlRequest = this.parseXml(request, message);
        if (message.isSuccess()) {
            this.dispatchRequest(xmlRequest, message);
        }
        response.setContentType(CONTENT_TYPE);
        try (PrintWriter writer = response.getWriter();){
            writer.write("<response>");
            writer.write(message.asXmlFragment());
            writer.write("</response>\n");
            writer.close();
        }
    }

    private Element parseXml(HttpServletRequest request, ResultMessage message) {
        Element result = null;
        try {
            DocumentBuilderFactory factory = XMLUtil.getSecureDocumentBuilderFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            try (ServletInputStream inputStream = request.getInputStream();){
                Document document = builder.parse((InputStream)inputStream);
                result = document.getDocumentElement();
            }
        }
        catch (Throwable t) {
            message.setIRMessage(IRMessage.ERROR_PARSE_XML_REQUEST, new Object[]{t.getClass().getSimpleName(), t.getMessage()});
        }
        return result;
    }

    private void dispatchRequest(Element xmlRequest, ResultMessage message) {
        if (xmlRequest == null) {
            message.setIRMessage(IRMessage.INVALID_OR_MISSING_XML, new Object[]{"XML request is missing"});
            return;
        }
        String action = this.getTextValue(xmlRequest, TAG_ACTION);
        if (action == null) {
            message.setIRMessage(IRMessage.INVALID_OR_MISSING_XML, new Object[]{"XML request does not contain an 'action' element"});
            return;
        }
        if (action.equalsIgnoreCase("createDeployment")) {
            this.doCreateDeployment(xmlRequest, message);
        } else if (action.equalsIgnoreCase("transfer")) {
            this.doTransfer(xmlRequest, message);
        } else {
            message.setIRMessage(IRMessage.INVALID_OR_MISSING_XML, new Object[]{"XML request contains unknown action: '" + action + "'"});
        }
    }

    private String getTextValue(Element xmlRequest, String name) {
        Node namedNode = xmlRequest.getElementsByTagName(name).item(0);
        if (namedNode instanceof Element) {
            return namedNode.getTextContent();
        }
        return null;
    }

    private String checkRequiredElements(Element xmlRequest, String ... parameters) {
        String error = null;
        ArrayList<String> missing = new ArrayList<String>();
        for (String parameter : parameters) {
            String value = this.getTextValue(xmlRequest, parameter);
            if (value != null && !value.isEmpty()) continue;
            missing.add(parameter);
        }
        if (missing.size() > 0) {
            StringBuilder builder = new StringBuilder("XML request does not contain required ");
            builder.append(missing.size() == 1 ? "parameter:" : "parameters:");
            for (String parameter : missing) {
                builder.append(" '").append(parameter).append("'");
            }
            error = builder.toString();
        }
        return error;
    }

    private void doTransfer(Element xmlRequest, ResultMessage message) {
        String error = this.checkRequiredElements(xmlRequest, new String[]{TAG_DEST_PATH, TAG_JCA_URI, TAG_JCA_TICKET, TAG_SRC_FOLDER, TAG_ARCHIVE});
        if (error != null) {
            message.setIRMessage(IRMessage.INVALID_OR_MISSING_XML, new Object[]{error});
            return;
        }
        String destPath = this.getTextValue(xmlRequest, TAG_DEST_PATH);
        String jcaUri = this.getTextValue(xmlRequest, TAG_JCA_URI);
        String jcaTicket = this.getTextValue(xmlRequest, TAG_JCA_TICKET);
        String srcFolder = this.getTextValue(xmlRequest, TAG_SRC_FOLDER);
        String archiveName = this.getTextValue(xmlRequest, TAG_ARCHIVE);
        if (message.isSuccess()) {
            try {
                ConnectionImpl connection = this.getBackendConnection(jcaUri, jcaTicket);
                try {
                    this.copyArchiveToBackend(srcFolder + "\\" + archiveName, destPath, connection);
                }
                catch (IOException | ResourceException e) {
                    message.setIRMessage(IRMessage.ARCHIVE_MISSING, new Object[]{archiveName});
                    message.setLogDescription(archiveName + ": " + e.getMessage());
                }
            }
            catch (IRException ex) {
                message.setIRMessage(IRMessage.TRANSFER_IRPACK_FAILED, new Object[0]);
                message.setLogDescription("Failed to open connection to JCA URI '" + jcaUri + "'");
            }
        }
    }

    private void copyArchiveToBackend(String srcArchive, String destFolder, ConnectionImpl connection) throws IOException, ResourceException {
        int len;
        OutputStream destStream = connection.openForWrite(destFolder, false);
        FileInputStream inputStream = new FileInputStream(srcArchive + ZIP_EXTENSION);
        byte[] buf = new byte[1024];
        while ((len = inputStream.read(buf)) > 0) {
            destStream.write(buf, 0, len);
        }
        inputStream.close();
        destStream.close();
    }

    private void doCreateDeployment(Element xmlRequest, ResultMessage message) {
        String error = this.checkRequiredElements(xmlRequest, new String[]{TAG_SRC_PACKAGE, TAG_IR_ADDRESS, TAG_IR_CREDENTIALS});
        if (error != null) {
            message.setIRMessage(IRMessage.INVALID_OR_MISSING_XML, new Object[]{error});
            return;
        }
        String irAddress = this.getTextValue(xmlRequest, TAG_IR_ADDRESS);
        String credentialString = this.getTextValue(xmlRequest, TAG_IR_CREDENTIALS);
        NodeList srcPackages = xmlRequest.getElementsByTagName(TAG_SRC_PACKAGE);
        StringBuilder errorMessage = new StringBuilder();
        CognosReportServer reportServer = null;
        try {
            reportServer = new CognosReportServer(irAddress);
        }
        catch (Exception ex) {
            message.setIRMessage(IRMessage.COMMUNICATION_FAILURE_REPORT_SERVER, new Object[0]);
            return;
        }
        try {
            reportServer.logon(credentialString);
        }
        catch (IRException ex) {
            message.setIRException(ex);
            return;
        }
        for (int i = 0; i < srcPackages.getLength(); ++i) {
            Element source = (Element)srcPackages.item(i);
            String reportFolder = source.getTextContent();
            String archiveName = source.getAttribute(TAG_ARCHIVE);
            if (archiveName == null || archiveName.isEmpty()) {
                message.setIRMessage(IRMessage.TRANSFER_IRPACK_FAILED, new Object[0]);
                errorMessage.append("\n").append("Target archive name is missing for report folder '").append(reportFolder).append("'");
                continue;
            }
            try {
                reportServer.exportReport(archiveName, reportFolder, true);
                continue;
            }
            catch (IRException ex) {
                message.setIRException(ex);
            }
        }
        try {
            reportServer.logoff();
        }
        catch (IRException iRException) {
            // empty catch block
        }
    }
}

