/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector;

import com.infor.erpln.ir.connector.AbstractConnector;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.ResultMessage;
import com.infor.erpln.ir.connector.caching.Datafile;
import com.infor.erpln.ir.connector.caching.RetentionMap;
import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.soap.XMLUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class CallFunction
extends AbstractConnector {
    private static final long serialVersionUID = 1L;
    private static Logger logger = ESAPI.getLogger(CallFunction.class);
    private static Encoder encoder = ESAPI.encoder();

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!request.isRequestedSessionIdFromCookie()) {
            logger.error(Logger.EVENT_FAILURE, "\"/call\" was invoked without JSESSIONID cookie");
        }
        byte[] xmlData = new byte[request.getContentLength()];
        try (ServletInputStream sis = request.getInputStream();
             BufferedInputStream bis = new BufferedInputStream((InputStream)sis);){
            bis.read(xmlData, 0, xmlData.length);
        }
        ResultMessage resultMessage = new ResultMessage(IRMessage.OK, new Object[0]);
        String callResult = "";
        String xmlResponse = "";
        String methodName = "";
        try {
            DocumentBuilderFactory factory = XMLUtil.getSecureDocumentBuilderFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new ByteArrayInputStream(xmlData));
            Document doc = builder.parse(is);
            Element reqElement = (Element)doc.getElementsByTagName("callRequest").item(0);
            String datafile = this.getNodeValue(reqElement, "datafile");
            String libraryName = this.getNodeValue(reqElement, "dll");
            methodName = this.getNodeValue(reqElement, "method");
            String dllRequest = this.nodeToString(reqElement, "constructor");
            try {
                callResult = this.callFunction(datafile, libraryName, methodName, dllRequest);
            }
            catch (ResourceException e) {
                resultMessage.setIRMessage(IRMessage.UNABLE_TO_EXECUTE_FUNCTION, new Object[]{e.getMessage()});
                logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)e);
            }
        }
        catch (Exception ex) {
            resultMessage.setIRMessage(IRMessage.INVALID_OR_MISSING_XML, new Object[]{ex.getMessage()});
            logger.error(Logger.EVENT_FAILURE, resultMessage.getLogDescription(), (Throwable)ex);
        }
        xmlResponse = this.constructResponseMessage(resultMessage, methodName, callResult);
        response.setContentType("text/xml; charset=UTF-8");
        try (PrintWriter out = response.getWriter();){
            out.write(xmlResponse);
        }
    }

    private String callFunction(String fileName, String libraryName, String methodName, String xmlReq) throws ResourceException {
        String callResult = "";
        ServletContext sc = this.getServletContext();
        RetentionMap datafiles = (RetentionMap)sc.getAttribute("datafiles");
        Datafile dataFile = (Datafile)datafiles.get((Object)fileName);
        ConnectionImpl connection = dataFile.getConnection();
        byte[] requestBytes = xmlReq.getBytes(StandardCharsets.UTF_8);
        byte[] results = connection.executeBaanDll(requestBytes, new Vector());
        String resultString = new String(results, StandardCharsets.UTF_8);
        callResult = resultString.replaceAll("\\<\\?xml(.+?)\\?\\>", "").trim();
        if (logger.isInfoEnabled()) {
            logger.info(Logger.EVENT_SUCCESS, String.format("Back-end call for library %s and method %s succeeds.", libraryName, methodName));
        }
        return callResult;
    }

    private String constructResponseMessage(ResultMessage resultMessage, String methodName, String callResult) {
        String response = "<callResponse><status>" + resultMessage.getCode() + "</status><message>" + encoder.encodeForXML(resultMessage.getUserDescription()) + "</message>";
        if (resultMessage.getCode() == IRMessage.OK.messageCode()) {
            response = response + "<dllResponse>" + callResult + "</dllResponse>";
        }
        response = response + "</callResponse>";
        return response;
    }
}

