/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.ir.connector;

import com.infor.erpln.ir.connector.IRException;
import com.infor.erpln.ir.connector.IRMessage;
import com.infor.erpln.ir.connector.connection.ConnectionCacheHelper;
import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.soap.XMLUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Timer;
import java.util.regex.PatternSyntaxException;
import javax.resource.ResourceException;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AbstractConnector
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger logger = ESAPI.getLogger(AbstractConnector.class);

    public String getXmlContent(HttpServletRequest request) throws IOException {
        byte[] xmlData = new byte[request.getContentLength()];
        ServletInputStream sis = request.getInputStream();
        BufferedInputStream bis = new BufferedInputStream((InputStream)sis);
        bis.read(xmlData, 0, xmlData.length);
        return new String(xmlData);
    }

    public ConnectionImpl getBackendConnection(String jcaUri, String jcaTicket) throws IRException {
        ServletContext sc = this.getServletContext();
        Hashtable bshellConnections = (Hashtable)sc.getAttribute("bshellConnections");
        if (bshellConnections == null) {
            logger.error(Logger.EVENT_FAILURE, "BShell connections not found in servletContext");
            throw new IRException(IRMessage.CANNOT_OPEN_CONNECTION, new Object[0]);
        }
        Timer timer = (Timer)sc.getAttribute("scheduledTasks");
        if (timer == null) {
            logger.error(Logger.EVENT_FAILURE, "timer not found in servletContext");
            throw new IRException(IRMessage.CANNOT_OPEN_CONNECTION, new Object[0]);
        }
        ConnectionCacheHelper connectionCacheHelper = new ConnectionCacheHelper(bshellConnections, timer, jcaUri, jcaTicket);
        ConnectionImpl bshellConnection = null;
        try {
            bshellConnection = connectionCacheHelper.getConnection();
        }
        catch (PatternSyntaxException mue) {
            logger.error(Logger.EVENT_FAILURE, IRMessage.MALFORMED_URI.getLogMessage(new Object[0]), (Throwable)mue);
            throw new IRException(IRMessage.MALFORMED_URI, new Object[0]);
        }
        catch (ResourceException re) {
            logger.error(Logger.EVENT_FAILURE, IRMessage.CANNOT_OPEN_CONNECTION.getLogMessage(new Object[0]), (Throwable)re);
            throw new IRException(IRMessage.CANNOT_OPEN_CONNECTION, new Object[0]);
        }
        return bshellConnection;
    }

    public void closeBackendConnection(String jcaUri, String jcaTicket) {
        ConnectionCacheHelper connectionCacheHelper;
        Timer timer;
        ServletContext sc = this.getServletContext();
        Hashtable bshellConnections = (Hashtable)sc.getAttribute("bshellConnections");
        if (bshellConnections == null) {
            logger.error(Logger.EVENT_FAILURE, "BShell connections not found in servletContext");
        }
        if ((timer = (Timer)sc.getAttribute("scheduledTasks")) == null) {
            logger.error(Logger.EVENT_FAILURE, "timer not found in servletContext");
        }
        if (timer != null && bshellConnections != null && (connectionCacheHelper = new ConnectionCacheHelper(bshellConnections, timer, jcaUri, jcaTicket)).isPresent()) {
            connectionCacheHelper.closeConnection();
        }
    }

    public String getNodeValue(Element element, String tagName) {
        String nodeValue = "";
        Node namedItem = element.getElementsByTagName(tagName).item(0);
        if (null != namedItem) {
            nodeValue = namedItem.getTextContent();
        }
        return nodeValue;
    }

    public String nodeToString(Element element, String tagName) throws IRException {
        Node node = element.getElementsByTagName(tagName).item(0);
        try {
            return this.domNodeToString(node);
        }
        catch (TransformerException te) {
            logger.error(Logger.EVENT_FAILURE, IRMessage.UNABLE_TO_PARSE_DLL_REQUEST.getLogMessage(new Object[]{te.getMessage()}), (Throwable)te);
            throw new IRException(IRMessage.UNABLE_TO_PARSE_DLL_REQUEST, new Object[]{te.getMessage()});
        }
    }

    public String domNodeToString(Node node) throws TransformerException {
        StringWriter sw = new StringWriter();
        Transformer t = XMLUtil.getSecureTransformerFactory().newTransformer();
        t.setOutputProperty("omit-xml-declaration", "yes");
        t.transform(new DOMSource(node), new StreamResult(sw));
        return sw.toString();
    }
}

