/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.c4ws.util.oauth;

import com.infor.erpln.c4ws.util.oauth.OAuthUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

class Rfc5849Parameters {
    private final SortedMap<String, String> m_parameters = new TreeMap();

    Rfc5849Parameters() {
    }

    public void addFromQueryString(String queryString) throws UnsupportedEncodingException {
        if (StringUtils.isNotBlank((String)queryString)) {
            String[] elements;
            String decoded = URLDecoder.decode(queryString, "UTF-8");
            for (String element : elements = StringUtils.split((String)decoded, (char)'&')) {
                int separator = element.indexOf(61);
                if (separator == -1) {
                    separator = element.length();
                }
                this.m_parameters.put(element.substring(0, separator), separator < element.length() - 1 ? element.substring(separator + 1) : "");
            }
        }
    }

    public void addFromOAuthHeader(Map<String, String> fields) {
        this.m_parameters.putAll(fields);
    }

    public void addFromRequestBody(String body) {
        throw new UnsupportedOperationException();
    }

    public String getNormalized() {
        StringBuilder normalized = new StringBuilder();
        for (Map.Entry entry : this.m_parameters.entrySet()) {
            if (normalized.length() > 0) {
                normalized.append('&');
            }
            normalized.append(OAuthUtil.percentEncode((String)((String)entry.getKey()))).append('=');
            if (!StringUtils.isNotBlank((String)((String)entry.getValue()))) continue;
            normalized.append(OAuthUtil.percentEncode((String)((String)entry.getValue())));
        }
        return normalized.toString();
    }
}

