/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.c4ws.util.oauth;

import com.infor.erpln.c4ws.util.oauth.Authenticator;
import com.infor.erpln.c4ws.util.oauth.OAuthUtil;
import com.infor.erpln.c4ws.util.oauth.UsedNonce;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class OAuthHeader {
    private static final String OAUTH_VERSION = "1.0";
    private static final String OAUTH_HEADER = "OAuth";
    private final boolean m_valid;
    private final Map<String, String> m_fields = new HashMap();
    private UsedNonce m_usedNonce;
    private String m_signature;
    private Authenticator.HmacType m_hmacType;

    private OAuthHeader(String headerString) {
        boolean valid = false;
        if (headerString != null && headerString.startsWith(OAUTH_HEADER)) {
            try {
                String[] keyValues;
                Pattern pattern = Pattern.compile("(oauth_[a-z_]+)=\"(\\S+)\"");
                block8: for (String keyValue : keyValues = StringUtils.split((String)headerString.substring(OAUTH_HEADER.length()), (char)',')) {
                    Matcher matcher = pattern.matcher(keyValue.trim());
                    if (!matcher.matches()) continue;
                    String name = matcher.group(1);
                    String value = OAuthUtil.decodePercent((String)matcher.group(2));
                    switch (name) {
                        case "oauth_signature": {
                            this.m_signature = value;
                            continue block8;
                        }
                        default: {
                            this.m_fields.put(name, value);
                        }
                    }
                }
                this.m_usedNonce = new UsedNonce(Long.parseLong((String)this.m_fields.get("oauth_timestamp")), (String)this.m_fields.get("oauth_nonce"));
                this.m_hmacType = Authenticator.HmacType.parse((String)((String)this.m_fields.get("oauth_signature_method")));
                valid = this.m_fields.get("oauth_version") == null || OAUTH_VERSION.equals(this.m_fields.get("oauth_version"));
            }
            catch (IllegalArgumentException e) {
                valid = false;
            }
        }
        this.m_valid = valid;
    }

    public static OAuthHeader getInstance(String headerContents) {
        return new OAuthHeader(headerContents);
    }

    public boolean isValid() {
        return this.m_valid;
    }

    public String getSignature() {
        return this.m_signature;
    }

    public Authenticator.HmacType getHmacType() {
        return this.m_hmacType;
    }

    public String getKey() {
        return (String)this.m_fields.get("oauth_consumer_key");
    }

    public long getTimestamp() {
        return Long.parseLong((String)this.m_fields.get("oauth_timestamp"));
    }

    public UsedNonce getUsedNonce() {
        return this.m_usedNonce;
    }

    public Map<String, String> getFields() {
        return Collections.unmodifiableMap(this.m_fields);
    }
}

