/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.c4ws.util.oauth;

import com.infor.erpln.c4ws.util.oauth.Authenticator;
import com.infor.erpln.c4ws.util.oauth.AuthorizationStatus;
import com.infor.erpln.c4ws.util.oauth.Clock;
import com.infor.erpln.c4ws.util.oauth.OAuthHeader;
import com.infor.erpln.c4ws.util.oauth.OAuthUtil;
import com.infor.erpln.c4ws.util.oauth.Rfc5849Parameters;
import com.infor.erpln.c4ws.util.oauth.UsedNonceCache;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.Locale;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class Authenticator {
    private static final Logger LOG = ESAPI.getLogger(Authenticator.class);
    private static final int MAX_CLOCK_SKEW = 900;
    private final UsedNonceCache m_nonceCache = new UsedNonceCache(900);
    private String m_key;
    private String m_secret;
    private Clock m_clock;

    public static Authenticator getInstance(String key, String secret) {
        Object authenticator = key.isEmpty() ? new /* Unavailable Anonymous Inner Class!! */ : new Authenticator(key, secret);
        return authenticator;
    }

    public AuthorizationStatus verify(String method, String rawBaseUri, String headerValue) {
        return this.verify(method, rawBaseUri, null, headerValue);
    }

    public AuthorizationStatus verify(String method, String rawBaseUri, String queryString, String headerValue) {
        AuthorizationStatus apiStatus;
        block14: {
            apiStatus = new AuthorizationStatus().badRequest("Missing or unsupported parameters");
            OAuthHeader oauthHeader = OAuthHeader.getInstance((String)headerValue);
            if (oauthHeader.isValid()) {
                try {
                    String signature;
                    Rfc5849Parameters parameters = new Rfc5849Parameters();
                    parameters.addFromQueryString(queryString);
                    parameters.addFromOAuthHeader(oauthHeader.getFields());
                    StringBuilder signatureBase = new StringBuilder();
                    signatureBase.append(method.toUpperCase(Locale.getDefault())).append('&');
                    signatureBase.append(OAuthUtil.percentEncode((String)rawBaseUri)).append('&');
                    signatureBase.append(OAuthUtil.percentEncode((String)parameters.getNormalized()));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(Logger.EVENT_UNSPECIFIED, "Signature base string: " + signatureBase.toString());
                    }
                    if (!(signature = Signature.calculateRFC2104HMAC((String)signatureBase.toString(), (String)this.getSigningKey(), (HmacType)oauthHeader.getHmacType())).equals(oauthHeader.getSignature())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(Logger.EVENT_FAILURE, "Signature '" + oauthHeader.getSignature() + "' does not match calculated '" + signature + "'");
                        }
                        apiStatus.unauthorized("Invalid signature");
                        break block14;
                    }
                    if (!oauthHeader.getKey().equals(this.m_key)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(Logger.EVENT_FAILURE, "Client credential '" + oauthHeader.getKey() + "' does not match configured '" + this.m_key + "'");
                        }
                        apiStatus.unauthorized("Invalid client credentials");
                        break block14;
                    }
                    if (!this.isValidTimestamp(oauthHeader.getTimestamp())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(Logger.EVENT_FAILURE, "Timestamp is not valid: " + new Date(oauthHeader.getTimestamp() * 1000L));
                        }
                        apiStatus.unauthorized("Invalid timestamp");
                        break block14;
                    }
                    if (!this.m_nonceCache.update(oauthHeader.getUsedNonce())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(Logger.EVENT_FAILURE, "Nonce '" + oauthHeader.getUsedNonce() + "' is not valid");
                        }
                        apiStatus.unauthorized("Invalid or used nonce");
                        break block14;
                    }
                    LOG.debug(Logger.EVENT_SUCCESS, "OAuth signature OK");
                    apiStatus.ok();
                }
                catch (UnsupportedEncodingException | GeneralSecurityException e) {
                    LOG.error(Logger.EVENT_FAILURE, "Exception when calculating OAuth signature:", (Throwable)e);
                    apiStatus.badRequest(e.getMessage());
                }
            } else if (LOG.isInfoEnabled()) {
                LOG.info(Logger.EVENT_FAILURE, "Authorization header is not valid: " + headerValue);
            }
        }
        return apiStatus;
    }

    private boolean isValidTimestamp(long timestamp) {
        return Math.abs(this.m_clock.getTime() - timestamp) < 900L;
    }

    private String getSigningKey() {
        return OAuthUtil.percentEncode((String)this.m_secret) + "&";
    }

    private Authenticator(String key, String secret) {
        this.m_key = key;
        this.m_secret = secret;
        this.m_clock = new /* Unavailable Anonymous Inner Class!! */;
    }

    private Authenticator() {
        this("", "");
    }

    void setClock(Clock clock) {
        this.m_clock = clock;
    }
}

