/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.c4ws.util;

import com.infor.erpln.c4ws.util.C4WSProperties;
import com.infor.erpln.c4ws.util.C4WSPropertiesManager;
import com.infor.erpln.c4ws.util.LNEnvironment;
import com.infor.erpln.util.ConnectionPoint;
import com.infor.erpln.util.ConnectionPointActivation;
import com.infor.erpln.util.ConnectionPointsManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class MigrationUtil {
    private static final Logger LOG = ESAPI.getLogger(MigrationUtil.class);
    private static final String PREFIX = new String(new char[]{'?', '\b', '\r', '\u001b', '\u0000', '?'});

    public static void migrateConnectionpoints(C4WSPropertiesManager propertiesManager) {
        C4WSProperties c4wsProperties = propertiesManager.getProperties();
        String configFolder = c4wsProperties.getConfigFolder();
        File connectionpointsFile = new File(configFolder, "connectionpoints.xml");
        if (!connectionpointsFile.exists()) {
            LOG.debug(Logger.EVENT_SUCCESS, "'connectionpoints.xml' not found; no migration needed");
            return;
        }
        ConnectionPointsManager manager = new ConnectionPointsManager();
        manager.setConnectionPointsLocation(connectionpointsFile.getPath());
        manager.load();
        Collection connectionpoints = manager.getConnectionPoints().values();
        int nrPoints = connectionpoints.size();
        if (nrPoints == 0) {
            LOG.info(Logger.EVENT_SUCCESS, "No migration needed ('connectionpoints.xml' does not contain any connection points)");
        } else {
            LOG.info(Logger.EVENT_UNSPECIFIED, String.format("Start migration of %d connection point(s) in 'connectionpoints.xml'", nrPoints));
            ArrayList<LNEnvironment> toBeCopied = new ArrayList<LNEnvironment>();
            for (ConnectionPoint cp : connectionpoints) {
                LNEnvironment env = MigrationUtil.toLNEnvironment((ConnectionPoint)cp);
                if (MigrationUtil.connectionpointExists((String)cp.getName(), (C4WSProperties)c4wsProperties)) {
                    if (MigrationUtil.environmentMatches((LNEnvironment)env, (C4WSProperties)c4wsProperties)) {
                        LOG.info(Logger.EVENT_SUCCESS, String.format("Connectionpoint '%s' is already present in the new configuration file", env.getName()));
                        continue;
                    }
                    LOG.warning(Logger.EVENT_FAILURE, String.format("Connectionpoint '%s' was NOT merged into the new configuration file. It already exists with different settings", env.getName()));
                    continue;
                }
                toBeCopied.add(env);
            }
            c4wsProperties = propertiesManager.getEditableProperties();
            for (LNEnvironment env : toBeCopied) {
                String environmentName = env.getName();
                LOG.info(Logger.EVENT_UNSPECIFIED, String.format("Adding connection point '%s' to the configuration file", environmentName));
                c4wsProperties.setEnvironmentForID(environmentName, env);
                c4wsProperties.addEnvironmentMapping(environmentName, environmentName);
            }
            try {
                propertiesManager.saveProperties(c4wsProperties);
            }
            catch (C4WSProperties.UpdateException e) {
                LOG.error(Logger.EVENT_FAILURE, "Failed to save the 'c4wsProperties.xml' file");
                return;
            }
        }
        String fileName = "old_connectionpoints.xml";
        File renamedFile = new File(configFolder, fileName);
        int i = 0;
        while (renamedFile.exists()) {
            renamedFile = new File(configFolder, fileName + String.valueOf(++i));
        }
        boolean success = false;
        try {
            success = connectionpointsFile.renameTo(renamedFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (success) {
            LOG.info(Logger.EVENT_SUCCESS, "Migration completed: 'connectionpoints.xml' has been renamed to '" + renamedFile.getName() + "'");
        } else {
            LOG.error(Logger.EVENT_FAILURE, "Failed to rename 'connectionpoints.xml'. Please rename the file manually to prevent repeated migration attempts");
        }
    }

    private static boolean environmentMatches(LNEnvironment env, C4WSProperties c4wsProperties) {
        LNEnvironment other = c4wsProperties.getEnvironmentForID(env.getName());
        return env.getActivation().equals(other.getActivation()) && env.getBSE().equals(other.getBSE()) && env.getBshell().equals(other.getBshell()) && env.getCommand().equals(other.getCommand()) && env.getEncryptedPassword().equals(other.getEncryptedPassword()) && env.getHost().equals(other.getHost()) && env.getUser().equals(other.getUser()) && env.isAnonymousAllowed() == other.isAnonymousAllowed() && env.getCompany() == other.getCompany() && env.getKeepAlive() == other.getKeepAlive() && env.getMaxConnections() == other.getMaxConnections() && env.getMaxReferences() == other.getMaxReferences() && env.getMaxThreads() == other.getMaxThreads() && env.getPort() == other.getPort() && env.isTraceBackend() == other.isTraceBackend();
    }

    private static boolean connectionpointExists(String name, C4WSProperties c4wsProperties) {
        boolean connectionpointExists = c4wsProperties.getEnvironmentMapping().containsKey(name);
        boolean environmentExists = c4wsProperties.getAllEnvironments().contains(name);
        return connectionpointExists || environmentExists;
    }

    private static LNEnvironment toLNEnvironment(ConnectionPoint connectionpoint) {
        String cleartextPassword;
        LNEnvironment result = new LNEnvironment(connectionpoint.getName());
        ConnectionPointActivation activation = connectionpoint.getActivation();
        result.setActivation(activation.getActivationType());
        result.setPort(connectionpoint.getPort());
        result.setCompany(activation.getActivationCompany());
        result.setMaxConnections(connectionpoint.getMaxConnections());
        result.setMaxReferences(connectionpoint.getMaxReferences());
        result.setMaxThreads(connectionpoint.getMaxThreads());
        result.setKeepAlive(connectionpoint.getTimerDelay());
        result.setTraceBackend("-trace".equals(activation.getActivationDaemonOptions()));
        String nonNullValue = connectionpoint.getHostName();
        if (nonNullValue != null) {
            result.setHost(nonNullValue);
        }
        if ((nonNullValue = activation.getActivationUser()) != null) {
            result.setUser(nonNullValue);
        }
        if ((cleartextPassword = activation.getActivationPassword()) != null) {
            if (cleartextPassword.startsWith(PREFIX)) {
                result.setAnonymousAllowed(false);
                cleartextPassword = cleartextPassword.substring(6);
            } else {
                result.setAnonymousAllowed(true);
            }
            result.setCleartextPassword(cleartextPassword);
        }
        if ((nonNullValue = activation.getActivationBse()) != null) {
            result.setBSE(nonNullValue);
        }
        if ((nonNullValue = activation.getActivationBshell()) != null) {
            result.setBshell(nonNullValue);
        }
        if ((nonNullValue = activation.getActivationEnvironment()) != null) {
            result.setCommand(nonNullValue);
        }
        return result;
    }
}

