/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.c4ws.util;

import java.lang.reflect.Method;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class KmsUtil {
    private static KmsUtil s_theInstance;
    private static final Logger LOG;
    private Class<?> m_utilClazz;

    public static KmsUtil getInstance() {
        if (s_theInstance == null) {
            s_theInstance = new KmsUtil();
        }
        return s_theInstance;
    }

    public String kmsEncrypt(String plaintext) {
        if (this.m_utilClazz != null) {
            try {
                Method method = this.m_utilClazz.getMethod("kmsEncrypt", String.class);
                Object retval = method.invoke(null, plaintext);
                if (retval instanceof String) {
                    return (String)retval;
                }
            }
            catch (Exception e) {
                LOG.error(Logger.EVENT_FAILURE, "Failed call com.infor.eln.fips.Util.kmsEncrypt()", (Throwable)e);
            }
        }
        return "";
    }

    public String kmsDecrypt(String base64Encrypted) {
        if (this.m_utilClazz != null) {
            try {
                Method method = this.m_utilClazz.getMethod("kmsDecrypt", String.class);
                Object retval = method.invoke(null, base64Encrypted);
                if (retval instanceof String) {
                    return (String)retval;
                }
            }
            catch (Exception e) {
                LOG.error(Logger.EVENT_FAILURE, "Failed call com.infor.eln.fips.Util.kmsDecrypt()", (Throwable)e);
            }
        }
        return "";
    }

    private KmsUtil() {
        try {
            this.m_utilClazz = Class.forName("com.infor.eln.fips.Util");
        }
        catch (ClassNotFoundException e) {
            LOG.error(Logger.EVENT_FAILURE, "Class com.infor.eln.fips.Util not found", (Throwable)e);
        }
    }

    static {
        LOG = ESAPI.getLogger(KmsUtil.class);
    }
}

